/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines.csv;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;
import org.apache.openaz.xacml.std.pip.engines.Configurables;
import org.apache.openaz.xacml.std.pip.engines.csv.CSVResolver;
import org.apache.openaz.xacml.util.FactoryException;

public class ConfigurableCSVResolver
implements CSVResolver {
    public static final String PROP_PARAMETERS = "parameters";
    public static final String PROP_ID = "id";
    public static final String PROP_DATATYPE = "datatype";
    public static final String PROP_CATEGORY = "category";
    public static final String PROP_ISSUER = "issuer";
    public static final String PROP_COLUMN = "column";
    private static DataTypeFactory dataTypeFactory = null;
    protected Log logger = LogFactory.getLog(this.getClass());
    private String id;
    private String defaultIssuer;
    private Map<Integer, PIPRequest> parameterMap = new HashMap<Integer, PIPRequest>();
    private Map<Integer, PIPRequest> fieldMap = new HashMap<Integer, PIPRequest>();

    private void readSearchParameters(String id, Properties properties) throws PIPException {
        String parameterNamesString = properties.getProperty(id + "." + PROP_PARAMETERS);
        if (parameterNamesString == null || parameterNamesString.length() == 0) {
            String message = id + ".parameters must not be empty";
            this.logger.error((Object)message);
            throw new PIPException(message);
        }
        for (String parameterName : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)parameterNamesString)) {
            int column;
            String parameterIdPrefix = id + ".parameter." + parameterName;
            String tmpString = properties.getProperty(parameterIdPrefix + "." + PROP_COLUMN);
            if (tmpString == null || tmpString.length() == 0) {
                String message = id + ": parameter " + parameterName + " missing number for '.column'";
                this.logger.error((Object)message);
                throw new PIPException(message);
            }
            try {
                column = Integer.parseInt(tmpString);
            }
            catch (NumberFormatException e) {
                String message = id + ": parameter " + parameterName + ".column is not a number in '" + tmpString + "'";
                this.logger.error((Object)message);
                throw new PIPException(message);
            }
            PIPRequest request = Configurables.getPIPRequest(parameterIdPrefix, properties, null);
            if (request != null) {
                this.parameterMap.put(column, request);
                continue;
            }
            String message = id + ": attribute not defined";
            this.logger.error((Object)message);
            throw new PIPException(message);
        }
    }

    private void readPIPRequestFieldDefinitions(String id, Properties properties) throws PIPException {
        String fieldNamesString = properties.getProperty(id + ".fields");
        if (fieldNamesString == null || fieldNamesString.length() == 0) {
            String message = id + ".fields must not be empty";
            this.logger.error((Object)message);
            throw new PIPException(message);
        }
        for (String fieldName : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)fieldNamesString)) {
            int column;
            String fieldIdPrefix = id + ".field." + fieldName;
            String tmpString = properties.getProperty(fieldIdPrefix + "." + PROP_COLUMN);
            if (tmpString == null || tmpString.length() == 0) {
                String message = id + ": field " + fieldName + " missing number for '.column'";
                this.logger.error((Object)message);
                throw new PIPException(message);
            }
            try {
                column = Integer.parseInt(tmpString);
            }
            catch (NumberFormatException e) {
                String message = id + ": field " + fieldName + ".column is not a number in '" + tmpString + "'";
                this.logger.error((Object)message);
                throw new PIPException(message);
            }
            PIPRequest pipRequest = Configurables.getPIPRequest(fieldIdPrefix, properties, this.defaultIssuer);
            if (pipRequest != null) {
                this.fieldMap.put(column, pipRequest);
                continue;
            }
            String message = id + ": attribute not defined column " + column;
            this.logger.error((Object)message);
            throw new PIPException(message);
        }
    }

    @Override
    public void configure(String id, Properties properties, String defaultIssuer) throws PIPException {
        this.id = id;
        this.defaultIssuer = defaultIssuer;
        this.readSearchParameters(id, properties);
        this.readPIPRequestFieldDefinitions(id, properties);
    }

    @Override
    public void attributesRequired(Collection<PIPRequest> parameters) {
        for (Integer key : this.parameterMap.keySet()) {
            parameters.add(new StdPIPRequest(this.parameterMap.get(key)));
        }
    }

    @Override
    public void attributesProvided(Collection<PIPRequest> attributes) {
        for (Integer key : this.fieldMap.keySet()) {
            attributes.add(new StdPIPRequest(this.fieldMap.get(key)));
        }
    }

    @Override
    public boolean supportRequest(PIPRequest pipRequest) {
        for (Integer key : this.fieldMap.keySet()) {
            PIPRequest request = this.fieldMap.get(key);
            if (pipRequest == null) {
                return false;
            }
            if (!request.equals(pipRequest)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this.id + " supports " + pipRequest));
            }
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.id + " does NOT support " + pipRequest));
        }
        return false;
    }

    @Override
    public Map<Integer, List<AttributeValue<?>>> getColumnParameterValues(PIPEngine engine, PIPRequest request, PIPFinder finder) throws PIPException {
        HashMap map = new HashMap();
        for (Integer column : this.parameterMap.keySet()) {
            PIPRequest requestParameter = this.parameterMap.get(column);
            PIPResponse pipResponse = finder.getMatchingAttributes(requestParameter, null);
            if (pipResponse == null || !pipResponse.getStatus().isOk() || pipResponse == StdPIPResponse.PIP_RESPONSE_EMPTY) {
                return null;
            }
            ArrayList values = new ArrayList();
            for (Attribute attr : pipResponse.getAttributes()) {
                values.addAll(attr.getValues());
            }
            map.put(column, values);
        }
        return map;
    }

    @Override
    public List<Attribute> decodeResult(String[] line) throws PIPException {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (Integer column : this.fieldMap.keySet()) {
            if (column >= line.length) {
                return null;
            }
            String value = line[column];
            if (value.length() == 0) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Column " + column + " does not have a value."));
                continue;
            }
            PIPRequest request = this.fieldMap.get(column);
            StdMutableAttribute attribute = null;
            for (Attribute a : attributeList) {
                if (a.getCategory() != request.getCategory() || a.getAttributeId() != request.getAttributeId()) continue;
                attribute = (StdMutableAttribute)a;
            }
            if (attribute == null) {
                attribute = new StdMutableAttribute();
                attribute.setCategory(request.getCategory());
                attribute.setAttributeId(request.getAttributeId());
                attribute.setIssuer(request.getIssuer());
                attributeList.add(attribute);
            }
            DataType<?> dt = dataTypeFactory.getDataType(request.getDataTypeId());
            try {
                attribute.addValue(dt.createAttributeValue(value));
            }
            catch (DataTypeException e) {
                String message = this.id + ": " + e.getLocalizedMessage();
                this.logger.error((Object)message);
                return null;
            }
        }
        return attributeList;
    }

    static {
        try {
            dataTypeFactory = DataTypeFactory.newInstance();
        }
        catch (FactoryException fx) {
            throw new RuntimeException(fx);
        }
    }
}

