/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;
import org.apache.openaz.xacml.std.pip.engines.ConfigurableEngine;
import org.apache.openaz.xacml.util.FactoryException;

public class XacmlCSVEngine
implements ConfigurableEngine {
    public static final String PROP_DESCRIPTION = ".description";
    public static final String PROP_FILE = ".file";
    private static final Log logger = LogFactory.getLog(XacmlCSVEngine.class);
    private String name;
    private String description;
    private Map<String, PIPResponse> cache = new HashMap<String, PIPResponse>();
    private List<Attribute> listAttributes = new ArrayList<Attribute>();
    private DataTypeFactory dataTypeFactory;

    protected DataTypeFactory getDataTypeFactory() throws FactoryException {
        if (this.dataTypeFactory == null) {
            this.dataTypeFactory = DataTypeFactory.newInstance();
        }
        return this.dataTypeFactory;
    }

    protected static String generateKey(PIPRequest pipRequest) {
        StringBuilder stringBuilder = new StringBuilder(pipRequest.getCategory().toString());
        stringBuilder.append('+');
        stringBuilder.append(pipRequest.getAttributeId().toString());
        stringBuilder.append('+');
        stringBuilder.append(pipRequest.getDataTypeId().toString());
        String issuer = pipRequest.getIssuer();
        if (issuer != null) {
            stringBuilder.append('+');
            stringBuilder.append(issuer);
        }
        return stringBuilder.toString();
    }

    protected void store(String[] fields) throws FactoryException {
        DataTypeFactory thisDataTypeFactory = this.getDataTypeFactory();
        IdentifierImpl identifierCategory = new IdentifierImpl(fields[0]);
        IdentifierImpl identifierAttribute = new IdentifierImpl(fields[1]);
        IdentifierImpl identifierDataType = new IdentifierImpl(fields[2]);
        String issuer = fields.length == 5 ? fields[3] : null;
        String value = fields[fields.length - 1];
        DataType<?> dataType = thisDataTypeFactory.getDataType(identifierDataType);
        if (dataType == null) {
            logger.error((Object)("Unknown data type " + identifierDataType.stringValue()));
            return;
        }
        AttributeValue<?> attributeValue = null;
        try {
            attributeValue = dataType.createAttributeValue(value);
        }
        catch (DataTypeException ex) {
            throw new FactoryException("DataTypeException creating AttributeValue", ex);
        }
        StdMutableAttribute attribute = new StdMutableAttribute((Identifier)identifierCategory, (Identifier)identifierAttribute, attributeValue, issuer, false);
        this.listAttributes.add(attribute);
    }

    public void loadAttributes(File fileAttributes) throws IOException, ParseException, FactoryException {
        if (fileAttributes != null) {
            if (!fileAttributes.exists()) {
                throw new FileNotFoundException("Attributes file " + fileAttributes.getAbsolutePath() + " not found.");
            }
            if (!fileAttributes.canRead()) {
                throw new IOException("Attributes file " + fileAttributes.getAbsolutePath() + " is not readable.");
            }
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(fileAttributes)));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.length() <= 0) continue;
                    String[] fields = line.split("[|]", -1);
                    if (fields.length < 4) {
                        logger.warn((Object)("Not enough fields in record \"" + line + "\""));
                        continue;
                    }
                    this.store(fields);
                }
            }
        }
    }

    protected Attribute findAttribute(PIPRequest pipRequest) {
        Attribute attributeResult = null;
        Iterator<Attribute> iterAttributes = this.listAttributes.iterator();
        while (attributeResult == null && iterAttributes.hasNext()) {
            Attribute attributeTest = iterAttributes.next();
            if (!pipRequest.getCategory().equals(attributeTest.getCategory()) || !pipRequest.getAttributeId().equals(attributeTest.getAttributeId()) || pipRequest.getIssuer() != null && !pipRequest.getIssuer().equals(attributeTest.getIssuer())) continue;
            attributeResult = attributeTest;
        }
        return attributeResult;
    }

    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        Attribute attributeMatch;
        String pipRequestKey = XacmlCSVEngine.generateKey(pipRequest);
        PIPResponse pipResponse = this.cache.get(pipRequestKey);
        if (pipResponse == null && (attributeMatch = this.findAttribute(pipRequest)) != null) {
            ArrayList matchingValues = new ArrayList();
            for (AttributeValue<?> attributeValue : attributeMatch.getValues()) {
                if (!pipRequest.getDataTypeId().equals(attributeValue.getDataTypeId())) continue;
                matchingValues.add(attributeValue);
            }
            if (matchingValues.size() > 0) {
                StdMutableAttribute attributeResponse = new StdMutableAttribute(attributeMatch.getCategory(), attributeMatch.getAttributeId(), matchingValues, attributeMatch.getIssuer(), attributeMatch.getIncludeInResults());
                pipResponse = new StdPIPResponse(attributeResponse);
                this.cache.put(pipRequestKey, pipResponse);
            }
        }
        if (pipResponse == null) {
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        return pipResponse;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void configure(String id, Properties properties) throws PIPException {
        String pipFile;
        this.name = id;
        this.description = properties.getProperty(id + PROP_DESCRIPTION);
        if (this.description == null) {
            this.description = "PIPEngine for the Conformance tests that loads attributes from a CSV file";
        }
        if ((pipFile = properties.getProperty(id + PROP_FILE)) != null) {
            try {
                this.loadAttributes(new File(pipFile));
            }
            catch (Exception ex) {
                logger.error((Object)("Exception loading PIP file " + pipFile), (Throwable)ex);
                throw new PIPException("Exception loading PIP file " + pipFile, ex);
            }
        }
    }

    @Override
    public Collection<PIPRequest> attributesRequired() {
        return Collections.emptyList();
    }

    @Override
    public Collection<PIPRequest> attributesProvided() {
        return Collections.emptyList();
    }
}

