/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.finders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;
import org.apache.openaz.xacml.std.pip.engines.EnvironmentEngine;
import org.apache.openaz.xacml.std.pip.engines.RequestEngine;
import org.apache.openaz.xacml.std.pip.finders.WrappingFinder;

public class RequestFinder
extends WrappingFinder {
    private RequestEngine requestEngine;
    private EnvironmentEngine environmentEngine;
    private Map<PIPRequest, PIPResponse> mapCache = new HashMap<PIPRequest, PIPResponse>();

    protected RequestEngine getRequestEngine() {
        return this.requestEngine;
    }

    protected EnvironmentEngine getEnvironmentEngine() {
        return this.environmentEngine;
    }

    public RequestFinder(PIPFinder pipFinder, RequestEngine requestEngineIn) {
        super(pipFinder);
        this.requestEngine = requestEngineIn;
        this.environmentEngine = new EnvironmentEngine(new Date());
    }

    @Override
    protected PIPResponse getAttributesInternal(PIPRequest pipRequest, PIPEngine exclude, PIPFinder pipFinderRoot) throws PIPException {
        PIPResponse pipResponse = null;
        RequestEngine thisRequestEngine = this.getRequestEngine();
        Status status = null;
        if (thisRequestEngine != null && thisRequestEngine != exclude) {
            pipResponse = thisRequestEngine.getAttributes(pipRequest, pipFinderRoot == null ? this : pipFinderRoot);
            if (pipResponse.getStatus() == null || pipResponse.getStatus().isOk()) {
                if (pipResponse.getAttributes().size() > 0) {
                    return pipResponse;
                }
            } else {
                status = pipResponse.getStatus();
            }
        }
        if (XACML3.ID_ATTRIBUTE_CATEGORY_ENVIRONMENT.equals(pipRequest.getCategory()) && (pipRequest.getIssuer() == null || pipRequest.getIssuer().length() == 0)) {
            EnvironmentEngine thisEnvironmentEngine = this.getEnvironmentEngine();
            pipResponse = thisEnvironmentEngine.getAttributes(pipRequest, this);
            if (pipResponse.getStatus() == null || pipResponse.getStatus().isOk()) {
                if (pipResponse.getAttributes().size() > 0) {
                    return pipResponse;
                }
            } else if (status == null) {
                status = pipResponse.getStatus();
            }
        }
        if (this.mapCache.containsKey(pipRequest)) {
            return this.mapCache.get(pipRequest);
        }
        PIPFinder thisWrappedFinder = this.getWrappedFinder();
        if (thisWrappedFinder != null && (pipResponse = thisWrappedFinder.getAttributes(pipRequest, exclude, pipFinderRoot == null ? this : pipFinderRoot)) != null) {
            if (pipResponse.getStatus() == null || pipResponse.getStatus().isOk()) {
                if (pipResponse.getAttributes().size() > 0) {
                    Map<PIPRequest, PIPResponse> mapResponses = StdPIPResponse.splitResponse(pipResponse);
                    if (mapResponses != null && mapResponses.size() > 0) {
                        for (PIPRequest pipRequestSplit : mapResponses.keySet()) {
                            this.mapCache.put(pipRequestSplit, mapResponses.get(pipRequestSplit));
                        }
                    }
                    return pipResponse;
                }
            } else if (status == null || status.isOk()) {
                status = pipResponse.getStatus();
            }
        }
        if (status != null && !status.isOk()) {
            return new StdPIPResponse(status);
        }
        return StdPIPResponse.PIP_RESPONSE_EMPTY;
    }

    @Override
    public Collection<PIPEngine> getPIPEngines() {
        PIPFinder wrappedFinder;
        ArrayList<PIPEngine> engines = new ArrayList<PIPEngine>();
        if (this.requestEngine != null) {
            engines.add(this.requestEngine);
        }
        if (this.environmentEngine != null) {
            engines.add(this.environmentEngine);
        }
        if ((wrappedFinder = this.getWrappedFinder()) != null) {
            engines.addAll(wrappedFinder.getPIPEngines());
        }
        return Collections.unmodifiableList(engines);
    }
}

