/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjUtil {
    private static final Log logger = LogFactory.getLog(ObjUtil.class);

    protected ObjUtil() {
    }

    public static <T> boolean equalsAllowNull(T obj1, T obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    public static boolean xmlEqualsAllowNull(Node node1, Node node2) {
        if (node1 == null) {
            return node2 == null;
        }
        if (node2 == null) {
            return false;
        }
        Node clone1 = node1.cloneNode(true);
        ObjUtil.cleanXMLNode(clone1);
        Node clone2 = node2.cloneNode(true);
        ObjUtil.cleanXMLNode(clone2);
        boolean compareReturn = ObjUtil.compareXML(clone1, clone2);
        return compareReturn;
    }

    private static void cleanXMLNode(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = attributes.getLength() - 1; i >= 0; --i) {
                Node a = attributes.item(i);
                if (!a.getNodeName().startsWith("xmlns")) continue;
                attributes.removeNamedItem(a.getNodeName());
            }
        }
        NodeList childNodes = node.getChildNodes();
        for (int i = childNodes.getLength() - 1; i >= 0; --i) {
            Node child = childNodes.item(i);
            short type = child.getNodeType();
            if (type == 8) {
                node.removeChild(child);
                continue;
            }
            ObjUtil.cleanXMLNode(child);
        }
    }

    private static boolean compareXML(Node node1, Node node2) {
        if (!ObjUtil.equalsAllowNull(node1.getNodeName(), node2.getNodeName()) || !ObjUtil.equalsAllowNull(node1.getNodeValue(), node2.getNodeValue()) || node1.getNodeType() != node2.getNodeType()) {
            logger.info((Object)("Node1 '" + node1.getNodeName() + "' type: " + node1.getNodeType() + "  != Node2 '" + node2.getNodeName() + "' type: " + node2.getNodeType()));
            return false;
        }
        NamedNodeMap node1Attributes = node1.getAttributes();
        NamedNodeMap node2Attributes = node2.getAttributes();
        if (node1Attributes == null) {
            if (node2Attributes != null && node2Attributes.getLength() > 0) {
                logger.info((Object)("Node1 '" + node1.getNodeName() + "' attrs null != Node2 '" + node2.getNodeName() + "' attrs non-null"));
                return false;
            }
        } else {
            if (node2Attributes == null || node2Attributes.getLength() != node1Attributes.getLength()) {
                logger.info((Object)("Node1 '" + node1.getNodeName() + "' attrs non-null  != Node2 '" + node2.getNodeName() + "' attrs null or length not same"));
                return false;
            }
            for (int i = 0; i < node1Attributes.getLength(); ++i) {
                if (node2Attributes.getNamedItem(node1Attributes.item(i).getNodeName()) != null) continue;
                logger.info((Object)("Node1 '" + node1.getNodeName() + "' attr: '" + node1Attributes.item(i).getNodeName() + "'  != Node2 '" + node2.getNodeName() + "' (missing attr)"));
                return false;
            }
        }
        NodeList children1 = node1.getChildNodes();
        NodeList children2 = node2.getChildNodes();
        if (children1.getLength() != children2.getLength()) {
            logger.info((Object)("Node1 '" + node1.getNodeName() + "' children: " + children1.getLength() + " != Node2 '" + node2.getNodeName() + "' children: " + children2.getLength()));
            return false;
        }
        for (int index1 = 0; index1 < children1.getLength(); ++index1) {
            if (ObjUtil.compareXML(children1.item(index1), children2.item(index1))) continue;
            logger.info((Object)("Node1 '" + node1.getNodeName() + "' != Node2 '" + node2.getNodeName() + "'"));
            return false;
        }
        return true;
    }
}

