/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ClusterableResponse;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.ThrowableArtifact;

public class EJBResponse
implements ClusterableResponse {
    private transient int responseCode = -1;
    private transient Object result;
    private transient ServerMetaData server;
    private transient long[] times = new long[Time.values().length];

    public EJBResponse() {
    }

    public EJBResponse(int code, Object obj) {
        this.responseCode = code;
        this.result = obj;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResponse(int code, Object result) {
        this.responseCode = code;
        this.result = result;
    }

    public void setServer(ServerMetaData server) {
        this.server = server;
    }

    public ServerMetaData getServer() {
        return this.server;
    }

    public String toString() {
        StringBuffer s = null;
        switch (this.responseCode) {
            case 9: {
                s = new StringBuffer("EJB_APP_EXCEPTION");
                break;
            }
            case 11: {
                s = new StringBuffer("EJB_ERROR");
                break;
            }
            case 4: {
                s = new StringBuffer("EJB_OK");
                break;
            }
            case 5: {
                s = new StringBuffer("EJB_OK_CREATE");
                break;
            }
            case 6: {
                s = new StringBuffer("EJB_OK_FOUND");
                break;
            }
            case 7: {
                s = new StringBuffer("EJB_OK_FOUND_COLLECTION");
                break;
            }
            case 20: {
                s = new StringBuffer("EJB_OK_FOUND_ENUMERATION");
                break;
            }
            case 8: {
                s = new StringBuffer("EJB_OK_NOT_FOUND");
                break;
            }
            case 10: {
                s = new StringBuffer("EJB_SYS_EXCEPTION");
                break;
            }
            default: {
                s = new StringBuffer("UNKNOWN_RESPONSE");
            }
        }
        s.append(", serverTime=").append(this.times[Time.TOTAL.ordinal()]).append("ns");
        s.append(", containerTime").append(this.times[Time.CONTAINER.ordinal()]).append("ns");
        s.append(" : ").append(this.result);
        return s.toString();
    }

    public void start(Time time) {
        this.times[time.ordinal()] = System.nanoTime();
    }

    public void stop(Time time) {
        this.times[time.ordinal()] = System.nanoTime() - this.times[time.ordinal()];
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        boolean readServer = in.readBoolean();
        if (readServer) {
            this.server = new ServerMetaData();
            this.server.readExternal(in);
        }
        this.responseCode = in.readByte();
        this.result = in.readObject();
        this.times = new long[in.readByte()];
        for (int i = 0; i < this.times.length; ++i) {
            this.times[i] = in.readLong();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        if (null != this.server) {
            out.writeBoolean(true);
            this.server.writeExternal(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeByte(this.responseCode);
        switch (this.responseCode) {
            case 9: 
            case 10: 
            case 11: {
                if (!(this.result instanceof Throwable) || this.result instanceof ThrowableArtifact) break;
                Throwable throwable = (Throwable)this.result;
                this.result = new ThrowableArtifact(throwable);
            }
        }
        this.start(Time.SERIALIZATION);
        out.writeObject(this.result);
        this.stop(Time.SERIALIZATION);
        this.stop(Time.TOTAL);
        out.writeByte(this.times.length);
        for (int i = 0; i < this.times.length; ++i) {
            out.writeLong(this.times[i]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Time {
        TOTAL,
        CONTAINER,
        SERIALIZATION,
        DESERIALIZATION;

    }
}

