/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.OpenEJBLifecycle;
import org.apache.openejb.cdi.ThreadSingletonServiceImpl;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.server.httpd.WebBeansListenerHelper;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.annotation.DestroyedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;

public class BeginWebBeansListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener,
HttpSessionActivationListener {
    private final String contextKey;
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_CDI, BeginWebBeansListener.class);
    protected FailOverService failoverService;
    private final CdiAppContextsService contextsService;
    protected WebBeansContext webBeansContext;

    public BeginWebBeansListener(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.failoverService = webBeansContext != null ? (FailOverService)this.webBeansContext.getService(FailOverService.class) : null;
        this.contextsService = webBeansContext != null ? (CdiAppContextsService)CdiAppContextsService.class.cast(webBeansContext.getService(ContextsService.class)) : null;
        this.contextKey = "org.apache.tomee.catalina.WebBeansListener@" + webBeansContext.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        if (this.webBeansContext == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying a request : [{0}]", new Object[]{event == null ? "null" : event.getServletRequest().getRemoteAddr()});
        }
        Object oldContext = event != null ? event.getServletRequest().getAttribute(this.contextKey) : null;
        try {
            ELContextStore elStore;
            HttpServletRequest httpRequest;
            HttpSession session;
            ServletRequest request;
            if (event != null && this.failoverService != null && this.failoverService.isSupportFailOver() && (request = event.getServletRequest()) instanceof HttpServletRequest && (session = (httpRequest = (HttpServletRequest)request).getSession(false)) != null) {
                this.failoverService.sessionIsIdle(session);
            }
            if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
                elStore.destroyELContextStore();
            }
            this.contextsService.endContext(RequestScoped.class, (Object)event);
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().endContext(RequestScoped.class, (Object)event);
            }
        }
        finally {
            this.contextsService.removeThreadLocals();
            ThreadSingletonServiceImpl.enter((WebBeansContext)((WebBeansContext)oldContext));
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        WebBeansContext oldContext = ThreadSingletonServiceImpl.enter((WebBeansContext)this.webBeansContext);
        if (event != null) {
            event.getServletRequest().setAttribute(this.contextKey, (Object)oldContext);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting a new request : [{0}]", new Object[]{event == null ? "null" : event.getServletRequest().getRemoteAddr()});
            }
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().startContext(RequestScoped.class, (Object)event);
            }
            this.contextsService.startContext(RequestScoped.class, (Object)event);
        }
        catch (Exception e) {
            logger.error("ERROR_0019", new Object[]{event == null ? "null" : event.getServletRequest()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting a session with session id : [{0}]", new Object[]{event.getSession().getId()});
            }
            if (this.webBeansContext instanceof WebappWebBeansContext) {
                ((WebappWebBeansContext)this.webBeansContext).getParent().getContextsService().startContext(SessionScoped.class, (Object)event.getSession());
            }
            this.contextsService.startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.error("ERROR_0020", new Object[]{event.getSession()});
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (this.webBeansContext == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Destroying a session with session id : [{0}]", new Object[]{event.getSession().getId()});
        }
        this.contextsService.startContext(SessionScoped.class, (Object)event.getSession());
        if (WebappWebBeansContext.class.isInstance(this.webBeansContext)) {
            ((WebappWebBeansContext)WebappWebBeansContext.class.cast(this.webBeansContext)).getParent().getContextsService().endContext(SessionScoped.class, (Object)event.getSession());
        }
        if (this.contextsService.getRequestContext(false) != null) {
            final String id = event.getSession().getId();
            CdiAppContextsService.pushRequestReleasable((Runnable)new Runnable(){

                @Override
                public void run() {
                    BeginWebBeansListener.this.doDestroyConversations(id);
                }
            });
        } else {
            this.doDestroyConversations(event.getSession().getId());
        }
        this.contextsService.endContext(SessionScoped.class, (Object)event.getSession());
        WebBeansListenerHelper.destroyFakedRequest(this);
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        WebBeansListenerHelper.ensureRequestScope((ContextsService)this.contextsService, this);
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        if (this.failoverService.isSupportFailOver() || this.failoverService.isSupportPassivation()) {
            this.failoverService.sessionDidActivate(event.getSession());
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            OpenEJBLifecycle.initializeServletContext((ServletContext)servletContextEvent.getServletContext(), (WebBeansContext)this.webBeansContext);
        }
        catch (Exception e) {
            logger.warning(e.getMessage(), (Throwable)e);
        }
        WebBeansListenerHelper.ensureRequestScope((ContextsService)this.contextsService, this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        WebBeansListenerHelper.destroyFakedRequest(this);
    }

    private void doDestroyConversations(String id) {
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        Map cc = conversationManager.getAndRemoveConversationMapWithSessionId(id);
        for (Map.Entry c : cc.entrySet()) {
            if (c == null) continue;
            ((ConversationContext)c.getValue()).destroy();
            this.webBeansContext.getBeanManagerImpl().fireEvent((Object)((Conversation)c.getKey()).getId(), new Annotation[]{DestroyedLiteral.INSTANCE_CONVERSATION_SCOPED});
        }
    }
}

