/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;

public class EmbeddedServletContext
extends MockServletContext {
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private Collection<ResourceProvider> resourceProviders = new ArrayList<ResourceProvider>();

    public EmbeddedServletContext() {
        for (ResourceProvider rp : ServiceLoader.load(ResourceProvider.class, EmbeddedServletContext.class.getClassLoader())) {
            this.resourceProviders.add(rp);
        }
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.resourceProviders.isEmpty()) {
            return super.getResource(path);
        }
        for (ResourceProvider provider : this.resourceProviders) {
            URL resource = provider.getResource(path);
            if (resource == null) continue;
            return resource;
        }
        return super.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        if (this.resourceProviders.isEmpty()) {
            return super.getResourceAsStream(path);
        }
        for (ResourceProvider provider : this.resourceProviders) {
            URL resource = provider.getResource(path);
            if (resource == null) continue;
            try {
                return resource.openStream();
            }
            catch (IOException e) {
            }
        }
        return super.getResourceAsStream(path);
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public String getVirtualServerName() {
        return "openejb";
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getServerInfo() {
        return "OpenEJB/" + OpenEjbVersion.get().getVersion();
    }

    public static interface ResourceProvider {
        public URL getResource(String var1);
    }
}

