/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSessionEvent;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.BeginWebBeansListener;
import org.apache.openejb.server.httpd.EndWebBeansListener;
import org.apache.openejb.server.httpd.HttpSession;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.Duration;
import org.apache.webbeans.config.WebBeansContext;

public class SessionManager {
    public static final String EJBSESSIONID = "EJBSESSIONID";
    public static final String JSESSIONID = "JSESSIONID";
    private final ConcurrentMap<String, SessionWrapper> sessions = new ConcurrentHashMap<String, SessionWrapper>();
    private static volatile ScheduledExecutorService es;

    public void destroy(WebContext app) {
        if (app == null) {
            return;
        }
        WebBeansContext wbc = app.getWebBeansContext();
        Iterator iterator = this.sessions.values().iterator();
        while (iterator.hasNext()) {
            SessionWrapper next = (SessionWrapper)((Object)iterator.next());
            if (next.app != app) continue;
            this.doDestroy(next);
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDestroy(SessionWrapper next) {
        HttpSessionEvent event = null;
        if (next.end != null) {
            event = new HttpSessionEvent((javax.servlet.http.HttpSession)next.session);
            next.end.sessionDestroyed(event);
            next.begin.sessionCreated(event);
        }
        try {
            next.session.invalidate();
        }
        finally {
            if (next.begin != null) {
                next.begin.sessionDestroyed(event);
            }
        }
    }

    public void destroy() {
        if (es == null) {
            return;
        }
        es.shutdownNow();
        for (SessionWrapper rs : this.sessions.values()) {
            rs.session.invalidate();
        }
        this.sessions.clear();
    }

    public void initEviction() {
        if (!"true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.http.eviction", "true"))) {
            return;
        }
        Duration duration = new Duration(SystemInstance.get().getProperty("openejb.http.eviction.duration", "1 minute"));
        es = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory(new Class[]{SessionManager.class}));
        es.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (SessionWrapper data : new ArrayList(SessionManager.this.sessions.values())) {
                    HttpSession session = data.session;
                    if (session.getMaxInactiveInterval() <= 0 || session.getLastAccessedTime() + TimeUnit.SECONDS.toMillis(session.getMaxInactiveInterval()) >= System.currentTimeMillis()) continue;
                    SessionManager.this.doDestroy(data);
                    SessionManager.this.sessions.remove(data.session.getId());
                }
            }
        }, duration.getTime(), duration.getTime(), duration.getUnit());
    }

    public SessionWrapper findSession(String id) {
        return (SessionWrapper)((Object)this.sessions.get(id));
    }

    public void removeSession(String sessionId) {
        this.sessions.remove(sessionId);
    }

    public Collection<String> findSessionIds() {
        return this.sessions.keySet();
    }

    public int size() {
        return this.sessions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionWrapper newSession(BeginWebBeansListener begin, EndWebBeansListener end, HttpSession session, WebContext app) {
        SessionWrapper wrapper = new SessionWrapper(begin, end, session, app);
        SessionWrapper existing = this.sessions.putIfAbsent(session.getId(), wrapper);
        if (existing == null && es == null) {
            SessionManager sessionManager = this;
            synchronized (sessionManager) {
                if (es == null) {
                    this.initEviction();
                }
            }
        }
        return existing == null ? wrapper : existing;
    }

    public static class SessionWrapper
    extends HttpSessionEvent {
        public final BeginWebBeansListener begin;
        public final EndWebBeansListener end;
        public final HttpSession session;
        public final WebContext app;

        public SessionWrapper(BeginWebBeansListener begin, EndWebBeansListener end, HttpSession session, WebContext app) {
            super((javax.servlet.http.HttpSession)session);
            this.begin = begin;
            this.end = end;
            this.session = session;
            this.app = app;
        }
    }
}

