/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.auth.ExactIPAddressPermission;
import org.apache.openejb.server.auth.ExactIPv6AddressPermission;
import org.apache.openejb.server.auth.IPAddressPermission;
import org.apache.openejb.server.auth.IPAddressPermissionFactory;
import org.apache.openejb.server.auth.PermitAllPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAccessController
implements ServerService {
    private final ServerService next;
    private IPAddressPermission[] hostPermissions;

    public ServiceAccessController(ServerService next) {
        this.next = next;
    }

    @Override
    public void service(Socket socket) throws ServiceException, IOException {
        this.checkHostsAuthorization(socket.getInetAddress(), socket.getLocalAddress());
        this.next.service(socket);
    }

    @Override
    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException("service(in,out)");
    }

    public void checkHostsAuthorization(InetAddress clientAddress, InetAddress serverAddress) throws SecurityException {
        if (clientAddress.equals(serverAddress)) {
            return;
        }
        for (IPAddressPermission host : this.hostPermissions) {
            if (!host.implies(clientAddress)) continue;
            return;
        }
        throw new SecurityException("Host " + clientAddress.getHostAddress() + " is not authorized to access this service.");
    }

    private void parseAdminIPs(Properties props) throws ServiceException {
        LinkedList<IPAddressPermission> permissions = new LinkedList<IPAddressPermission>();
        String ipString = props.getProperty("only_from");
        if (ipString == null) {
            permissions.add(new PermitAllPermission());
        } else {
            String hostname = "localhost";
            this.addIPAddressPermissions(permissions, hostname);
            StringTokenizer st = new StringTokenizer(ipString, ", \n\t");
            while (st.hasMoreTokens()) {
                String mask = st.nextToken();
                try {
                    permissions.add(IPAddressPermissionFactory.getIPAddressMask(mask));
                }
                catch (IllegalArgumentException iae) {
                    this.addIPAddressPermissions(permissions, mask);
                }
            }
        }
        this.hostPermissions = permissions.toArray(new IPAddressPermission[permissions.size()]);
    }

    private void addIPAddressPermissions(LinkedList<IPAddressPermission> permissions, String hostname) throws ServiceException {
        try {
            InetAddress[] localIps = InetAddress.getAllByName(hostname);
            for (int i = 0; i < localIps.length; ++i) {
                if (localIps[i] instanceof Inet4Address) {
                    permissions.add(new ExactIPAddressPermission(localIps[i].getAddress()));
                    continue;
                }
                permissions.add(new ExactIPv6AddressPermission(localIps[i].getAddress()));
            }
        }
        catch (UnknownHostException e) {
            throw new ServiceException("Could not get " + hostname + " inet address", e);
        }
    }

    public void init(Properties props) throws Exception {
        this.parseAdminIPs(props);
        this.next.init(props);
    }

    @Override
    public void start() throws ServiceException {
        this.next.start();
    }

    @Override
    public void stop() throws ServiceException {
        this.next.stop();
    }

    @Override
    public String getName() {
        return this.next.getName();
    }

    @Override
    public String getIP() {
        return this.next.getIP();
    }

    @Override
    public int getPort() {
        return this.next.getPort();
    }
}

