/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.datacache.CacheStatisticsSPI;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.datacache.DataCachePCDataImpl;
import org.apache.openjpa.enhance.PCDataGenerator;
import org.apache.openjpa.kernel.DataCacheRetrieveMode;
import org.apache.openjpa.kernel.DataCacheStoreMode;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.OptimisticException;

public class DataCacheStoreManager
extends DelegatingStoreManager {
    private Collection<OpenJPAStateManager> _inserts = null;
    private Map<OpenJPAStateManager, BitSet> _updates = null;
    private Collection<OpenJPAStateManager> _deletes = null;
    private StoreContext _ctx = null;
    private DataCacheManager _mgr = null;
    private PCDataGenerator _gen = null;

    public DataCacheStoreManager(StoreManager sm) {
        super(sm);
    }

    @Override
    public void setContext(StoreContext ctx) {
        this._ctx = ctx;
        this._mgr = ctx.getConfiguration().getDataCacheManagerInstance();
        this._gen = this._mgr.getPCDataGenerator();
        super.setContext(ctx);
    }

    @Override
    public void begin() {
        super.begin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        try {
            super.commit();
            this.updateCaches();
        }
        finally {
            this._inserts = null;
            this._updates = null;
            this._deletes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        try {
            super.rollback();
        }
        finally {
            this._inserts = null;
            this._updates = null;
            this._deletes = null;
        }
    }

    private void evictTypes(Collection<Class<?>> classes) {
        if (classes.isEmpty()) {
            return;
        }
        MetaDataRepository mdr = this._ctx.getConfiguration().getMetaDataRepositoryInstance();
        ClassLoader loader = this._ctx.getClassLoader();
        for (Class<?> cls : classes) {
            DataCache cache = mdr.getMetaData(cls, loader, false).getDataCache();
            if (cache == null || !cache.getEvictOnBulkUpdate()) continue;
            cache.removeAll(cls, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaches() {
        if (this._ctx.getFetchConfiguration().getCacheStoreMode() != DataCacheStoreMode.BYPASS) {
            DataCachePCData data;
            Modifications mods;
            DataCache cache;
            HashMap<DataCache, Modifications> modMap = null;
            if (this._ctx.getPopulateDataCache() && this._inserts != null || this._updates != null || this._deletes != null) {
                modMap = new HashMap<DataCache, Modifications>();
            }
            if (this._ctx.getPopulateDataCache() && this._inserts != null) {
                for (OpenJPAStateManager openJPAStateManager : this._inserts) {
                    cache = this._mgr.selectCache(openJPAStateManager);
                    if (cache == null) continue;
                    mods = DataCacheStoreManager.getModifications(modMap, cache);
                    data = this.newPCData(openJPAStateManager, cache);
                    data.store(openJPAStateManager);
                    mods.additions.add(new PCDataHolder(data, openJPAStateManager));
                    CacheStatistics stats = cache.getStatistics();
                    if (!stats.isEnabled()) continue;
                    ((CacheStatisticsSPI)stats).newPut(data.getType());
                }
            }
            if (this._updates != null) {
                for (Map.Entry<OpenJPAStateManager, BitSet> entry : this._updates.entrySet()) {
                    CacheStatistics stats;
                    OpenJPAStateManager openJPAStateManager = entry.getKey();
                    BitSet fields = entry.getValue();
                    cache = this._mgr.selectCache(openJPAStateManager);
                    if (cache == null) continue;
                    data = cache.get(openJPAStateManager.getObjectId());
                    mods = DataCacheStoreManager.getModifications(modMap, cache);
                    if (data == null) {
                        data = this.newPCData(openJPAStateManager, cache);
                        data.store(openJPAStateManager);
                        mods.newUpdates.add(new PCDataHolder(data, openJPAStateManager));
                    } else {
                        data.store(openJPAStateManager, fields);
                        mods.existingUpdates.add(new PCDataHolder(data, openJPAStateManager));
                    }
                    if (!(stats = cache.getStatistics()).isEnabled()) continue;
                    ((CacheStatisticsSPI)stats).newPut(data.getType());
                }
            }
            if (this._deletes != null) {
                for (OpenJPAStateManager openJPAStateManager : this._deletes) {
                    cache = this._mgr.selectCache(openJPAStateManager);
                    if (cache == null) continue;
                    mods = DataCacheStoreManager.getModifications(modMap, cache);
                    mods.deletes.add(openJPAStateManager.getObjectId());
                }
            }
            if (modMap != null) {
                for (Map.Entry entry : modMap.entrySet()) {
                    cache = (DataCache)entry.getKey();
                    mods = (Modifications)entry.getValue();
                    cache.writeLock();
                    try {
                        cache.commit(this.transformToVersionSafePCDatas(cache, mods.additions), this.transformToVersionSafePCDatas(cache, mods.newUpdates), this.transformToVersionSafePCDatas(cache, mods.existingUpdates), mods.deletes);
                    }
                    finally {
                        cache.writeUnlock();
                    }
                }
            }
            if (this._ctx.isTrackChangesByType()) {
                this.evictTypes(this._ctx.getDeletedTypes());
                this.evictTypes(this._ctx.getUpdatedTypes());
            }
        }
    }

    private List<DataCachePCData> transformToVersionSafePCDatas(DataCache cache, List<PCDataHolder> holders) {
        ArrayList<DataCachePCData> transformed = new ArrayList<DataCachePCData>(holders.size());
        HashMap<Object, Integer> ids = new HashMap<Object, Integer>(holders.size());
        ArrayList<Object> idList = new ArrayList<Object>(holders.size());
        int i = 0;
        for (PCDataHolder holder : holders) {
            ids.put(holder.sm.getObjectId(), i++);
            idList.add(holder.sm.getObjectId());
        }
        Map<Object, DataCachePCData> pcdatas = cache.getAll(idList);
        for (Map.Entry<Object, DataCachePCData> entry : pcdatas.entrySet()) {
            Integer index = (Integer)ids.get(entry.getKey());
            DataCachePCData oldpc = entry.getValue();
            PCDataHolder holder = holders.get(index);
            if (oldpc != null && this.compareVersion(holder.sm, holder.sm.getVersion(), oldpc.getVersion()) == 2) continue;
            transformed.add(holder.pcdata);
        }
        return transformed;
    }

    private static Modifications getModifications(Map<DataCache, Modifications> modMap, DataCache cache) {
        Modifications mods = modMap.get(cache);
        if (mods == null) {
            mods = new Modifications();
            modMap.put(cache, mods);
        }
        return mods;
    }

    @Override
    public boolean exists(OpenJPAStateManager sm, Object edata) {
        CacheStatistics stats;
        DataCache cache = this._mgr.selectCache(sm);
        CacheStatistics cacheStatistics = stats = cache == null ? null : cache.getStatistics();
        if (cache != null && !this.isLocking(null) && cache.contains(sm.getObjectId())) {
            if (stats != null && stats.isEnabled()) {
                Class<?> cls = sm.getMetaData().getDescribedType();
                ((CacheStatisticsSPI)stats).newGet(cls, false);
            }
            return true;
        }
        if (stats != null && stats.isEnabled()) {
            Class<?> cls = sm.getMetaData().getDescribedType();
            ((CacheStatisticsSPI)stats).newGet(cls, false);
        }
        return super.exists(sm, edata);
    }

    @Override
    public boolean isCached(List<Object> oids, BitSet edata) {
        DataCache cache = this._mgr.getSystemDataCache();
        if (cache != null && !this.isLocking(null)) {
            for (int i = 0; i < oids.size(); ++i) {
                Object oid = oids.get(i);
                if (edata.get(i) || !cache.contains(oid)) continue;
                edata.set(i);
            }
            if (edata.cardinality() == oids.size()) {
                return true;
            }
        }
        return super.isCached(oids, edata);
    }

    @Override
    public boolean syncVersion(OpenJPAStateManager sm, Object edata) {
        CacheStatistics stats;
        DataCache cache = this._mgr.selectCache(sm);
        FetchConfiguration fc = sm.getContext().getFetchConfiguration();
        CacheStatistics cacheStatistics = stats = cache == null ? null : cache.getStatistics();
        if (cache == null || sm.isEmbedded() || fc.getCacheRetrieveMode() == DataCacheRetrieveMode.BYPASS) {
            if (stats != null && stats.isEnabled()) {
                ((CacheStatisticsSPI)stats).newGet(sm.getMetaData().getDescribedType(), false);
            }
            return super.syncVersion(sm, edata);
        }
        Object version = null;
        DataCachePCData data = cache.get(sm.getObjectId());
        if (!this.isLocking(null) && data != null) {
            version = data.getVersion();
        }
        if (version != null) {
            if (stats != null && stats.isEnabled()) {
                ((CacheStatisticsSPI)stats).newGet(data.getType(), true);
            }
            if (!version.equals(sm.getVersion())) {
                sm.setVersion(version);
                return false;
            }
            return true;
        }
        if (stats.isEnabled()) {
            Class<?> cls = data == null ? sm.getMetaData().getDescribedType() : data.getType();
            ((CacheStatisticsSPI)stats).newGet(cls, false);
        }
        return super.syncVersion(sm, edata);
    }

    @Override
    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object edata) {
        boolean updateCache;
        boolean alreadyCached;
        DataCache cache = this._mgr.selectCache(sm);
        if (cache == null) {
            return super.initialize(sm, state, fetch, edata);
        }
        DataCachePCData data = cache.get(sm.getObjectId());
        CacheStatistics stats = cache.getStatistics();
        boolean fromDatabase = false;
        boolean bl = alreadyCached = data != null;
        if (sm.isEmbedded() || fetch.getCacheRetrieveMode() == DataCacheRetrieveMode.BYPASS || fetch.getCacheStoreMode() == DataCacheStoreMode.REFRESH) {
            fromDatabase = super.initialize(sm, state, fetch, edata);
        } else if (alreadyCached && !this.isLocking(fetch)) {
            if (stats.isEnabled()) {
                ((CacheStatisticsSPI)stats).newGet(data.getType(), true);
            }
            sm.initialize(data.getType(), state);
            data.load(sm, fetch, edata);
        } else {
            if (!alreadyCached && stats.isEnabled()) {
                ((CacheStatisticsSPI)stats).newGet(sm.getMetaData().getDescribedType(), false);
            }
            fromDatabase = super.initialize(sm, state, fetch, edata);
        }
        boolean bl2 = updateCache = fromDatabase && this._ctx.getPopulateDataCache() && (fetch.getCacheStoreMode() == DataCacheStoreMode.USE && !alreadyCached || fetch.getCacheStoreMode() == DataCacheStoreMode.REFRESH);
        if (updateCache && (cache = this._mgr.selectCache(sm)) != null) {
            this.cacheStateManager(cache, sm, data);
            if (stats.isEnabled()) {
                ((CacheStatisticsSPI)stats).newPut(sm.getMetaData().getDescribedType());
            }
        }
        return fromDatabase || alreadyCached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheStateManager(DataCache cache, OpenJPAStateManager sm, DataCachePCData data) {
        if (sm.isFlushed()) {
            return;
        }
        cache.writeLock();
        try {
            boolean isNew;
            if (data != null && this.compareVersion(sm, sm.getVersion(), data.getVersion()) == 2) {
                return;
            }
            boolean bl = isNew = data == null;
            if (isNew) {
                data = this.newPCData(sm, cache);
            }
            data.store(sm);
            if (data.getId() == null) {
                return;
            }
            if (isNew) {
                cache.put(data);
            } else {
                cache.update(data);
            }
        }
        finally {
            cache.writeUnlock();
        }
    }

    @Override
    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object edata) {
        DataCache cache = this._mgr.selectCache(sm);
        boolean found = false;
        if (cache == null || sm.isEmbedded() || this.bypass(fetch, 0)) {
            found = super.load(sm, fields, fetch, lockLevel, edata);
            this.updateDataCache(found, sm, fetch);
            return found;
        }
        CacheStatistics stats = cache.getStatistics();
        DataCachePCData data = cache.get(sm.getObjectId());
        if (lockLevel == 0 && !this.isLocking(fetch) && data != null) {
            data.load(sm, fields, fetch, edata);
        }
        if (fields.length() == 0) {
            if (stats.isEnabled()) {
                Class<?> cls = data == null ? sm.getMetaData().getDescribedType() : data.getType();
                ((CacheStatisticsSPI)stats).newGet(cls, true);
            }
            return true;
        }
        found = super.load(sm, (BitSet)fields.clone(), fetch, lockLevel, edata);
        this.updateDataCache(found, sm, fetch);
        return found;
    }

    private void updateDataCache(boolean found, OpenJPAStateManager sm, FetchConfiguration fetch) {
        boolean alreadyCached;
        if (!this._ctx.getPopulateDataCache() || sm == null || fetch.getCacheStoreMode() == DataCacheStoreMode.BYPASS) {
            return;
        }
        DataCache cache = this._mgr.selectCache(sm);
        if (cache == null) {
            return;
        }
        DataCachePCData data = cache.get(sm.getObjectId());
        boolean bl = alreadyCached = data != null;
        if (!alreadyCached && sm.isEmbedded()) {
            return;
        }
        if (fetch.getCacheStoreMode() == DataCacheStoreMode.USE && !alreadyCached || fetch.getCacheStoreMode() == DataCacheStoreMode.REFRESH) {
            if (!found && data != null && !this.isLocking(fetch)) {
                cache.remove(sm.getObjectId());
                return;
            }
            if (found) {
                this.cacheStateManager(cache, sm, data);
                CacheStatistics stats = cache.getStatistics();
                if (stats.isEnabled()) {
                    ((CacheStatisticsSPI)stats).newPut(sm.getMetaData().getDescribedType());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Object> loadAll(Collection<OpenJPAStateManager> sms, PCState state, int load, FetchConfiguration fetch, Object edata) {
        BitSet fields;
        DataCachePCData data;
        DataCache cache;
        if (this.bypass(fetch, load)) {
            return super.loadAll(sms, state, load, fetch, edata);
        }
        Map<OpenJPAStateManager, BitSet> unloaded = null;
        List<OpenJPAStateManager> smList = null;
        HashMap<DataCache, ArrayList<OpenJPAStateManager>> caches = new HashMap<DataCache, ArrayList<OpenJPAStateManager>>();
        for (OpenJPAStateManager openJPAStateManager : sms) {
            cache = this._mgr.selectCache(openJPAStateManager);
            if (cache == null || openJPAStateManager.isEmbedded()) {
                unloaded = DataCacheStoreManager.addUnloaded(openJPAStateManager, null, unloaded);
                continue;
            }
            if (openJPAStateManager.getManagedInstance() == null || load != 0 || openJPAStateManager.getPCState() == PCState.HOLLOW) {
                smList = (List)caches.get(cache);
                if (smList == null) {
                    smList = new ArrayList<OpenJPAStateManager>();
                    caches.put(cache, (ArrayList<OpenJPAStateManager>)smList);
                }
                smList.add(openJPAStateManager);
                continue;
            }
            if (cache.contains(openJPAStateManager.getObjectId())) continue;
            unloaded = DataCacheStoreManager.addUnloaded(openJPAStateManager, null, unloaded);
        }
        for (Map.Entry entry : caches.entrySet()) {
            cache = (DataCache)entry.getKey();
            smList = (ArrayList<OpenJPAStateManager>)entry.getValue();
            ArrayList<Object> oidList = new ArrayList<Object>(smList.size());
            for (OpenJPAStateManager sm : smList) {
                oidList.add((OpenJPAId)sm.getObjectId());
            }
            Map<Object, DataCachePCData> dataMap = cache.getAll(oidList);
            for (OpenJPAStateManager sm : smList) {
                data = dataMap.get(sm.getObjectId());
                CacheStatistics stats = cache.getStatistics();
                if (sm.getManagedInstance() == null) {
                    if (data != null) {
                        if (stats.isEnabled()) {
                            ((CacheStatisticsSPI)stats).newGet(data.getType(), true);
                        }
                        sm.initialize(data.getType(), state);
                        data.load(sm, fetch, edata);
                        continue;
                    }
                    unloaded = DataCacheStoreManager.addUnloaded(sm, null, unloaded);
                    if (!stats.isEnabled()) continue;
                    ((CacheStatisticsSPI)stats).newGet(sm.getMetaData().getDescribedType(), false);
                    continue;
                }
                if (load == 0 && sm.getPCState() != PCState.HOLLOW) continue;
                data = cache.get(sm.getObjectId());
                if (data != null) {
                    fields = sm.getUnloaded(fetch);
                    data.load(sm, fields, fetch, edata);
                    if (fields.length() > 0) {
                        unloaded = DataCacheStoreManager.addUnloaded(sm, fields, unloaded);
                        if (!stats.isEnabled()) continue;
                        ((CacheStatisticsSPI)stats).newGet(data.getType(), false);
                        continue;
                    }
                    if (!stats.isEnabled()) continue;
                    ((CacheStatisticsSPI)stats).newGet(data.getType(), true);
                    continue;
                }
                unloaded = DataCacheStoreManager.addUnloaded(sm, null, unloaded);
                if (!stats.isEnabled()) continue;
                ((CacheStatisticsSPI)stats).newGet(sm.getMetaData().getDescribedType(), false);
            }
        }
        if (unloaded == null) {
            return Collections.emptyList();
        }
        Collection<Object> failed = super.loadAll(unloaded.keySet(), state, load, fetch, edata);
        if (!this._ctx.getPopulateDataCache()) {
            return failed;
        }
        for (Map.Entry<OpenJPAStateManager, BitSet> entry : unloaded.entrySet()) {
            OpenJPAStateManager sm;
            sm = entry.getKey();
            fields = entry.getValue();
            cache = this._mgr.selectCache(sm);
            if (cache == null || sm.isEmbedded() || failed != null && failed.contains(sm.getId())) continue;
            cache.writeLock();
            try {
                CacheStatistics stats;
                boolean bl;
                data = cache.get(sm.getObjectId());
                if (data != null && this.compareVersion(sm, sm.getVersion(), data.getVersion()) == 2) continue;
                boolean bl2 = bl = data == null;
                if (bl) {
                    data = this.newPCData(sm, cache);
                }
                if (fields == null) {
                    data.store(sm);
                } else {
                    data.store(sm, fields);
                }
                if (bl) {
                    cache.put(data);
                } else {
                    cache.update(data);
                }
                if (!(stats = cache.getStatistics()).isEnabled()) continue;
                ((CacheStatisticsSPI)stats).newPut(data.getType());
            }
            finally {
                cache.writeUnlock();
            }
        }
        return failed;
    }

    private static Map<OpenJPAStateManager, BitSet> addUnloaded(OpenJPAStateManager sm, BitSet fields, Map<OpenJPAStateManager, BitSet> unloaded) {
        if (unloaded == null) {
            unloaded = new HashMap<OpenJPAStateManager, BitSet>();
        }
        unloaded.put(sm, fields);
        return unloaded;
    }

    @Override
    public Collection<Exception> flush(Collection<OpenJPAStateManager> states) {
        Collection<Exception> exceps = super.flush(states);
        if (!exceps.isEmpty()) {
            for (Exception e : exceps) {
                if (!(e instanceof OptimisticException)) continue;
                this.notifyOptimisticLockFailure((OptimisticException)e);
            }
            return exceps;
        }
        if (this._ctx.isTrackChangesByType()) {
            return exceps;
        }
        for (OpenJPAStateManager sm : states) {
            if (sm.getPCState() == PCState.PNEW && !sm.isFlushed()) {
                if (this._inserts == null) {
                    this._inserts = new ArrayList<OpenJPAStateManager>();
                }
                this._inserts.add(sm);
                if (this._deletes == null) continue;
                this._deletes.remove(sm);
                continue;
            }
            if (this._inserts != null && (sm.getPCState() == PCState.PNEWDELETED || sm.getPCState() == PCState.PNEWFLUSHEDDELETED)) {
                this._inserts.remove(sm);
                continue;
            }
            if (sm.getPCState() == PCState.PDIRTY) {
                if (this._updates == null) {
                    this._updates = new HashMap<OpenJPAStateManager, BitSet>();
                }
                this._updates.put(sm, sm.getDirty());
                continue;
            }
            if (sm.getPCState() != PCState.PDELETED) continue;
            if (this._deletes == null) {
                this._deletes = new HashSet<OpenJPAStateManager>();
            }
            this._deletes.add(sm);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOptimisticLockFailure(OptimisticException e) {
        Object o = e.getFailedObject();
        OpenJPAStateManager sm = this._ctx.getStateManager(o);
        if (sm == null) {
            return;
        }
        Object oid = sm.getId();
        DataCache cache = this._mgr.selectCache(sm);
        if (cache == null) {
            return;
        }
        cache.writeLock();
        try {
            boolean remove;
            DataCachePCData data = cache.get(oid);
            if (data == null) {
                return;
            }
            switch (this.compareVersion(sm, sm.getVersion(), data.getVersion())) {
                case 1: 
                case 3: {
                    remove = true;
                    break;
                }
                case 2: {
                    remove = false;
                    break;
                }
                case 4: {
                    remove = true;
                    break;
                }
                default: {
                    remove = true;
                }
            }
            if (remove) {
                cache.remove(sm.getId());
            }
        }
        finally {
            cache.writeUnlock();
        }
        this._ctx.getConfiguration().getRemoteCommitEventManager().fireLocalStaleNotification(oid);
    }

    private DataCachePCData newPCData(OpenJPAStateManager sm, DataCache cache) {
        ClassMetaData meta = sm.getMetaData();
        if (this._gen != null) {
            return (DataCachePCData)this._gen.generatePCData(sm.getObjectId(), meta);
        }
        return new DataCachePCDataImpl(sm.fetchObjectId(), meta, cache.getName());
    }

    boolean bypass(FetchConfiguration fetch, int load) {
        if (this.isLocking(fetch)) {
            return true;
        }
        if (this._ctx.getConfiguration().getRefreshFromDataCache()) {
            return false;
        }
        if (fetch.getCacheRetrieveMode() == DataCacheRetrieveMode.BYPASS) {
            return true;
        }
        return load == 3;
    }

    private boolean isLocking(FetchConfiguration fetch) {
        if (fetch == null) {
            fetch = this._ctx.getFetchConfiguration();
        }
        return fetch.getReadLockLevel() > 0;
    }

    private static class PCDataHolder {
        public final DataCachePCData pcdata;
        public final OpenJPAStateManager sm;

        public PCDataHolder(DataCachePCData pcdata, OpenJPAStateManager sm) {
            this.pcdata = pcdata;
            this.sm = sm;
        }
    }

    private static class Modifications {
        public final List<PCDataHolder> additions = new ArrayList<PCDataHolder>();
        public final List<PCDataHolder> newUpdates = new ArrayList<PCDataHolder>();
        public final List<PCDataHolder> existingUpdates = new ArrayList<PCDataHolder>();
        public final List<Object> deletes = new ArrayList<Object>();

        private Modifications() {
        }
    }
}

