/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.TreeSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.GenericConfigurable;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.util.ParseException;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;
import serp.util.Strings;

public class Configurations {
    private static final Localizer _loc = Localizer.forPackage(Configurations.class);
    private static final ConcurrentReferenceHashMap _loaders = new ConcurrentReferenceHashMap(1, 0);
    private static final Object NULL_LOADER = "null-loader";
    public static final String CONFIG_RESOURCE_PATH = "configResourcePath";
    public static final String CONFIG_RESOURCE_ANCHOR = "configResourceAnchor";

    public static String getClassName(String plugin) {
        return Configurations.getPluginComponent(plugin, true);
    }

    public static String getProperties(String plugin) {
        return Configurations.getPluginComponent(plugin, false);
    }

    private static String getPluginComponent(String plugin, boolean clsName) {
        if (plugin != null) {
            plugin = plugin.trim();
        }
        if (StringUtils.isEmpty(plugin)) {
            return null;
        }
        int openParen = -1;
        if (plugin.charAt(plugin.length() - 1) == ')') {
            openParen = plugin.indexOf(40);
        }
        if (openParen == -1) {
            int eq = plugin.indexOf(61);
            if (eq == -1) {
                return clsName ? plugin : null;
            }
            return clsName ? null : plugin;
        }
        if (clsName) {
            return plugin.substring(0, openParen).trim();
        }
        String prop = plugin.substring(openParen + 1, plugin.length() - 1).trim();
        return prop.length() == 0 ? null : prop;
    }

    public static String getPlugin(String clsName, String props) {
        if (StringUtils.isEmpty(clsName)) {
            return props;
        }
        if (StringUtils.isEmpty(props)) {
            return clsName;
        }
        return clsName + "(" + props + ")";
    }

    public static String combinePlugins(String orig, String override) {
        String cls;
        if (StringUtils.isEmpty(orig)) {
            return override;
        }
        if (StringUtils.isEmpty(override)) {
            return orig;
        }
        String origCls = Configurations.getClassName(orig);
        String overrideCls = Configurations.getClassName(override);
        if (StringUtils.isEmpty(origCls)) {
            cls = overrideCls;
        } else if (StringUtils.isEmpty(overrideCls)) {
            cls = origCls;
        } else {
            if (!origCls.equals(overrideCls)) {
                return override;
            }
            cls = origCls;
        }
        String origProps = Configurations.getProperties(orig);
        String overrideProps = Configurations.getProperties(override);
        if (StringUtils.isEmpty(origProps)) {
            return Configurations.getPlugin(cls, overrideProps);
        }
        if (StringUtils.isEmpty(overrideProps)) {
            return Configurations.getPlugin(cls, origProps);
        }
        Options props = Configurations.parseProperties(origProps);
        props.putAll((Map<?, ?>)Configurations.parseProperties(overrideProps));
        return Configurations.getPlugin(cls, Configurations.serializeProperties(props));
    }

    public static Object newInstance(String clsName, ClassLoader loader) {
        return Configurations.newInstance(clsName, null, null, loader, true);
    }

    public static Object newInstance(String clsName, Configuration conf, String props, ClassLoader loader) {
        Object obj = Configurations.newInstance(clsName, null, conf, loader, true);
        Configurations.configureInstance(obj, conf, props);
        return obj;
    }

    public static Object newInstance(String clsName, Configuration conf, Properties props, ClassLoader loader) {
        Object obj = Configurations.newInstance(clsName, null, conf, loader, true);
        Configurations.configureInstance(obj, conf, props);
        return obj;
    }

    static Object newInstance(String clsName, Value val, Configuration conf, ClassLoader loader, boolean fatal) {
        if (StringUtils.isEmpty(clsName)) {
            return null;
        }
        Class cls = null;
        while (cls == null) {
            Object key = loader == null ? NULL_LOADER : loader;
            Map loaderCache = (Map)_loaders.get(key);
            if (loaderCache == null) {
                loaderCache = new ConcurrentReferenceHashMap(0, 1);
                _loaders.put(key, loaderCache);
            } else {
                cls = (Class)loaderCache.get(clsName);
            }
            if (cls != null) continue;
            try {
                cls = Strings.toClass(clsName, Configurations.findDerivedLoader(conf, loader));
                loaderCache.put(clsName, cls);
            }
            catch (RuntimeException re) {
                Log log;
                if (loader != null) {
                    loader = null;
                    continue;
                }
                if (val != null) {
                    re = Configurations.getCreateException(clsName, val, re);
                }
                if (fatal) {
                    throw re;
                }
                Log log2 = log = conf == null ? null : conf.getConfigurationLog();
                if (log != null && log.isErrorEnabled()) {
                    log.error(_loc.get("plugin-creation-exception", val), re);
                }
                return null;
            }
        }
        try {
            return AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(cls));
        }
        catch (Exception e) {
            Log log;
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            NestableRuntimeException re = new NestableRuntimeException(_loc.get("obj-create", cls).getMessage(), e);
            if (fatal) {
                throw re;
            }
            Log log3 = log = conf == null ? null : conf.getConfigurationLog();
            if (log != null && log.isErrorEnabled()) {
                log.error(_loc.get("plugin-creation-exception", val), re);
            }
            return null;
        }
    }

    private static ClassLoader findDerivedLoader(Configuration conf, ClassLoader loader) {
        ClassLoader ctxLoader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        if (loader == null) {
            if (ctxLoader != null) {
                return ctxLoader;
            }
            if (conf != null) {
                return AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(conf.getClass()));
            }
            return Configurations.class.getClassLoader();
        }
        ClassLoader parent = ctxLoader;
        while (parent != null) {
            if (parent == loader) {
                return ctxLoader;
            }
            parent = AccessController.doPrivileged(J2DoPrivHelper.getParentAction(parent));
        }
        if (conf != null) {
            parent = AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(conf.getClass()));
            while (parent != null) {
                if (parent == loader) {
                    return AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(conf.getClass()));
                }
                parent = AccessController.doPrivileged(J2DoPrivHelper.getParentAction(parent));
            }
        }
        return loader;
    }

    public static List<String> getFullyQualifiedAnchorsInPropertiesLocation(Options opts) {
        int anchorPosition;
        String props = opts.getProperty("properties", "p", null);
        if (props != null && (anchorPosition = props.indexOf("#")) > -1) {
            return Arrays.asList(props);
        }
        return ProductDerivations.getFullyQualifiedAnchorsInPropertiesLocation(props);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void populateConfiguration(Configuration conf, Options opts) {
        String props = opts.removeProperty("properties", "p", null);
        if (!StringUtils.isEmpty(props)) {
            Map<String, String> result = Configurations.parseConfigResource(props);
            String path = result.get(CONFIG_RESOURCE_PATH);
            String anchor = result.get(CONFIG_RESOURCE_ANCHOR);
            File file = new File(path);
            ConfigurationProvider provider = AccessController.doPrivileged(J2DoPrivHelper.isFileAction(file)) != false ? ProductDerivations.load(file, anchor, null) : (AccessController.doPrivileged(J2DoPrivHelper.isFileAction(file = new File("META-INF" + File.separatorChar + path))) != false ? ProductDerivations.load(file, anchor, null) : ProductDerivations.load(path, anchor, null));
            if (provider == null) throw new MissingResourceException(_loc.get("no-provider", props).getMessage(), Configurations.class.getName(), props);
            provider.setInto(conf);
        } else {
            ConfigurationProvider provider = ProductDerivations.loadDefaults(null);
            if (provider != null) {
                provider.setInto(conf);
            }
        }
        opts.setInto(conf);
    }

    public static Map<String, String> parseConfigResource(String props) {
        String path = props;
        String anchor = null;
        int idx = path.lastIndexOf(35);
        if (idx != -1) {
            if (idx < path.length() - 1) {
                anchor = path.substring(idx + 1);
            }
            if ((path = path.substring(0, idx)).length() == 0) {
                throw new MissingResourceException(_loc.get("anchor-only", props).getMessage(), Configurations.class.getName(), props);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(CONFIG_RESOURCE_PATH, path);
        result.put(CONFIG_RESOURCE_ANCHOR, anchor);
        return result;
    }

    private static RuntimeException getCreateException(String clsName, Value val, Exception e) {
        Object[] params;
        String msg;
        String[] keys;
        String alias = val.alias(clsName);
        String[] aliases = val.getAliases();
        if (aliases.length == 0) {
            keys = aliases;
        } else {
            keys = new String[aliases.length / 2];
            for (int i = 0; i < aliases.length; i += 2) {
                keys[i / 2] = aliases[i];
            }
        }
        if (keys.length == 0) {
            msg = "invalid-plugin";
            params = new Object[]{val.getProperty(), alias, e.toString()};
        } else {
            String closest = StringDistance.getClosestLevenshteinDistance(alias, keys, 0.5f);
            if (closest == null) {
                msg = "invalid-plugin-aliases";
                params = new Object[]{val.getProperty(), alias, e.toString(), new TreeSet<String>(Arrays.asList(keys))};
            } else {
                msg = "invalid-plugin-aliases-hint";
                params = new Object[]{val.getProperty(), alias, e.toString(), new TreeSet<String>(Arrays.asList(keys)), closest};
            }
        }
        return new ParseException(_loc.get(msg, params), (Throwable)e);
    }

    public static void configureInstance(Object obj, Configuration conf, String properties) {
        Configurations.configureInstance(obj, conf, properties, null);
    }

    public static void configureInstance(Object obj, Configuration conf, String properties, String configurationName) {
        if (obj == null) {
            return;
        }
        Options props = null;
        if (!StringUtils.isEmpty(properties)) {
            props = Configurations.parseProperties(properties);
        }
        Configurations.configureInstance(obj, conf, props, configurationName);
    }

    public static void configureInstance(Object obj, Configuration conf, Properties properties) {
        Configurations.configureInstance(obj, conf, properties, null);
    }

    public static void configureInstance(Object obj, Configuration conf, Properties properties, String configurationName) {
        Options opts;
        if (obj == null) {
            return;
        }
        if (properties instanceof Options) {
            opts = (Options)properties;
        } else {
            opts = new Options();
            if (properties != null) {
                opts.putAll((Map<?, ?>)properties);
            }
        }
        Configurable configurable = null;
        if (conf != null && obj instanceof Configurable) {
            configurable = (Configurable)obj;
        }
        if (configurable != null) {
            configurable.setConfiguration(conf);
            configurable.startConfiguration();
        }
        Options invalidEntries = opts.setInto(obj);
        if (obj instanceof GenericConfigurable) {
            ((GenericConfigurable)obj).setInto(invalidEntries);
        }
        if (!invalidEntries.isEmpty() && configurationName != null) {
            Collection<String> options;
            String close;
            Localizer.Message msg = null;
            String first = (String)invalidEntries.keySet().iterator().next();
            if (invalidEntries.keySet().size() == 1 && first.indexOf(46) == -1 && (close = StringDistance.getClosestLevenshteinDistance(first, options = Configurations.findOptionsFor(obj.getClass()), 0.75f)) != null) {
                msg = _loc.get("invalid-config-param-hint", new Object[]{configurationName, obj.getClass(), first, close, options});
            }
            if (msg == null) {
                msg = _loc.get("invalid-config-params", new String[]{configurationName, obj.getClass().getName(), invalidEntries.keySet().toString(), Configurations.findOptionsFor(obj.getClass()).toString()});
            }
            throw new ParseException(msg);
        }
        if (configurable != null) {
            configurable.endConfiguration();
        }
    }

    private static Collection<String> findOptionsFor(Class<?> cls) {
        Collection<String> c = Options.findOptionsFor(cls);
        if (Configurable.class.isAssignableFrom(cls)) {
            c.remove("Configuration");
        }
        if (GenericConfigurable.class.isAssignableFrom(cls)) {
            c.remove("Into");
        }
        return c;
    }

    public static String serializeProperties(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(entry.getKey()).append('=');
            String val = String.valueOf(entry.getValue());
            if (val.indexOf(44) != -1) {
                buf.append('\"').append(val).append('\"');
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public static Options parseProperties(String properties) {
        Options opts = new Options();
        if ((properties = StringUtils.trimToNull(properties)) == null) {
            return opts;
        }
        try {
            String[] props = Strings.split(properties, ",", 0);
            for (int i = 0; i < props.length; ++i) {
                String val;
                String prop;
                int idx = props[i].indexOf(61);
                if (idx == -1) {
                    val = prop = props[i];
                } else {
                    prop = props[i].substring(0, idx).trim();
                    val = props[i].substring(idx + 1).trim();
                }
                if ((val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")) && val.length() > 1) {
                    val = val.substring(1, val.length() - 1);
                } else if (val.startsWith("\"") || val.startsWith("'")) {
                    char quote = val.charAt(0);
                    StringBuilder buf = new StringBuilder(val.substring(1));
                    while (++i < props.length) {
                        buf.append(",");
                        int quotIdx = props[i].indexOf(quote);
                        if (quotIdx != -1) {
                            buf.append(props[i].substring(0, quotIdx));
                            if (quotIdx + 1 >= props[i].length()) break;
                            buf.append(props[i].substring(quotIdx + 1));
                            break;
                        }
                        buf.append(props[i]);
                    }
                    val = buf.toString();
                }
                opts.put(prop, val);
            }
            return opts;
        }
        catch (RuntimeException re) {
            throw new ParseException(_loc.get("prop-parse", properties), (Throwable)re);
        }
    }

    public static Object lookup(String name, String userKey, Log log) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object result = ctx.lookup(name);
            if (result == null && log != null && log.isWarnEnabled()) {
                log.warn(_loc.get("jndi-lookup-failed", userKey, name));
            }
            Object object = result;
            return object;
        }
        catch (NamingException ne) {
            throw new NestableRuntimeException(_loc.get("naming-err", name).getMessage(), ne);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {}
            }
        }
    }

    public static boolean containsProperty(Value value, Map props) {
        if (value == null || props == null || props.isEmpty()) {
            return false;
        }
        List<String> partialKeys = value.getPropertyKeys();
        for (String partialKey : partialKeys) {
            if (!props.containsKey(ProductDerivations.getConfigurationKey(partialKey, props))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsProperty(String partialKey, Map props) {
        if (partialKey == null || props == null || props.isEmpty()) {
            return false;
        }
        return props.containsKey(ProductDerivations.getConfigurationKey(partialKey, props));
    }

    public static Object getProperty(String partialKey, Map m) {
        if (partialKey == null || m == null || m.isEmpty()) {
            return null;
        }
        return m.get(ProductDerivations.getConfigurationKey(partialKey, m));
    }

    public static Object removeProperty(String partialKey, Map props) {
        if (partialKey == null || props == null || props.isEmpty()) {
            return null;
        }
        if (Configurations.containsProperty(partialKey, props)) {
            return props.remove(ProductDerivations.getConfigurationKey(partialKey, props));
        }
        return null;
    }

    public static void removeProperty(String partialKey, Map<?, ?> remaining, Map<?, ?> props) {
        if (Configurations.removeProperty(partialKey, remaining) != null) {
            Configurations.removeProperty(partialKey, props);
        }
    }

    public static boolean runAgainstAllAnchors(Options opts, Runnable runnable) {
        if (opts.containsKey("help") || opts.containsKey("-help")) {
            return false;
        }
        List<String> anchors = Configurations.getFullyQualifiedAnchorsInPropertiesLocation(opts);
        if (opts.containsKey("p")) {
            opts.remove("p");
        }
        boolean ret = true;
        if (anchors.size() == 0) {
            ret = Configurations.launchRunnable(opts, runnable);
        } else {
            for (String s : anchors) {
                Options clonedOptions = (Options)opts.clone();
                clonedOptions.setProperty("properties", s);
                ret &= Configurations.launchRunnable(clonedOptions, runnable);
            }
        }
        return ret;
    }

    private static boolean launchRunnable(Options opts, Runnable runnable) {
        boolean ret = true;
        try {
            ret = runnable.run(opts);
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) {
                throw new RuntimeException(e);
            }
            throw (RuntimeException)e;
        }
        return ret;
    }

    public static interface Runnable {
        public boolean run(Options var1) throws Exception;
    }
}

