/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import org.apache.openjpa.conf.Specification;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.conf.ValueListener;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificationPlugin
extends ObjectValue
implements ValueListener {
    private Configuration _conf;
    protected static final Localizer _loc = Localizer.forPackage(SpecificationPlugin.class);

    public SpecificationPlugin(Configuration conf, String prop) {
        super(prop);
        this._conf = conf;
        this.addListener(this);
    }

    public Class<?> getValueType() {
        return Specification.class;
    }

    public void setString(String str) {
        this.set(str == null ? null : new Specification(str));
    }

    public void set(Object obj) {
        if (obj == null) {
            super.set(null);
            return;
        }
        if (!(obj instanceof Specification)) {
            throw new UserException(_loc.get("spec-wrong-obj", obj, obj.getClass())).setFatal(true);
        }
        this.validateOverwrite((Specification)obj);
        super.set(obj);
    }

    protected void validateOverwrite(Specification newSpec) {
        Specification current = (Specification)this.get();
        if (current != null) {
            Log log = this._conf.getConfigurationLog();
            if (!current.isSame(newSpec)) {
                log.warn((Object)_loc.get("spec-different", (Object)newSpec, (Object)current));
                return;
            }
            if (current.compareVersion(newSpec) < 0) {
                throw new UserException(_loc.get("spec-version-higher", (Object)newSpec, (Object)current)).setFatal(true);
            }
            if (current.compareVersion(newSpec) > 0) {
                log.warn((Object)_loc.get("spec-version-lower", (Object)newSpec, (Object)current));
            }
        }
    }

    public void valueChanged(Value value) {
        if (((Object)((Object)this)).getClass().isInstance(value)) {
            ProductDerivations.afterSpecificationSet((Configuration)this._conf);
        }
    }
}

