/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.ImplHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryKey
implements Externalizable {
    private static Collection s_unmod = new HashSet();
    private String _candidateClassName;
    private boolean _subclasses;
    private Set _accessPathClassNames;
    private String _query;
    private boolean _ignoreChanges;
    private Map _params;
    private long _rangeStart;
    private long _rangeEnd;
    private int _timeout = -1;

    public static QueryKey newInstance(Query q) {
        return QueryKey.newInstance(q, (Object[])null);
    }

    public static QueryKey newInstance(Query q, Object[] args) {
        q.compile();
        return QueryKey.newInstance((QueryContext)q, false, args, q.getCandidateType(), q.hasSubclasses(), q.getStartRange(), q.getEndRange());
    }

    public static QueryKey newInstance(Query q, Map args) {
        q.compile();
        return QueryKey.newInstance((QueryContext)q, false, args, q.getCandidateType(), q.hasSubclasses(), q.getStartRange(), q.getEndRange());
    }

    static QueryKey newInstance(QueryContext q, boolean packed, Object[] args, Class candidate, boolean subs, long startIdx, long endIdx) {
        QueryKey key = QueryKey.createKey(q, packed, candidate, subs, startIdx, endIdx);
        if (key != null && QueryKey.setParams(key, q, args)) {
            return key;
        }
        return null;
    }

    static QueryKey newInstance(QueryContext q, boolean packed, Map args, Class candidate, boolean subs, long startIdx, long endIdx) {
        QueryKey key = QueryKey.createKey(q, packed, candidate, subs, startIdx, endIdx);
        if (key != null && (args == null || args.isEmpty() || QueryKey.setParams(key, q.getStoreContext(), new HashMap(args)))) {
            return key;
        }
        return null;
    }

    private static QueryKey createKey(QueryContext q, boolean packed, Class candidateClass, boolean subclasses, long startIdx, long endIdx) {
        ClassMetaData meta;
        if (candidateClass == null) {
            return null;
        }
        if (q.getCandidateCollection() != null) {
            return null;
        }
        if (q.getResultType() != null && packed) {
            return null;
        }
        Class<?>[] types = q.getProjectionTypes();
        block4: for (int i = 0; i < types.length; ++i) {
            switch (JavaTypes.getTypeCode(types[i])) {
                case 11: {
                    return null;
                }
                case 8: 
                case 12: 
                case 13: {
                    if (ImplHelper.isManagedType(q.getStoreContext().getConfiguration(), types[i])) continue block4;
                    return null;
                }
            }
        }
        ClassMetaData[] metas = q.getAccessPathMetaDatas();
        if (metas.length == 0) {
            return null;
        }
        HashSet<String> accessPathClassNames = new HashSet<String>((int)((double)metas.length * 1.33 + 1.0));
        for (int i = 0; i < metas.length; ++i) {
            meta = metas[i];
            accessPathClassNames.add(meta.getDescribedType().getName());
            while (meta.getPCSuperclass() != null) {
                meta = meta.getPCSuperclassMetaData();
            }
            accessPathClassNames.add(meta.getDescribedType().getName());
        }
        StoreContext ctx = q.getStoreContext();
        if (QueryKey.intersects(accessPathClassNames, ctx.getPersistedTypes()) || QueryKey.intersects(accessPathClassNames, ctx.getUpdatedTypes()) || QueryKey.intersects(accessPathClassNames, ctx.getDeletedTypes())) {
            return null;
        }
        MetaDataRepository repos = ctx.getConfiguration().getMetaDataRepositoryInstance();
        if (candidateClass.isInterface()) {
            return null;
        }
        meta = repos.getMetaData(candidateClass, ctx.getClassLoader(), true);
        int timeout = meta.getDataCacheTimeout();
        if (subclasses) {
            metas = meta.getPCSubclassMetaDatas();
            for (int i = 0; i < metas.length; ++i) {
                if (metas[i].getDataCache() == null) {
                    return null;
                }
                accessPathClassNames.add(metas[i].getDescribedType().getName());
                int subTimeout = metas[i].getDataCacheTimeout();
                if (subTimeout == -1 || subTimeout >= timeout) continue;
                timeout = subTimeout;
            }
        }
        QueryKey key = new QueryKey();
        key._candidateClassName = candidateClass.getName();
        key._subclasses = subclasses;
        key._accessPathClassNames = accessPathClassNames;
        key._timeout = timeout;
        key._query = q.getQueryString();
        key._ignoreChanges = q.getIgnoreChanges();
        key._rangeStart = startIdx;
        key._rangeEnd = endIdx;
        return key;
    }

    private static boolean setParams(QueryKey key, QueryContext q, Object[] args) {
        if (args == null || args.length == 0) {
            return true;
        }
        OrderedMap<Object, Class<?>> types = q.getOrderedParameterTypes();
        HashMap map = new HashMap((int)((double)types.size() * 1.33 + 1.0));
        int idx = 0;
        Iterator iter = types.keySet().iterator();
        while (iter.hasNext()) {
            map.put(iter.next(), args[idx]);
            ++idx;
        }
        return QueryKey.setParams(key, q.getStoreContext(), map);
    }

    private static boolean setParams(QueryKey key, StoreContext ctx, Map params) {
        if (params == null || params.isEmpty()) {
            return true;
        }
        for (Map.Entry entry : params.entrySet()) {
            Object v = entry.getValue();
            if (ImplHelper.isManageable(v)) {
                if (!ctx.isPersistent(v) || ctx.isNew(v) || ctx.isDeleted(v)) {
                    return false;
                }
                entry.setValue(ctx.getObjectId(v));
            }
            if (v instanceof Collection) {
                Collection c = (Collection)v;
                boolean contentsAreDates = false;
                if (!c.iterator().hasNext()) continue;
                Object o = c.iterator().next();
                if (ImplHelper.isManageable(o)) {
                    return false;
                }
                if (o instanceof Date) {
                    contentsAreDates = true;
                }
                if (!contentsAreDates && s_unmod.contains(c.getClass())) continue;
                AbstractCollection copy = c instanceof SortedSet ? new TreeSet() : (c instanceof Set ? new HashSet() : new ArrayList(c.size()));
                if (contentsAreDates) {
                    Iterator itr2 = c.iterator();
                    while (itr2.hasNext()) {
                        copy.add(((Date)itr2.next()).clone());
                    }
                } else {
                    copy.addAll(c);
                }
                entry.setValue(copy);
                continue;
            }
            if (!(v instanceof Date)) continue;
            entry.setValue(((Date)v).clone());
        }
        key._params = params;
        return true;
    }

    public String getCandidateTypeName() {
        return this._candidateClassName;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public boolean changeInvalidatesQuery(Collection changed) {
        return QueryKey.intersects(this._accessPathClassNames, changed);
    }

    private static boolean intersects(Collection names, Collection changed) {
        for (Class<?> cls : changed) {
            Class<?> sup;
            while ((sup = PCRegistry.getPersistentSuperclass(cls)) != null) {
                cls = sup;
            }
            if (!names.contains(cls.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object ob) {
        if (this == ob) {
            return true;
        }
        if (ob == null || this.getClass() != ob.getClass()) {
            return false;
        }
        QueryKey other = (QueryKey)ob;
        return StringUtils.equals((String)this._candidateClassName, (String)other._candidateClassName) && this._subclasses == other._subclasses && this._ignoreChanges == other._ignoreChanges && this._rangeStart == other._rangeStart && this._rangeEnd == other._rangeEnd && StringUtils.equals((String)this._query, (String)other._query) && ObjectUtils.equals((Object)this._params, (Object)other._params);
    }

    public int hashCode() {
        int code = 629 + this._candidateClassName.hashCode();
        if (this._query != null) {
            code = 37 * code + this._query.hashCode();
        }
        if (this._params != null) {
            code = 37 * code + ((Object)this._params).hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append(super.toString()).append("[query:[").append(this._query).append("]").append(",access path:").append(this._accessPathClassNames).append(",subs:").append(this._subclasses).append(",ignoreChanges:").append(this._ignoreChanges).append(",startRange:").append(this._rangeStart).append(",endRange:").append(this._rangeEnd).append(",timeout:").append(this._timeout).append("]");
        return buf.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._candidateClassName);
        out.writeBoolean(this._subclasses);
        out.writeObject(this._accessPathClassNames);
        out.writeObject(this._query);
        out.writeBoolean(this._ignoreChanges);
        out.writeObject(this._params);
        out.writeLong(this._rangeStart);
        out.writeLong(this._rangeEnd);
        out.writeInt(this._timeout);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._candidateClassName = (String)in.readObject();
        this._subclasses = in.readBoolean();
        this._accessPathClassNames = (Set)in.readObject();
        this._query = (String)in.readObject();
        this._ignoreChanges = in.readBoolean();
        this._params = (Map)in.readObject();
        this._rangeStart = in.readLong();
        this._rangeEnd = in.readLong();
        this._timeout = in.readInt();
    }

    public Set<String> getAcessPathClassNames() {
        return this._accessPathClassNames;
    }

    static {
        TreeSet s = new TreeSet();
        s_unmod.add(Collections.unmodifiableCollection(s).getClass());
        s_unmod.add(Collections.unmodifiableSet(s).getClass());
        s_unmod.add(Collections.unmodifiableSortedSet(s).getClass());
        AbstractList l = new LinkedList();
        s_unmod.add(Collections.unmodifiableList(l).getClass());
        l = new ArrayList(0);
        s_unmod.add(Collections.unmodifiableList(l).getClass());
        s_unmod.add(Collections.EMPTY_SET.getClass());
        s_unmod.add(Collections.EMPTY_LIST.getClass());
    }
}

