/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.openjpa.lib.jdbc.DelegatingResultSet;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingCallableStatement
implements CallableStatement,
Closeable {
    static final Constructor<DelegatingCallableStatement> concreteImpl;
    private final CallableStatement _stmnt;
    private final DelegatingCallableStatement _del;
    private final Connection _conn;

    public DelegatingCallableStatement(CallableStatement stmnt, Connection conn) {
        this._conn = conn;
        this._stmnt = stmnt;
        this._del = this._stmnt instanceof DelegatingCallableStatement ? (DelegatingCallableStatement)this._stmnt : null;
    }

    public static DelegatingCallableStatement newInstance(CallableStatement stmnt, Connection conn) {
        return ConcreteClassGenerator.newInstance(concreteImpl, stmnt, conn);
    }

    protected ResultSet wrapResult(boolean wrap, ResultSet rs) {
        if (!wrap) {
            return rs;
        }
        if (rs == null) {
            return null;
        }
        return DelegatingResultSet.newInstance(rs, this);
    }

    public CallableStatement getDelegate() {
        return this._stmnt;
    }

    public CallableStatement getInnermostDelegate() {
        return this._del == null ? this._stmnt : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingCallableStatement) {
            other = ((DelegatingCallableStatement)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("callstmnt ").append(this.hashCode());
        this.appendInfo(buf);
        return buf.toString();
    }

    protected void appendInfo(StringBuffer buf) {
        if (this._del != null) {
            this._del.appendInfo(buf);
        }
    }

    @Override
    public ResultSet executeQuery(String str) throws SQLException {
        return this.executeQuery(true);
    }

    protected ResultSet executeQuery(String sql, boolean wrap) throws SQLException {
        ResultSet rs = this._del != null ? this._del.executeQuery(sql, false) : this._stmnt.executeQuery(sql);
        return this.wrapResult(wrap, rs);
    }

    @Override
    public int executeUpdate(String str) throws SQLException {
        return this._stmnt.executeUpdate(str);
    }

    @Override
    public boolean execute(String str) throws SQLException {
        return this._stmnt.execute(str);
    }

    @Override
    public void close() throws SQLException {
        this._stmnt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._stmnt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        this._stmnt.setMaxFieldSize(i);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._stmnt.getMaxRows();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        this._stmnt.setMaxRows(i);
    }

    @Override
    public void setEscapeProcessing(boolean bool) throws SQLException {
        this._stmnt.setEscapeProcessing(bool);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this._stmnt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        this._stmnt.setQueryTimeout(i);
    }

    @Override
    public void cancel() throws SQLException {
        this._stmnt.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._stmnt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._stmnt.clearWarnings();
    }

    @Override
    public void setCursorName(String str) throws SQLException {
        this._stmnt.setCursorName(str);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(true);
    }

    protected ResultSet getResultSet(boolean wrap) throws SQLException {
        ResultSet rs = this._del != null ? this._del.getResultSet(false) : this._stmnt.getResultSet();
        return this.wrapResult(wrap, rs);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this._stmnt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this._stmnt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        this._stmnt.setFetchDirection(i);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._stmnt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        this._stmnt.setFetchSize(i);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._stmnt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._stmnt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._stmnt.getResultSetType();
    }

    @Override
    public void addBatch(String str) throws SQLException {
        this._stmnt.addBatch(str);
    }

    @Override
    public void clearBatch() throws SQLException {
        this._stmnt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this._stmnt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(true);
    }

    protected ResultSet executeQuery(boolean wrap) throws SQLException {
        ResultSet rs = this._del != null ? this._del.executeQuery(false) : this._stmnt.executeQuery();
        return this.wrapResult(wrap, rs);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this._stmnt.executeUpdate();
    }

    @Override
    public void setNull(int i1, int i2) throws SQLException {
        this._stmnt.setNull(i1, i2);
    }

    @Override
    public void setBoolean(int i, boolean b) throws SQLException {
        this._stmnt.setBoolean(i, b);
    }

    @Override
    public void setByte(int i, byte b) throws SQLException {
        this._stmnt.setByte(i, b);
    }

    @Override
    public void setShort(int i, short s) throws SQLException {
        this._stmnt.setShort(i, s);
    }

    @Override
    public void setInt(int i1, int i2) throws SQLException {
        this._stmnt.setInt(i1, i2);
    }

    @Override
    public void setLong(int i, long l) throws SQLException {
        this._stmnt.setLong(i, l);
    }

    @Override
    public void setFloat(int i, float f) throws SQLException {
        this._stmnt.setFloat(i, f);
    }

    @Override
    public void setDouble(int i, double d) throws SQLException {
        this._stmnt.setDouble(i, d);
    }

    @Override
    public void setBigDecimal(int i, BigDecimal bd) throws SQLException {
        this._stmnt.setBigDecimal(i, bd);
    }

    @Override
    public void setString(int i, String s) throws SQLException {
        this._stmnt.setString(i, s);
    }

    @Override
    public void setBytes(int i, byte[] b) throws SQLException {
        this._stmnt.setBytes(i, b);
    }

    @Override
    public void setDate(int i, Date d) throws SQLException {
        this._stmnt.setDate(i, d);
    }

    @Override
    public void setTime(int i, Time t) throws SQLException {
        this._stmnt.setTime(i, t);
    }

    @Override
    public void setTimestamp(int i, Timestamp t) throws SQLException {
        this._stmnt.setTimestamp(i, t);
    }

    @Override
    public void setAsciiStream(int i1, InputStream is, int i2) throws SQLException {
        this._stmnt.setAsciiStream(i1, is, i2);
    }

    @Override
    public void setUnicodeStream(int i1, InputStream is, int i2) throws SQLException {
        this._stmnt.setUnicodeStream(i1, is, i2);
    }

    @Override
    public void setBinaryStream(int i1, InputStream is, int i2) throws SQLException {
        this._stmnt.setBinaryStream(i1, is, i2);
    }

    @Override
    public void clearParameters() throws SQLException {
        this._stmnt.clearParameters();
    }

    @Override
    public void setObject(int i1, Object o, int i2, int i3) throws SQLException {
        this._stmnt.setObject(i1, o, i2, i3);
    }

    @Override
    public void setObject(int i1, Object o, int i2) throws SQLException {
        this._stmnt.setObject(i1, o, i2);
    }

    @Override
    public void setObject(int i, Object o) throws SQLException {
        this._stmnt.setObject(i, o);
    }

    @Override
    public boolean execute() throws SQLException {
        return this._stmnt.execute();
    }

    @Override
    public void addBatch() throws SQLException {
        this._stmnt.addBatch();
    }

    @Override
    public void setCharacterStream(int i1, Reader r, int i2) throws SQLException {
        this._stmnt.setCharacterStream(i1, r, i2);
    }

    @Override
    public void setRef(int i, Ref r) throws SQLException {
        this._stmnt.setRef(i, r);
    }

    @Override
    public void setBlob(int i, Blob b) throws SQLException {
        this._stmnt.setBlob(i, b);
    }

    @Override
    public void setClob(int i, Clob c) throws SQLException {
        this._stmnt.setClob(i, c);
    }

    @Override
    public void setArray(int i, Array a) throws SQLException {
        this._stmnt.setArray(i, a);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this._stmnt.getMetaData();
    }

    @Override
    public void setDate(int i, Date d, Calendar c) throws SQLException {
        this._stmnt.setDate(i, d, c);
    }

    @Override
    public void setTime(int i, Time t, Calendar c) throws SQLException {
        this._stmnt.setTime(i, t, c);
    }

    @Override
    public void setTimestamp(int i, Timestamp t, Calendar c) throws SQLException {
        this._stmnt.setTimestamp(i, t, c);
    }

    @Override
    public void setNull(int i1, int i2, String s) throws SQLException {
        this._stmnt.setNull(i1, i2, s);
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String s, int[] ia) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String s, String[] sa) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String s, int[] ia) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String s, String[] sa) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(int i, URL url) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(int i1, int i2) throws SQLException {
        this._stmnt.registerOutParameter(i1, i2);
    }

    @Override
    public void registerOutParameter(int i1, int i2, int i3) throws SQLException {
        this._stmnt.registerOutParameter(i1, i2, i3);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._stmnt.wasNull();
    }

    @Override
    public String getString(int i) throws SQLException {
        return this._stmnt.getString(i);
    }

    @Override
    public boolean getBoolean(int i) throws SQLException {
        return this._stmnt.getBoolean(i);
    }

    @Override
    public byte getByte(int i) throws SQLException {
        return this._stmnt.getByte(i);
    }

    @Override
    public short getShort(int i) throws SQLException {
        return this._stmnt.getShort(i);
    }

    @Override
    public int getInt(int i) throws SQLException {
        return this._stmnt.getInt(i);
    }

    @Override
    public long getLong(int i) throws SQLException {
        return this._stmnt.getLong(i);
    }

    @Override
    public float getFloat(int i) throws SQLException {
        return this._stmnt.getFloat(i);
    }

    @Override
    public double getDouble(int i) throws SQLException {
        return this._stmnt.getDouble(i);
    }

    @Override
    public BigDecimal getBigDecimal(int a, int b) throws SQLException {
        return this._stmnt.getBigDecimal(a, b);
    }

    @Override
    public byte[] getBytes(int i) throws SQLException {
        return this._stmnt.getBytes(i);
    }

    @Override
    public Date getDate(int i) throws SQLException {
        return this._stmnt.getDate(i);
    }

    @Override
    public Time getTime(int i) throws SQLException {
        return this._stmnt.getTime(i);
    }

    @Override
    public Timestamp getTimestamp(int i) throws SQLException {
        return this._stmnt.getTimestamp(i);
    }

    @Override
    public Object getObject(int i) throws SQLException {
        return this._stmnt.getObject(i);
    }

    @Override
    public BigDecimal getBigDecimal(int i) throws SQLException {
        return this._stmnt.getBigDecimal(i);
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> m) throws SQLException {
        return this._stmnt.getObject(i, m);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this._stmnt.getRef(i);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return this._stmnt.getBlob(i);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this._stmnt.getClob(i);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this._stmnt.getArray(i);
    }

    @Override
    public Date getDate(int i, Calendar c) throws SQLException {
        return this._stmnt.getDate(i, c);
    }

    @Override
    public Time getTime(int i, Calendar c) throws SQLException {
        return this._stmnt.getTime(i, c);
    }

    @Override
    public Timestamp getTimestamp(int i, Calendar c) throws SQLException {
        return this._stmnt.getTimestamp(i, c);
    }

    @Override
    public void registerOutParameter(int i1, int i2, String s) throws SQLException {
        this._stmnt.registerOutParameter(i1, i2, s);
    }

    @Override
    public void registerOutParameter(String s, int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String s, int i1, int i2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String s1, int i, String s2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(int i) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(String a, URL b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(String a, int b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(String a, boolean b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setByte(String a, byte b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShort(String a, short b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(String a, int b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(String a, long b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(String a, float b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(String a, double b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBigDecimal(String a, BigDecimal b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(String a, String b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(String a, byte[] b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String a, Date b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(String a, Time b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(String a, Timestamp b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(String a, InputStream b, int c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(String a, InputStream b, int c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String a, Object b, int c, int d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String a, Object b, int c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String a, Object b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(String a, Reader b, int c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String a, Date b, Calendar c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(String a, Time b, Calendar c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(String a, Timestamp b, Calendar c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(String a, int b, String c) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String a, Map<String, Class<?>> b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String a) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String a, Calendar b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String a, Calendar b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String a, Calendar b) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isWrapperFor(Class iface) {
        return iface.isAssignableFrom(this.getDelegate().getClass());
    }

    public Object unwrap(Class iface) {
        if (this.isWrapperFor(iface)) {
            return this.getDelegate();
        }
        return null;
    }

    static {
        try {
            concreteImpl = ConcreteClassGenerator.getConcreteConstructor(DelegatingCallableStatement.class, CallableStatement.class, Connection.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

