/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.sql.SQLException;
import java.sql.Statement;

public class ReportingSQLException
extends SQLException {
    private final transient Statement _stmnt;
    private final SQLException _sqle;
    private final String _sql;
    private int indexOfFirstFailedObject = -1;

    public ReportingSQLException(SQLException sqle, Statement stmnt, String sql) {
        super(ReportingSQLException.getExceptionMessage(sqle, stmnt, sql));
        this._sqle = sqle;
        this._stmnt = stmnt;
        this._sql = sql;
        this.setNextException(sqle);
    }

    public String getSQL() {
        return this._sql;
    }

    public String getSQLState() {
        return this._sqle.getSQLState();
    }

    public int getErrorCode() {
        return this._sqle.getErrorCode();
    }

    public Statement getStatement() {
        return this._stmnt;
    }

    public int getIndexOfFirstFailedObject() {
        return this.indexOfFirstFailedObject;
    }

    public void setIndexOfFirstFailedObject(int index) {
        this.indexOfFirstFailedObject = index;
    }

    private static String getExceptionMessage(SQLException sqle, Statement stmnt, String sql) {
        try {
            if (stmnt != null) {
                return sqle.getMessage() + " {" + stmnt + "} " + "[code=" + sqle.getErrorCode() + ", state=" + sqle.getSQLState() + "]";
            }
            if (sql != null) {
                return sqle.getMessage() + " {" + sql + "} " + "[code=" + sqle.getErrorCode() + ", state=" + sqle.getSQLState() + "]";
            }
            return sqle.getMessage() + " " + "[code=" + sqle.getErrorCode() + ", state=" + sqle.getSQLState() + "]";
        }
        catch (Throwable t) {
            return sqle.getMessage();
        }
    }
}

