/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.DelegatingMetaDataFactory;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.XMLFieldMetaData;
import org.apache.openjpa.meta.XMLMetaData;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPersistenceXMLMetaDataParser {
    private static final Localizer _loc = Localizer.forPackage(AnnotationPersistenceXMLMetaDataParser.class);
    private final OpenJPAConfiguration _conf;
    private final Log _log;
    private MetaDataRepository _repos = null;
    private Class xmlTypeClass = null;
    private Class xmlRootElementClass = null;
    private Class xmlAccessorTypeClass = null;
    private Class xmlAttributeClass = null;
    private Class xmlElementClass = null;
    private Method xmlTypeName = null;
    private Method xmlTypeNamespace = null;
    private Method xmlRootName = null;
    private Method xmlRootNamespace = null;
    private Method xmlAttributeName = null;
    private Method xmlAttributeNamespace = null;
    private Method xmlElementName = null;
    private Method xmlElementNamespace = null;
    private Method xmlAccessorValue = null;

    public AnnotationPersistenceXMLMetaDataParser(OpenJPAConfiguration conf) {
        this._conf = conf;
        this._log = conf.getLog("openjpa.MetaData");
        try {
            this.xmlTypeClass = Class.forName("javax.xml.bind.annotation.XmlType");
            this.xmlTypeName = this.xmlTypeClass.getMethod("name", null);
            this.xmlTypeNamespace = this.xmlTypeClass.getMethod("namespace", null);
            this.xmlRootElementClass = Class.forName("javax.xml.bind.annotation.XmlRootElement");
            this.xmlRootName = this.xmlRootElementClass.getMethod("name", null);
            this.xmlRootNamespace = this.xmlRootElementClass.getMethod("namespace", null);
            this.xmlAccessorTypeClass = Class.forName("javax.xml.bind.annotation.XmlAccessorType");
            this.xmlAccessorValue = this.xmlAccessorTypeClass.getMethod("value", null);
            this.xmlAttributeClass = Class.forName("javax.xml.bind.annotation.XmlAttribute");
            this.xmlAttributeName = this.xmlAttributeClass.getMethod("name", null);
            this.xmlAttributeNamespace = this.xmlAttributeClass.getMethod("namespace", null);
            this.xmlElementClass = Class.forName("javax.xml.bind.annotation.XmlElement");
            this.xmlElementName = this.xmlElementClass.getMethod("name", null);
            this.xmlElementNamespace = this.xmlElementClass.getMethod("namespace", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public Log getLog() {
        return this._log;
    }

    public MetaDataRepository getRepository() {
        if (this._repos == null) {
            MetaDataRepository repos = this._conf.newMetaDataRepositoryInstance();
            MetaDataFactory mdf = repos.getMetaDataFactory();
            if (mdf instanceof DelegatingMetaDataFactory) {
                mdf = ((DelegatingMetaDataFactory)mdf).getInnermostDelegate();
            }
            if (mdf instanceof PersistenceMetaDataFactory) {
                ((PersistenceMetaDataFactory)mdf).setXMLAnnotationParser(this);
            }
            this._repos = repos;
        }
        return this._repos;
    }

    public void setRepository(MetaDataRepository repos) {
        this._repos = repos;
    }

    public void clear() {
    }

    public synchronized void parse(FieldMetaData fmd) {
        Class cls = fmd.getDeclaredType();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("parse-class", (Object)cls.getName()));
        }
        this.parseXMLClassAnnotations(cls, fmd);
    }

    private XMLMetaData parseXMLClassAnnotations(Class<?> cls, FieldMetaData fmd) {
        if (cls == null || this.xmlTypeClass == null || !((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(cls, (Class)this.xmlTypeClass))).booleanValue() || !((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(cls, (Class)this.xmlRootElementClass))).booleanValue()) {
            return null;
        }
        XMLMetaData meta = this.getXMLMetaData(cls, fmd);
        return meta;
    }

    private XMLMetaData getXMLMetaData(Class<?> cls, FieldMetaData fmd) {
        XMLMetaData meta = this.getRepository().getCachedXMLMetaData(cls);
        if (meta == null) {
            meta = this.getRepository().addXMLMetaData(cls, fmd.getName());
            this.parseXmlRootElement(cls, meta);
            this.populateFromReflection(cls, meta);
        }
        return meta;
    }

    private void parseXmlRootElement(Class type, XMLMetaData meta) {
        try {
            if (type.getAnnotation(this.xmlRootElementClass) != null) {
                meta.setXmlRootElement(true);
                meta.setXmlname((String)this.xmlRootName.invoke(type.getAnnotation(this.xmlRootElementClass), new Object[0]));
                meta.setXmlnamespace((String)this.xmlRootNamespace.invoke(type.getAnnotation(this.xmlRootElementClass), new Object[0]));
            } else {
                meta.setXmlname((String)this.xmlTypeName.invoke(type.getAnnotation(this.xmlTypeClass), new Object[0]));
                meta.setXmlnamespace((String)this.xmlTypeNamespace.invoke(type.getAnnotation(this.xmlTypeClass), new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void populateFromReflection(Class cls, XMLMetaData meta) {
        Class superclass = cls.getSuperclass();
        if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(superclass, (Class)this.xmlTypeClass))).booleanValue()) {
            this.populateFromReflection(superclass, meta);
        }
        try {
            AccessibleObject[] members = StringUtils.equals((String)this.xmlAccessorValue.invoke(cls.getAnnotation(this.xmlAccessorTypeClass), new Object[0]).toString(), (String)"FIELD") ? cls.getDeclaredFields() : cls.getDeclaredMethods();
            for (int i = 0; i < members.length; ++i) {
                String xmlname;
                AccessibleObject member = members[i];
                AnnotatedElement el = member;
                XMLFieldMetaData field = null;
                if (el.getAnnotation(this.xmlElementClass) != null) {
                    xmlname = (String)this.xmlElementName.invoke(el.getAnnotation(this.xmlElementClass), new Object[0]);
                    if (StringUtils.equals((String)"##default", (String)xmlname)) {
                        xmlname = member.getName();
                    }
                    if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(((Field)member).getType(), (Class)this.xmlTypeClass))).booleanValue()) {
                        field = this._repos.addXMLMetaData(((Field)member).getType(), member.getName());
                        this.parseXmlRootElement(((Field)member).getType(), (XMLMetaData)field);
                        this.populateFromReflection(((Field)member).getType(), (XMLMetaData)field);
                        field.setXmltype(0);
                        field.setXmlname(xmlname);
                    } else {
                        field = this._repos.newXMLFieldMetaData(((Field)member).getType(), member.getName());
                        field.setXmltype(1);
                        field.setXmlname(xmlname);
                        field.setXmlnamespace((String)this.xmlElementNamespace.invoke(el.getAnnotation(this.xmlElementClass), new Object[0]));
                    }
                } else if (el.getAnnotation(this.xmlAttributeClass) != null) {
                    field = this._repos.newXMLFieldMetaData(((Field)member).getType(), member.getName());
                    field.setXmltype(2);
                    xmlname = (String)this.xmlAttributeName.invoke(el.getAnnotation(this.xmlAttributeClass), new Object[0]);
                    if (StringUtils.equals((String)"##default", (String)xmlname)) {
                        xmlname = member.getName();
                    }
                    field.setXmlname("@" + xmlname);
                    field.setXmlnamespace((String)this.xmlAttributeNamespace.invoke(el.getAnnotation(this.xmlAttributeClass), new Object[0]));
                }
                if (field == null) continue;
                meta.addField(member.getName(), field);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

