/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CompoundSelections;
import org.apache.openjpa.persistence.criteria.CriteriaExpression;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionBuilder;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionVisitor;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.criteria.ParameterExpressionImpl;
import org.apache.openjpa.persistence.criteria.PredicateImpl;
import org.apache.openjpa.persistence.criteria.RootImpl;
import org.apache.openjpa.persistence.criteria.SelectionImpl;
import org.apache.openjpa.persistence.criteria.SubqueryImpl;
import org.apache.openjpa.persistence.meta.MetamodelImpl;
import org.apache.openjpa.persistence.meta.Types;

class CriteriaQueryImpl<T>
implements OpenJPACriteriaQuery<T>,
AliasContext {
    private static final Localizer _loc = Localizer.forPackage(CriteriaQueryImpl.class);
    private final MetamodelImpl _model;
    private Set<Root<?>> _roots;
    private PredicateImpl _where;
    private List<Order> _orders;
    private OrderedMap<Object, Class<?>> _params = new OrderedMap();
    private Selection<? extends T> _selection;
    private List<Selection<?>> _selections;
    private List<Expression<?>> _groups;
    private PredicateImpl _having;
    private List<Subquery<?>> _subqueries;
    private boolean _distinct;
    private final SubqueryImpl<?> _delegator;
    private final Class<T> _resultClass;
    private boolean _compiled;
    private int aliasCount = 0;
    private static String ALIAS_BASE = "autoAlias";
    private Map<Selection<?>, Value> _variables = new HashMap();
    private Map<Selection<?>, Value> _values = new HashMap();
    private Map<Selection<?>, String> _aliases = null;
    private Map<Selection<?>, Value> _rootVariables = new HashMap();
    private ThreadLocal<Stack<Context>> _contexts = new ThreadLocal<Stack<Context>>(){

        @Override
        protected Stack<Context> initialValue() {
            return new Stack<Context>();
        }
    };

    public CriteriaQueryImpl(MetamodelImpl model, Class<T> resultClass) {
        this._model = model;
        this._resultClass = resultClass;
        this._delegator = null;
        this._aliases = new HashMap();
    }

    CriteriaQueryImpl(MetamodelImpl model, SubqueryImpl<T> delegator, OrderedMap<Object, Class<?>> params) {
        this._model = model;
        this._resultClass = delegator.getJavaType();
        this._delegator = delegator;
        this._aliases = this.getAliases();
        this._params = params;
    }

    SubqueryImpl<?> getDelegator() {
        return this._delegator;
    }

    public MetamodelImpl getMetamodel() {
        return this._model;
    }

    Stack<Context> getContexts() {
        return this._contexts.get();
    }

    public CriteriaQuery<T> distinct(boolean distinct) {
        this._distinct = distinct;
        return this;
    }

    public List<Order> getOrderList() {
        return Expressions.returnCopy(this._orders);
    }

    public Selection<T> getSelection() {
        return this._selection;
    }

    public CriteriaQuery<T> multiselect(Selection<?> ... selections) {
        this._selections = Arrays.asList(selections);
        this._selection = new CompoundSelections.MultiSelection<T>(this._resultClass, selections);
        return this;
    }

    void registerParameter(ParameterExpressionImpl<?> p) {
        if (!this._params.containsKey(p)) {
            p.setIndex(this._params.size());
            this._params.put(p, p.getJavaType());
        }
    }

    public Set<ParameterExpression<?>> getParameters() {
        this.collectParameters(new CriteriaExpressionVisitor.ParameterVisitor(this));
        return this._params.keySet();
    }

    public List<Selection<?>> getSelectionList() {
        return Expressions.returnCopy(this._selections);
    }

    public CriteriaQuery<T> groupBy(Expression<?> ... grouping) {
        if (grouping == null) {
            this._groups = null;
            return this;
        }
        this._groups = new ArrayList();
        for (Expression<?> e : grouping) {
            this._groups.add(e);
        }
        return this;
    }

    public CriteriaQuery<T> groupBy(List<Expression<?>> grouping) {
        if (grouping == null) {
            this._groups = null;
            return this;
        }
        this._groups = new ArrayList();
        for (Expression<?> e : grouping) {
            this._groups.add(e);
        }
        return this;
    }

    public CriteriaQuery<T> having(Expression<Boolean> restriction) {
        this._having = (PredicateImpl)restriction;
        return this;
    }

    public CriteriaQuery<T> having(Predicate ... restrictions) {
        if (restrictions == null) {
            this._having = null;
            return this;
        }
        this._having = new PredicateImpl.And(new Predicate[0]);
        for (Predicate p : restrictions) {
            this._having.add((Expression<Boolean>)p);
        }
        return this;
    }

    public CriteriaQuery<T> orderBy(Order ... orders) {
        if (orders == null) {
            this._orders = null;
            return this;
        }
        this._orders = new ArrayList<Order>();
        for (Order o : orders) {
            this._orders.add(o);
        }
        return this;
    }

    public CriteriaQuery<T> orderBy(List<Order> orders) {
        if (orders == null) {
            this._orders = null;
            return this;
        }
        this._orders = new ArrayList<Order>();
        for (Order o : orders) {
            this._orders.add(o);
        }
        return this;
    }

    public CriteriaQuery<T> select(Selection<? extends T> selection) {
        this._selection = selection;
        this._selections = new ArrayList();
        this._selections.add(selection);
        return this;
    }

    public CriteriaQuery<T> where(Expression<Boolean> restriction) {
        this.invalidateCompilation();
        if (restriction == null) {
            this._where = null;
            return this;
        }
        this._where = (PredicateImpl)restriction;
        return this;
    }

    public CriteriaQuery<T> where(Predicate ... restrictions) {
        this.invalidateCompilation();
        if (restrictions == null) {
            this._where = null;
            return this;
        }
        this._where = new PredicateImpl.And(restrictions);
        return this;
    }

    public <X> Root<X> from(EntityType<X> entity) {
        RootImpl root = new RootImpl((Types.Entity)entity);
        this.addRoot(root);
        return root;
    }

    public <X> Root<X> from(Class<X> cls) {
        EntityType<X> entity = this._model.entityImpl(cls);
        if (entity == null) {
            throw new IllegalArgumentException(_loc.get("root-non-entity", cls).getMessage());
        }
        return this.from(entity);
    }

    public List<Expression<?>> getGroupList() {
        return Expressions.returnCopy(this._groups);
    }

    public PredicateImpl getGroupRestriction() {
        return this._having;
    }

    public PredicateImpl getRestriction() {
        return this._where;
    }

    public Set<Root<?>> getRoots() {
        return Expressions.returnCopy(this._roots);
    }

    public Root<?> getRoot() {
        this.assertRoot();
        return this._roots.iterator().next();
    }

    Root<?> getRoot(boolean mustExist) {
        if (mustExist) {
            return this.getRoot();
        }
        return this._roots == null || this._roots.isEmpty() ? null : this._roots.iterator().next();
    }

    void addRoot(RootImpl<?> root) {
        if (this._roots == null) {
            this._roots = new LinkedHashSet();
        }
        this._roots.add(root);
    }

    public boolean isDistinct() {
        return this._distinct;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        if (this._subqueries == null) {
            this._subqueries = new ArrayList();
        }
        SubqueryImpl<U> subquery = new SubqueryImpl<U>(type, (AbstractQuery<?>)this);
        this._subqueries.add(subquery);
        return subquery;
    }

    public OrderedMap<Object, Class<?>> getParameterTypes() {
        this.collectParameters(new CriteriaExpressionVisitor.ParameterVisitor(this));
        return this._params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueryExpressions getQueryExpressions(ExpressionFactory factory) {
        Context context = new Context(null, null, null);
        this._contexts.get().push(context);
        try {
            QueryExpressions queryExpressions = new CriteriaExpressionBuilder().getQueryExpressions(factory, this);
            return queryExpressions;
        }
        finally {
            this._contexts.remove();
        }
    }

    public void assertRoot() {
        if (this._roots == null || this._roots.isEmpty()) {
            throw new IllegalStateException(_loc.get("root-undefined").getMessage());
        }
    }

    public void assertSelection() {
        if (this._selection == null && !this.isDefaultProjection()) {
            throw new IllegalStateException(_loc.get("select-undefined").getMessage());
        }
    }

    void setContexts(Stack<Context> contexts) {
        this._contexts.set(contexts);
    }

    CriteriaQueryImpl<?> getAncestor() {
        if (this._delegator == null) {
            return this;
        }
        AbstractQuery<?> parent = this._delegator.getParent();
        if (parent instanceof CriteriaQueryImpl) {
            return (CriteriaQueryImpl)parent;
        }
        return ((SubqueryImpl)parent).getDelegate().getAncestor();
    }

    public Map<Selection<?>, String> getAliases() {
        CriteriaQueryImpl<?> c = this.getAncestor();
        if (c._aliases == null) {
            c._aliases = new HashMap();
        }
        return c._aliases;
    }

    Context ctx() {
        Stack<Context> ctxt = this._contexts.get();
        return ctxt == null || ctxt.isEmpty() ? null : ctxt.peek();
    }

    @Override
    public String getAlias(Selection<?> selection) {
        String alias = selection.getAlias();
        if (alias != null) {
            this._aliases.put(selection, alias);
            return alias;
        }
        alias = ALIAS_BASE + ++this.aliasCount;
        while (this._aliases.containsValue(alias)) {
            alias = ALIAS_BASE + ++this.aliasCount;
        }
        ((SelectionImpl)selection).setAutoAlias(alias);
        this._aliases.put(selection, alias);
        return this._aliases.get(selection);
    }

    @Override
    public void registerVariable(Selection<?> node, Value var, Value path) {
        if (this.isRegistered(node)) {
            return;
        }
        if (!var.isVariable()) {
            throw new RuntimeException(var.getClass() + " is not a variable");
        }
        if (var.getPath() != path) {
            throw new RuntimeException(var + " does not match given " + path + " Variable path is " + var.getPath());
        }
        String alias = this.getAlias(node);
        if (!alias.equals(var.getAlias())) {
            if (var.getAlias() == null) {
                var.setAlias(alias);
            } else {
                throw new RuntimeException("Variable alias " + var.getAlias() + " does not match expected selection alias " + alias);
            }
        }
        if (!alias.equals(path.getAlias())) {
            if (path.getAlias() == null) {
                path.setAlias(alias);
            } else {
                throw new RuntimeException("Path alias " + path.getAlias() + " does not match expected selection alias " + alias);
            }
        }
        this._variables.put(node, var);
        this._values.put(node, path);
        this._aliases.put(node, alias);
        this.ctx().addSchema(alias, var.getMetaData());
        this.ctx().addVariable(alias, var);
    }

    @Override
    public boolean isRegistered(Selection<?> selection) {
        if (this._variables.containsKey(selection)) {
            return true;
        }
        SubqueryImpl<?> delegator = this.getDelegator();
        return delegator == null ? false : this.getDelegatorParent().isRegistered(selection);
    }

    @Override
    public Value getRegisteredVariable(Selection<?> selection) {
        Value var = this._variables.get(selection);
        if (var != null) {
            return var;
        }
        SubqueryImpl<?> delegator = this.getDelegator();
        return delegator == null ? null : this.getDelegatorParent().getRegisteredVariable(selection);
    }

    @Override
    public Value getRegisteredValue(Selection<?> selection) {
        Value val = this._values.get(selection);
        if (val != null) {
            return val;
        }
        SubqueryImpl<?> delegator = this.getDelegator();
        return delegator == null ? null : this.getDelegatorParent().getRegisteredValue(selection);
    }

    void registerRoot(Root<?> root, Value var) {
        if (var == null || !var.isVariable()) {
            throw new IllegalArgumentException("Attempt to register non-variable " + var);
        }
        this._rootVariables.put((Selection<?>)root, var);
        String alias = var.getName();
        this.ctx().addSchema(alias, var.getMetaData());
        this.ctx().addVariable(alias, var);
    }

    @Override
    public Value getRegisteredRootVariable(Root<?> root) {
        Value var = this._rootVariables.get(root);
        if (var != null) {
            return var;
        }
        SubqueryImpl<?> delegator = this.getDelegator();
        return delegator == null ? null : this.getDelegatorParent().getRegisteredRootVariable(root);
    }

    CriteriaQueryImpl<?> getDelegatorParent() {
        AbstractQuery<?> parent = this._delegator.getParent();
        if (parent instanceof CriteriaQueryImpl) {
            return (CriteriaQueryImpl)parent;
        }
        return ((SubqueryImpl)parent).getDelegate();
    }

    public Class<T> getResultType() {
        return this._resultClass;
    }

    public CriteriaQuery<T> multiselect(List<Selection<?>> list) {
        return this.multiselect(list.toArray(new Selection[list.size()]));
    }

    boolean isMultiselect() {
        return this._selection instanceof CompoundSelections.MultiSelection;
    }

    protected boolean isDefaultProjection() {
        if (this._selections == null) {
            return this.getRoots().size() == 1 && (this.getRoot().getModel().getJavaType() == this._resultClass || this._resultClass == Object.class);
        }
        if (this._selections.size() != 1) {
            return false;
        }
        Selection<?> sel = this._selections.get(0);
        if (!this.getRoots().isEmpty() && sel == this.getRoot()) {
            return true;
        }
        return sel instanceof From && ((From)sel).isCorrelated();
    }

    void invalidateCompilation() {
        this._compiled = false;
        this._params.clear();
    }

    @Override
    public OpenJPACriteriaQuery<T> compile() {
        if (this._compiled) {
            return this;
        }
        this.assertRoot();
        this.assertSelection();
        this.collectParameters(new CriteriaExpressionVisitor.ParameterVisitor(this));
        this._compiled = true;
        return this;
    }

    private void collectParameters(CriteriaExpressionVisitor visitor) {
        if (this._compiled) {
            return;
        }
        if (this._where != null) {
            this._where.acceptVisit(visitor);
        }
        if (this._having != null) {
            this._having.acceptVisit(visitor);
        }
        if (this._subqueries != null) {
            for (Subquery<?> subq : this._subqueries) {
                super.collectParameters(visitor);
            }
        }
    }

    @Override
    public String toCQL() {
        StringBuilder buffer = new StringBuilder();
        this.render(buffer, this._roots, null);
        return buffer.toString().trim();
    }

    void render(StringBuilder buffer, Set<Root<?>> roots, List<Join<?, ?>> correlatedJoins) {
        buffer.append("SELECT ");
        if (this.isDistinct()) {
            buffer.append(" DISTINCT ");
        }
        buffer.append(this._selection != null ? ((CriteriaExpression)this._selection).asProjection(this) : "*");
        buffer.append(" FROM ");
        this.renderRoots(buffer, roots);
        this.renderJoins(buffer, correlatedJoins);
        if (this._where != null) {
            buffer.append(" WHERE ").append((CharSequence)this._where.asValue(this));
        }
        this.renderList(buffer, " ORDER BY ", this.getOrderList());
        this.renderList(buffer, " GROUP BY ", this.getGroupList());
        if (this._having != null) {
            buffer.append(" HAVING ");
            buffer.append((CharSequence)this._having.asValue(this));
        }
    }

    private void renderList(StringBuilder buffer, String clause, Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return;
        }
        buffer.append(clause);
        Iterator<?> i = coll.iterator();
        while (i.hasNext()) {
            buffer.append((CharSequence)((CriteriaExpression)i.next()).asValue(this));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
    }

    private void renderJoins(StringBuilder buffer, Collection<Join<?, ?>> joins) {
        if (joins == null) {
            return;
        }
        for (Join<?, ?> j : joins) {
            buffer.append((CharSequence)((CriteriaExpression)j).asVariable(this)).append(" ");
            this.renderJoins(buffer, j.getJoins());
            this.renderFetches(buffer, j.getFetches());
        }
    }

    private void renderRoots(StringBuilder buffer, Collection<Root<?>> roots) {
        if (roots == null) {
            return;
        }
        int i = 0;
        for (Root<?> r : roots) {
            buffer.append((CharSequence)((ExpressionImpl)r).asVariable(this));
            if (++i != roots.size()) {
                buffer.append(", ");
            }
            this.renderJoins(buffer, r.getJoins());
            this.renderFetches(buffer, r.getFetches());
        }
    }

    private void renderFetches(StringBuilder buffer, Set<Fetch> fetches) {
        if (fetches == null) {
            return;
        }
        for (Fetch j : fetches) {
            buffer.append((CharSequence)((ExpressionImpl)j).asValue(this)).append(" ");
        }
    }

    public String toString() {
        try {
            return this.toCQL();
        }
        catch (Throwable t) {
            return super.toString();
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        return this.toString().equals(other.toString());
    }
}

