/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Inject;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.ProxyGenerationException;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.proxy.AbstractProxyFactory;
import org.apache.webbeans.proxy.OwbDecoratorProxy;
import org.apache.webbeans.util.ClassUtil;
import org.apache.xbean.asm5.ClassWriter;
import org.apache.xbean.asm5.MethodVisitor;
import org.apache.xbean.asm5.Type;

public class SubclassProxyFactory
extends AbstractProxyFactory {
    public SubclassProxyFactory(WebBeansContext webBeansContext) {
        super(webBeansContext);
    }

    @Override
    protected Class getMarkerInterface() {
        return OwbDecoratorProxy.class;
    }

    public <T> Class<T> createImplementedSubclass(ClassLoader classLoader, AnnotatedType<T> annotatedType) {
        Class classToProxy = annotatedType.getJavaClass();
        if (!Modifier.isAbstract(classToProxy.getModifiers())) {
            throw new WebBeansConfigurationException("Only abstract classes should get subclassed, not " + classToProxy);
        }
        Class<T> proxyClass = this.tryToLoadClass(classLoader, classToProxy);
        if (proxyClass != null) {
            return proxyClass;
        }
        proxyClass = this.createSubClass(classLoader, annotatedType);
        return proxyClass;
    }

    private <T> Class<T> tryToLoadClass(ClassLoader classLoader, Class<T> classToProxy) {
        String proxyClassName = this.getSubClassName(classToProxy);
        try {
            return Class.forName(proxyClassName, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private <T> String getSubClassName(Class<T> classToProxy) {
        return this.fixPreservedPackages(classToProxy.getName() + "$$OwbSubClass");
    }

    public synchronized <T> Class<T> createSubClass(ClassLoader classLoader, AnnotatedType<T> annotatedType) throws ProxyGenerationException {
        Class classToProxy = annotatedType.getJavaClass();
        Class<T> clazz = this.tryToLoadClass(classLoader, classToProxy);
        if (clazz != null) {
            return clazz;
        }
        String proxyClassName = this.getSubClassName(classToProxy);
        List<Method> methods = ClassUtil.getNonPrivateMethods(classToProxy, true);
        Method[] businessMethods = methods.toArray(new Method[methods.size()]);
        Constructor cons = null;
        for (AnnotatedConstructor c : annotatedType.getConstructors()) {
            if (!c.isAnnotationPresent(Inject.class)) continue;
            cons = c.getJavaMember();
            break;
        }
        clazz = this.createProxyClass(classLoader, proxyClassName, classToProxy, businessMethods, new Method[0], cons);
        return clazz;
    }

    @Override
    protected void createConstructor(ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, String classFileName, Constructor<?> constructor) throws ProxyGenerationException {
        try {
            Constructor<Object> superDefaultCt;
            String parentClassFileName;
            String[] exceptions = null;
            if (classToProxy.isInterface()) {
                parentClassFileName = Type.getInternalName(Object.class);
                superDefaultCt = Object.class.getConstructor(null);
            } else {
                parentClassFileName = classFileName;
                if (constructor == null) {
                    superDefaultCt = classToProxy.getConstructor(null);
                } else {
                    superDefaultCt = constructor;
                    Class<?>[] exceptionTypes = constructor.getExceptionTypes();
                    exceptions = exceptionTypes.length == 0 ? null : new String[exceptionTypes.length];
                    for (int i = 0; i < exceptionTypes.length; ++i) {
                        exceptions[i] = Type.getDescriptor(exceptionTypes[i]);
                    }
                }
            }
            String descriptor = Type.getConstructorDescriptor(superDefaultCt);
            MethodVisitor mv = cw.visitMethod(1, "<init>", descriptor, null, exceptions);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            if (constructor != null) {
                for (int i = 1; i <= constructor.getParameterTypes().length; ++i) {
                    mv.visitVarInsn(25, i);
                }
            }
            mv.visitMethodInsn(183, parentClassFileName, "<init>", descriptor, false);
            mv.visitInsn(177);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
        catch (NoSuchMethodException e) {
            throw new ProxyGenerationException(e);
        }
    }

    @Override
    protected void createInstanceVariables(ClassWriter cw, Class<?> classToProxy, String classFileName) {
    }

    @Override
    protected void delegateInterceptedMethods(ClassLoader classLoader, ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, Method[] interceptedMethods) throws ProxyGenerationException {
    }

    @Override
    protected void createSerialisation(ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, String classFileName) {
    }

    @Override
    protected void delegateNonInterceptedMethods(ClassLoader classLoader, ClassWriter cw, String proxyClassFileName, Class<?> classToProxy, Method[] noninterceptedMethods) throws ProxyGenerationException {
        for (Method delegatedMethod : noninterceptedMethods) {
            if (this.unproxyableMethod(delegatedMethod)) continue;
            String methodDescriptor = Type.getMethodDescriptor((Method)delegatedMethod);
            Class<?>[] exceptionTypes = delegatedMethod.getExceptionTypes();
            String[] exceptionTypeNames = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                exceptionTypeNames[i] = Type.getType(exceptionTypes[i]).getInternalName();
            }
            int targetModifiers = delegatedMethod.getModifiers() & 0x85;
            MethodVisitor mv = cw.visitMethod(targetModifiers, delegatedMethod.getName(), methodDescriptor, null, exceptionTypeNames);
            mv.visitCode();
            boolean abstractMethod = Modifier.isAbstract(delegatedMethod.getModifiers());
            int offset = 1;
            for (Class<?> aClass : delegatedMethod.getParameterTypes()) {
                Type type = Type.getType(aClass);
                mv.visitVarInsn(type.getOpcode(21), offset);
                offset += type.getSize();
            }
            Type declaringClass = Type.getType(delegatedMethod.getDeclaringClass());
            if (!abstractMethod) {
                mv.visitMethodInsn(183, declaringClass.getInternalName(), delegatedMethod.getName(), methodDescriptor, false);
            }
            this.generateReturn(mv, delegatedMethod);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }
}

