/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.examples;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;

public class AdvancedReader {
    public static void main(Configuration conf, String[] args) throws IOException {
        Reader reader = OrcFile.createReader((Path)new Path("advanced-example.orc"), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
        System.out.println("File schema: " + reader.getSchema());
        System.out.println("Row count: " + reader.getNumberOfRows());
        TypeDescription readSchema = TypeDescription.fromString((String)"struct<first:int,second:int,third:map<string,int>>");
        VectorizedRowBatch batch = readSchema.createRowBatch();
        RecordReader rowIterator = reader.rows(reader.options().schema(readSchema));
        LongColumnVector x = (LongColumnVector)batch.cols[0];
        LongColumnVector y = (LongColumnVector)batch.cols[1];
        MapColumnVector z = (MapColumnVector)batch.cols[2];
        while (rowIterator.nextBatch(batch)) {
            for (int row = 0; row < batch.size; ++row) {
                int xRow = x.isRepeating ? 0 : row;
                int yRow = y.isRepeating ? 0 : row;
                int zRow = z.isRepeating ? 0 : row;
                System.out.println("x: " + (x.noNulls || !x.isNull[xRow] ? Long.valueOf(x.vector[xRow]) : null));
                System.out.println("y: " + (y.noNulls || !y.isNull[yRow] ? Long.valueOf(y.vector[yRow]) : null));
                System.out.print("z: [");
                long index = z.offsets[zRow];
                for (long i = 0L; i < z.lengths[zRow]; ++i) {
                    BytesColumnVector keys = (BytesColumnVector)z.keys;
                    LongColumnVector values = (LongColumnVector)z.values;
                    String key = keys.toString((int)(index + i));
                    long value = values.vector[(int)(index + i)];
                    System.out.print(key + ":" + value);
                    System.out.print(" ");
                }
                System.out.println("]");
            }
        }
        rowIterator.close();
    }

    public static void main(String[] args) throws IOException {
        AdvancedReader.main(new Configuration(), args);
    }
}

