/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.examples;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;

public class AdvancedWriter {
    public static void main(Configuration conf, String[] args) throws IOException {
        Path testFilePath = new Path("advanced-example.orc");
        TypeDescription schema = TypeDescription.fromString((String)"struct<first:int,second:int,third:map<string,int>>");
        Writer writer = OrcFile.createWriter((Path)testFilePath, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).setSchema(schema));
        VectorizedRowBatch batch = schema.createRowBatch();
        LongColumnVector first = (LongColumnVector)batch.cols[0];
        LongColumnVector second = (LongColumnVector)batch.cols[1];
        MapColumnVector map = (MapColumnVector)batch.cols[2];
        BytesColumnVector mapKey = (BytesColumnVector)map.keys;
        LongColumnVector mapValue = (LongColumnVector)map.values;
        int MAP_SIZE = 5;
        int BATCH_SIZE = batch.getMaxSize();
        mapKey.ensureSize(BATCH_SIZE * 5, false);
        mapValue.ensureSize(BATCH_SIZE * 5, false);
        for (int r = 0; r < 1500; ++r) {
            int row;
            ++batch.size;
            first.vector[row] = r;
            second.vector[row] = r * 3;
            map.offsets[row] = map.childCount;
            map.lengths[row] = 5L;
            map.childCount += 5;
            int mapElem = (int)map.offsets[row];
            while ((long)mapElem < map.offsets[row] + 5L) {
                String key = "row " + r + "." + ((long)mapElem - map.offsets[row]);
                mapKey.setVal(mapElem, key.getBytes(StandardCharsets.UTF_8));
                mapValue.vector[mapElem] = mapElem;
                ++mapElem;
            }
            if (row != BATCH_SIZE - 1) continue;
            writer.addRowBatch(batch);
            batch.reset();
        }
        if (batch.size != 0) {
            writer.addRowBatch(batch);
            batch.reset();
        }
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        AdvancedWriter.main(new Configuration(), args);
    }
}

