/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.examples;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;

public class CompressionWriter {
    public static void main(Configuration conf, String[] args) throws IOException {
        TypeDescription schema = TypeDescription.fromString((String)"struct<x:int,y:string>");
        OrcFile.WriterOptions options = OrcFile.writerOptions((Configuration)conf).setSchema(schema).compress(CompressionKind.SNAPPY);
        Writer snappyWriter = OrcFile.createWriter((Path)new Path("compressed.orc"), (OrcFile.WriterOptions)options);
        VectorizedRowBatch batch = schema.createRowBatch();
        LongColumnVector x = (LongColumnVector)batch.cols[0];
        BytesColumnVector y = (BytesColumnVector)batch.cols[1];
        for (int r = 0; r < 10000; ++r) {
            int row;
            ++batch.size;
            x.vector[row] = r;
            byte[] buffer = ("byte-" + r).getBytes();
            y.setRef(row, buffer, 0, buffer.length);
            if (batch.size != batch.getMaxSize()) continue;
            snappyWriter.addRowBatch(batch);
            batch.reset();
        }
        if (batch.size != 0) {
            snappyWriter.addRowBatch(batch);
        }
        snappyWriter.close();
    }

    public static void main(String[] args) throws IOException {
        CompressionWriter.main(new Configuration(), args);
    }
}

