/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.examples;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.EncryptionAlgorithm;
import org.apache.orc.InMemoryKeystore;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.impl.KeyProvider;

public class InMemoryEncryptionWriter {
    public static void main(Configuration conf, String[] args) throws IOException {
        TypeDescription schema = TypeDescription.fromString((String)"struct<x:int,y:string>");
        byte[] kmsKey = "secret123".getBytes(StandardCharsets.UTF_8);
        InMemoryKeystore provider = new InMemoryKeystore().addKey("pii", EncryptionAlgorithm.AES_CTR_128, kmsKey);
        String encryption = "pii:x,y";
        OrcFile.WriterOptions writerOptions = OrcFile.writerOptions((Configuration)conf).setSchema(schema).setKeyProvider((KeyProvider)provider).encrypt(encryption);
        Writer writer = OrcFile.createWriter((Path)new Path("encrypted.orc"), (OrcFile.WriterOptions)writerOptions);
        VectorizedRowBatch batch = schema.createRowBatch();
        LongColumnVector x = (LongColumnVector)batch.cols[0];
        BytesColumnVector y = (BytesColumnVector)batch.cols[1];
        for (int r = 0; r < 10000; ++r) {
            int row;
            ++batch.size;
            x.vector[row] = r;
            byte[] buffer = ("byte-" + r).getBytes();
            y.setRef(row, buffer, 0, buffer.length);
            if (batch.size != batch.getMaxSize()) continue;
            writer.addRowBatch(batch);
            batch.reset();
        }
        if (batch.size != 0) {
            writer.addRowBatch(batch);
        }
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        InMemoryEncryptionWriter.main(new Configuration(), args);
    }
}

