/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.schema;

import java.util.concurrent.Callable;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestTypeBuildersWithLogicalTypes {
    @Test
    public void testGroupTypeConstruction() {
        PrimitiveType f1 = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("f1");
        PrimitiveType f2 = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("f2");
        PrimitiveType f3 = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("f3");
        String name = "group";
        for (Type.Repetition repetition : Type.Repetition.values()) {
            GroupType expected = new GroupType(repetition, name, new Type[]{f1, new GroupType(repetition, "g1", new Type[]{f2, f3})});
            GroupType built = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).addField((Type)f1)).group(repetition).addFields(new Type[]{f2, f3})).named("g1")).named(name);
            Assert.assertEquals((Object)expected, (Object)built);
            switch (repetition) {
                case REQUIRED: {
                    built = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.requiredGroup().addField((Type)f1)).requiredGroup().addFields(new Type[]{f2, f3})).named("g1")).named(name);
                    break;
                }
                case OPTIONAL: {
                    built = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.optionalGroup().addField((Type)f1)).optionalGroup().addFields(new Type[]{f2, f3})).named("g1")).named(name);
                    break;
                }
                case REPEATED: {
                    built = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.repeatedGroup().addField((Type)f1)).repeatedGroup().addFields(new Type[]{f2, f3})).named("g1")).named(name);
                }
            }
            Assert.assertEquals((Object)expected, (Object)built);
        }
    }

    @Test
    public void testDecimalAnnotation() {
        MessageType expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, 0, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)9), null)});
        MessageType builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)9))).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, 0, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)18), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)18))).precision(18)).scale(2)).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, 0, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)9), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)9))).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
        expected = new MessageType("DecimalMessage", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 4, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)9), null)});
        builderType = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)9))).named("aDecimal")).named("DecimalMessage");
        Assert.assertEquals((Object)expected, (Object)builderType);
    }

    @Test
    public void testDecimalAnnotationPrecisionScaleBound() {
        TestTypeBuildersWithLogicalTypes.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, () -> ((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)4, (int)3))).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuildersWithLogicalTypes.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, () -> ((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)4, (int)3))).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuildersWithLogicalTypes.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, () -> ((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)4, (int)3))).named("aDecimal")).named("DecimalMessage"));
        TestTypeBuildersWithLogicalTypes.assertThrows("Should reject scale greater than precision", IllegalArgumentException.class, () -> ((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(7)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)4, (int)3))).named("aDecimal")).named("DecimalMessage"));
    }

    @Test
    public void testDecimalAnnotationLengthCheck() {
        TestTypeBuildersWithLogicalTypes.assertThrows("should reject precision 10 with length 4", IllegalStateException.class, () -> ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)10))).named("aDecimal"));
        TestTypeBuildersWithLogicalTypes.assertThrows("should reject precision 10 with length 4", IllegalStateException.class, () -> ((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)10))).named("aDecimal"));
        TestTypeBuildersWithLogicalTypes.assertThrows("should reject precision 19 with length 8", IllegalStateException.class, () -> ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(8)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)4, (int)19))).named("aDecimal"));
        TestTypeBuildersWithLogicalTypes.assertThrows("should reject precision 19 with length 8", IllegalStateException.class, () -> ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).length(8)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)4, (int)19))).named("aDecimal"));
    }

    @Test
    public void testDECIMALAnnotationRejectsUnsupportedTypes() {
        PrimitiveType.PrimitiveTypeName[] unsupported;
        for (PrimitiveType.PrimitiveTypeName type : unsupported = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT}) {
            TestTypeBuildersWithLogicalTypes.assertThrows("Should reject non-binary type: " + type, IllegalStateException.class, () -> ((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)9))).named("d"));
        }
    }

    @Test
    public void testBinaryAnnotations() {
        LogicalTypeAnnotation[] types;
        for (LogicalTypeAnnotation logicalType : types = new LogicalTypeAnnotation[]{LogicalTypeAnnotation.stringType(), LogicalTypeAnnotation.jsonType(), LogicalTypeAnnotation.bsonType()}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "col", logicalType);
            PrimitiveType string = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)string);
        }
    }

    @Test
    public void testBinaryAnnotationsRejectsNonBinary() {
        LogicalTypeAnnotation[] types;
        for (LogicalTypeAnnotation logicalType : types = new LogicalTypeAnnotation[]{LogicalTypeAnnotation.stringType(), LogicalTypeAnnotation.jsonType(), LogicalTypeAnnotation.bsonType()}) {
            PrimitiveType.PrimitiveTypeName[] nonBinary;
            for (PrimitiveType.PrimitiveTypeName type : nonBinary = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT}) {
                TestTypeBuildersWithLogicalTypes.assertThrows("Should reject non-binary type: " + type, IllegalStateException.class, () -> ((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col"));
            }
            TestTypeBuildersWithLogicalTypes.assertThrows("Should reject non-binary type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, () -> ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1)).as(logicalType)).named("col"));
        }
    }

    @Test
    public void testInt32Annotations() {
        LogicalTypeAnnotation[] types;
        for (LogicalTypeAnnotation logicalType : types = new LogicalTypeAnnotation[]{LogicalTypeAnnotation.dateType(), LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), LogicalTypeAnnotation.intType((int)8, (boolean)false), LogicalTypeAnnotation.intType((int)16, (boolean)false), LogicalTypeAnnotation.intType((int)32, (boolean)false), LogicalTypeAnnotation.intType((int)8, (boolean)true), LogicalTypeAnnotation.intType((int)16, (boolean)true), LogicalTypeAnnotation.intType((int)32, (boolean)true)}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "col", logicalType);
            PrimitiveType date = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)date);
        }
    }

    @Test
    public void testInt32AnnotationsRejectNonInt32() {
        LogicalTypeAnnotation[] types;
        for (LogicalTypeAnnotation logicalType : types = new LogicalTypeAnnotation[]{LogicalTypeAnnotation.dateType(), LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), LogicalTypeAnnotation.intType((int)8, (boolean)false), LogicalTypeAnnotation.intType((int)16, (boolean)false), LogicalTypeAnnotation.intType((int)32, (boolean)false), LogicalTypeAnnotation.intType((int)8, (boolean)true), LogicalTypeAnnotation.intType((int)16, (boolean)true), LogicalTypeAnnotation.intType((int)32, (boolean)true)}) {
            PrimitiveType.PrimitiveTypeName[] nonInt32;
            for (PrimitiveType.PrimitiveTypeName type : nonInt32 = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
                TestTypeBuildersWithLogicalTypes.assertThrows("Should reject non-int32 type: " + type, IllegalStateException.class, () -> ((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col"));
            }
            TestTypeBuildersWithLogicalTypes.assertThrows("Should reject non-int32 type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, () -> ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1)).as(logicalType)).named("col"));
        }
    }

    @Test
    public void testInt64Annotations() {
        LogicalTypeAnnotation[] types;
        for (LogicalTypeAnnotation logicalType : types = new LogicalTypeAnnotation[]{LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS), LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS), LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS), LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS), LogicalTypeAnnotation.intType((int)64, (boolean)true), LogicalTypeAnnotation.intType((int)64, (boolean)false)}) {
            PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "col", logicalType);
            PrimitiveType date = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(logicalType)).named("col");
            Assert.assertEquals((Object)expected, (Object)date);
        }
    }

    @Test
    public void testInt64AnnotationsRejectNonInt64() {
        LogicalTypeAnnotation[] types;
        for (LogicalTypeAnnotation logicalType : types = new LogicalTypeAnnotation[]{LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS), LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS), LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS), LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS), LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS), LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS), LogicalTypeAnnotation.intType((int)64, (boolean)true), LogicalTypeAnnotation.intType((int)64, (boolean)false)}) {
            PrimitiveType.PrimitiveTypeName[] nonInt64;
            for (PrimitiveType.PrimitiveTypeName type : nonInt64 = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
                TestTypeBuildersWithLogicalTypes.assertThrows("Should reject non-int64 type: " + type, IllegalStateException.class, () -> (Type)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(logicalType)).named("col"));
            }
            TestTypeBuildersWithLogicalTypes.assertThrows("Should reject non-int64 type: FIXED_LEN_BYTE_ARRAY", IllegalStateException.class, () -> (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(1)).as(logicalType)).named("col"));
        }
    }

    @Test
    public void testIntervalAnnotationRejectsNonFixed() {
        PrimitiveType.PrimitiveTypeName[] nonFixed;
        for (PrimitiveType.PrimitiveTypeName type : nonFixed = new PrimitiveType.PrimitiveTypeName[]{PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.INT96, PrimitiveType.PrimitiveTypeName.DOUBLE, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.BINARY}) {
            TestTypeBuildersWithLogicalTypes.assertThrows("Should reject non-fixed type: " + type, IllegalStateException.class, () -> ((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)type).as(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance())).named("interval"));
        }
    }

    @Test
    public void testIntervalAnnotationRejectsNonFixed12() {
        TestTypeBuildersWithLogicalTypes.assertThrows("Should reject fixed with length != 12: 11", IllegalStateException.class, () -> ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(11)).as(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance())).named("interval"));
    }

    @Test
    public void testTypeConstructionWithUnsupportedColumnOrder() {
        TestTypeBuildersWithLogicalTypes.assertThrows(null, IllegalArgumentException.class, () -> ((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).columnOrder(ColumnOrder.typeDefined())).named("int96_unsupported"));
        TestTypeBuildersWithLogicalTypes.assertThrows(null, IllegalArgumentException.class, () -> ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance())).columnOrder(ColumnOrder.typeDefined())).named("interval_unsupported"));
    }

    @Test
    public void testDecimalLogicalType() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4));
        PrimitiveType actual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).named("aDecimal");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDecimalLogicalTypeWithDeprecatedScale() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4));
        PrimitiveType actual = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).scale(3)).named("aDecimal");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testDecimalLogicalTypeWithDeprecatedPrecision() {
        PrimitiveType expected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "aDecimal", (LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4));
        PrimitiveType actual = (PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).precision(4)).named("aDecimal");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTimestampLogicalTypeWithUTCParameter() {
        PrimitiveType utcMillisExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "aTimestamp", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        PrimitiveType nonUtcMillisExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "aTimestamp", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        PrimitiveType utcMicrosExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "aTimestamp", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
        PrimitiveType nonUtcMicrosExpected = new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "aTimestamp", (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS));
        PrimitiveType utcMillisActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("aTimestamp");
        PrimitiveType nonUtcMillisActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("aTimestamp");
        PrimitiveType utcMicrosActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("aTimestamp");
        PrimitiveType nonUtcMicrosActual = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("aTimestamp");
        Assert.assertEquals((Object)utcMillisExpected, (Object)utcMillisActual);
        Assert.assertEquals((Object)nonUtcMillisExpected, (Object)nonUtcMillisActual);
        Assert.assertEquals((Object)utcMicrosExpected, (Object)utcMicrosActual);
        Assert.assertEquals((Object)nonUtcMicrosExpected, (Object)nonUtcMicrosActual);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecimalLogicalTypeWithDeprecatedScaleMismatch() {
        ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).scale(4)).named("aDecimal");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecimalLogicalTypeWithDeprecatedPrecisionMismatch() {
        ((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)3, (int)4))).precision(5)).named("aDecimal");
    }

    @Test
    public void testUUIDLogicalType() {
        Assert.assertEquals((Object)"required fixed_len_byte_array(16) uuid_field (UUID)", (Object)((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(16)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType())).named("uuid_field")).toString());
        TestTypeBuildersWithLogicalTypes.assertThrows("Should fail with invalid length", IllegalStateException.class, () -> ((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(10)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType())).named("uuid_field")).toString());
        TestTypeBuildersWithLogicalTypes.assertThrows("Should fail with invalid type", IllegalStateException.class, () -> ((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType())).named("uuid_field")).toString());
    }

    public static void assertThrows(String message, Class<? extends Exception> expected, Callable callable) {
        try {
            callable.call();
            Assert.fail((String)("No exception was thrown (" + message + "), expected: " + expected.getName()));
        }
        catch (Exception actual) {
            Assert.assertEquals((String)message, expected, actual.getClass());
        }
    }
}

