/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import org.apache.parquet.VersionParser;
import org.junit.Assert;
import org.junit.Test;
import org.semver.Version;

public class VersionTest {
    private void assertVersionValid(String v) {
        try {
            Version.parse((String)v);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(v + " is not a valid semver!", e);
        }
    }

    @Test
    public void testVersion() {
        this.assertVersionValid("1.12.2");
    }

    @Test
    public void testFullVersion() throws Exception {
        VersionParser.ParsedVersion version = VersionParser.parse((String)"parquet-mr version 1.12.2 (build 77e30c8093386ec52c3cfa6c34b7ef3321322c94)");
        this.assertVersionValid(version.version);
        Assert.assertEquals((Object)"1.12.2", (Object)version.version);
        Assert.assertEquals((Object)"parquet-mr", (Object)version.application);
    }

    @Test
    public void testVersionParser() throws Exception {
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.6.0", "abcd"), (Object)VersionParser.parse((String)"parquet-mr version 1.6.0 (build abcd)"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.6.22rc99-SNAPSHOT", "abcd"), (Object)VersionParser.parse((String)"parquet-mr version 1.6.22rc99-SNAPSHOT (build abcd)"));
        try {
            VersionParser.parse((String)"unparseable string");
            Assert.fail((String)"this should throw");
        }
        catch (VersionParser.VersionParseException versionParseException) {
            // empty catch block
        }
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", null, "abcd"), (Object)VersionParser.parse((String)"parquet-mr version (build abcd)"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", null, "abcd"), (Object)VersionParser.parse((String)"parquet-mr version  (build abcd)"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.6.0", null), (Object)VersionParser.parse((String)"parquet-mr version 1.6.0 (build )"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.6.0", null), (Object)VersionParser.parse((String)"parquet-mr version 1.6.0 (build)"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", null, null), (Object)VersionParser.parse((String)"parquet-mr version (build)"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", null, null), (Object)VersionParser.parse((String)"parquet-mr version (build )"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.6.0", null), (Object)VersionParser.parse((String)"parquet-mr version 1.6.0"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.8.0rc4", null), (Object)VersionParser.parse((String)"parquet-mr version 1.8.0rc4"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.8.0rc4-SNAPSHOT", null), (Object)VersionParser.parse((String)"parquet-mr version 1.8.0rc4-SNAPSHOT"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", null, null), (Object)VersionParser.parse((String)"parquet-mr version"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.6.0", null), (Object)VersionParser.parse((String)"parquet-mr     version    1.6.0"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.8.0rc4", null), (Object)VersionParser.parse((String)"parquet-mr     version    1.8.0rc4"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.8.0rc4-SNAPSHOT", null), (Object)VersionParser.parse((String)"parquet-mr      version    1.8.0rc4-SNAPSHOT  "));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", null, null), (Object)VersionParser.parse((String)"parquet-mr      version"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.6.0", null), (Object)VersionParser.parse((String)"parquet-mr version 1.6.0 (  build )"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", "1.6.0", null), (Object)VersionParser.parse((String)"parquet-mr     version 1.6.0 (    build)"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", null, null), (Object)VersionParser.parse((String)"parquet-mr     version (    build)"));
        Assert.assertEquals((Object)new VersionParser.ParsedVersion("parquet-mr", null, null), (Object)VersionParser.parse((String)"parquet-mr    version    (build    )"));
    }
}

