/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.bytes;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.SingleBufferInputStream;
import org.apache.parquet.bytes.TestByteBufferInputStreams;
import org.junit.Assert;
import org.junit.Test;

public class TestSingleBufferInputStream
extends TestByteBufferInputStreams {
    static final ByteBuffer DATA = ByteBuffer.wrap(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34});

    @Override
    protected ByteBufferInputStream newStream() {
        return new SingleBufferInputStream(DATA);
    }

    @Override
    protected void checkOriginalData() {
        Assert.assertEquals((String)"Position should not change", (long)0L, (long)DATA.position());
        Assert.assertEquals((String)"Limit should not change", (long)DATA.array().length, (long)DATA.limit());
    }

    @Test
    public void testSliceData() throws Exception {
        int i;
        ByteBufferInputStream stream = this.newStream();
        int length = stream.available();
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        while (stream.available() > 0) {
            int bytesToSlice = Math.min(stream.available(), 8);
            buffers.add(stream.slice(bytesToSlice));
        }
        Assert.assertEquals((String)"Position should be at end", (long)length, (long)stream.position());
        Assert.assertEquals((String)"Should produce 5 buffers", (long)5L, (long)buffers.size());
        ByteBuffer one = (ByteBuffer)buffers.get(0);
        Assert.assertSame((String)"Should use the same backing array", (Object)one.array(), (Object)DATA.array());
        Assert.assertEquals((long)8L, (long)one.remaining());
        Assert.assertEquals((long)0L, (long)one.position());
        Assert.assertEquals((long)8L, (long)one.limit());
        Assert.assertEquals((long)35L, (long)one.capacity());
        for (i = 0; i < 8; ++i) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)one.get());
        }
        ByteBuffer two = (ByteBuffer)buffers.get(1);
        Assert.assertSame((String)"Should use the same backing array", (Object)two.array(), (Object)DATA.array());
        Assert.assertEquals((long)8L, (long)two.remaining());
        Assert.assertEquals((long)8L, (long)two.position());
        Assert.assertEquals((long)16L, (long)two.limit());
        Assert.assertEquals((long)35L, (long)two.capacity());
        while (i < 16) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)two.get());
            ++i;
        }
        ByteBuffer three = (ByteBuffer)buffers.get(2);
        Assert.assertSame((String)"Should use the same backing array", (Object)three.array(), (Object)DATA.array());
        Assert.assertEquals((long)8L, (long)three.remaining());
        Assert.assertEquals((long)16L, (long)three.position());
        Assert.assertEquals((long)24L, (long)three.limit());
        Assert.assertEquals((long)35L, (long)three.capacity());
        while (i < 24) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)three.get());
            ++i;
        }
        ByteBuffer four = (ByteBuffer)buffers.get(3);
        Assert.assertSame((String)"Should use the same backing array", (Object)four.array(), (Object)DATA.array());
        Assert.assertEquals((long)8L, (long)four.remaining());
        Assert.assertEquals((long)24L, (long)four.position());
        Assert.assertEquals((long)32L, (long)four.limit());
        Assert.assertEquals((long)35L, (long)four.capacity());
        while (i < 32) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)four.get());
            ++i;
        }
        ByteBuffer five = (ByteBuffer)buffers.get(4);
        Assert.assertSame((String)"Should use the same backing array", (Object)five.array(), (Object)DATA.array());
        Assert.assertEquals((long)3L, (long)five.remaining());
        Assert.assertEquals((long)32L, (long)five.position());
        Assert.assertEquals((long)35L, (long)five.limit());
        Assert.assertEquals((long)35L, (long)five.capacity());
        while (i < 35) {
            Assert.assertEquals((String)"Should produce correct values", (long)i, (long)five.get());
            ++i;
        }
    }

    @Test
    public void testWholeSliceBuffersData() throws Exception {
        ByteBufferInputStream stream = this.newStream();
        List buffers = stream.sliceBuffers((long)stream.available());
        Assert.assertEquals((String)"Should return duplicates of all non-empty buffers", Collections.singletonList(DATA), (Object)buffers);
    }
}

