/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.io.ByteArrayInputStream;

class MockInputStream
extends ByteArrayInputStream {
    static final byte[] TEST_ARRAY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private int[] lengths;
    private int current = 0;

    MockInputStream(int ... actualReadLengths) {
        super(TEST_ARRAY);
        this.lengths = actualReadLengths;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (this.current < this.lengths.length) {
            if (len <= this.lengths[this.current]) {
                int bytesRead = super.read(b, off, len);
                int n = this.current;
                this.lengths[n] = this.lengths[n] - bytesRead;
                return bytesRead;
            }
            int bytesRead = super.read(b, off, this.lengths[this.current]);
            ++this.current;
            return bytesRead;
        }
        return super.read(b, off, len);
    }

    public long getPos() {
        return this.pos;
    }
}

