/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.parquet.column.values.bitpacking.BitPacking;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.IntPacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.column.values.bitpacking.TestBitPacking;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLemireBitPacking {
    private static final Logger LOG = LoggerFactory.getLogger(TestLemireBitPacking.class);

    @Test
    public void testPackUnPack() {
        for (Packer packer : Packer.values()) {
            LOG.debug("");
            LOG.debug("testPackUnPack");
            for (int i = 1; i < 32; ++i) {
                LOG.debug("Width: {}", (Object)i);
                int[] values = this.generateValues(i);
                int[] unpacked = new int[32];
                this.packUnpack(packer.newIntPacker(i), values, unpacked);
                LOG.debug("int based Output " + packer.name() + ": " + TestBitPacking.toString(unpacked));
                Assert.assertArrayEquals((String)(packer.name() + " width " + i), (int[])values, (int[])unpacked);
                this.packUnpack(packer.newBytePacker(i), values, unpacked);
                LOG.debug("byte based Output " + packer.name() + ": " + TestBitPacking.toString(unpacked));
                Assert.assertArrayEquals((String)(packer.name() + " width " + i), (int[])values, (int[])unpacked);
            }
        }
    }

    private void packUnpack(IntPacker packer, int[] values, int[] unpacked) {
        int[] packed = new int[packer.getBitWidth()];
        packer.pack32Values(values, 0, packed, 0);
        packer.unpack32Values(packed, 0, unpacked, 0);
    }

    private void packUnpack(BytePacker packer, int[] values, int[] unpacked) {
        byte[] packed = new byte[packer.getBitWidth() * 4];
        packer.pack32Values(values, 0, packed, 0);
        packer.unpack32Values(ByteBuffer.wrap(packed), 0, unpacked, 0);
    }

    private int[] generateValues(int bitWidth) {
        int[] values = new int[32];
        for (int j = 0; j < values.length; ++j) {
            values[j] = (int)(Math.random() * 100000.0) % (int)Math.pow(2.0, bitWidth);
        }
        LOG.debug("Input:  {}", (Object)TestBitPacking.toString(values));
        return values;
    }

    @Test
    public void testPackUnPackAgainstHandWritten() throws IOException {
        LOG.debug("");
        LOG.debug("testPackUnPackAgainstHandWritten");
        for (int i = 1; i < 8; ++i) {
            LOG.debug("Width: {}", (Object)i);
            int[] packed = new int[i];
            int[] unpacked = new int[32];
            int[] values = this.generateValues(i);
            IntPacker packer = Packer.BIG_ENDIAN.newIntPacker(i);
            packer.pack32Values(values, 0, packed, 0);
            ByteArrayOutputStream lemireOut = new ByteArrayOutputStream();
            for (int v : packed) {
                lemireOut.write(v >>> 24 & 0xFF);
                lemireOut.write(v >>> 16 & 0xFF);
                lemireOut.write(v >>> 8 & 0xFF);
                lemireOut.write(v >>> 0 & 0xFF);
            }
            byte[] packedByLemireAsBytes = lemireOut.toByteArray();
            LOG.debug("Lemire: {}", (Object)TestBitPacking.toString(packedByLemireAsBytes));
            ByteArrayOutputStream manualOut = new ByteArrayOutputStream();
            BitPacking.BitPackingWriter writer = BitPacking.getBitPackingWriter((int)i, (OutputStream)manualOut);
            for (int j = 0; j < values.length; ++j) {
                writer.write(values[j]);
            }
            byte[] packedManualAsBytes = manualOut.toByteArray();
            LOG.debug("Manual: {}", (Object)TestBitPacking.toString(packedManualAsBytes));
            BitPacking.BitPackingReader reader = BitPacking.createBitPackingReader((int)i, (InputStream)new ByteArrayInputStream(packedByLemireAsBytes), (long)32L);
            for (int j = 0; j < unpacked.length; ++j) {
                unpacked[j] = reader.read();
            }
            LOG.debug("Output: {}", (Object)TestBitPacking.toString(unpacked));
            Assert.assertArrayEquals((String)("width " + i), (int[])values, (int[])unpacked);
        }
    }
}

