/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class DirectWriterTest {
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();

    protected Path writeDirect(String type, DirectWriter writer) throws IOException {
        return this.writeDirect(MessageTypeParser.parseMessageType((String)type), writer);
    }

    protected Path writeDirect(String type, DirectWriter writer, Map<String, String> metadata) throws IOException {
        return this.writeDirect(MessageTypeParser.parseMessageType((String)type), writer, metadata);
    }

    protected Path writeDirect(MessageType type, DirectWriter writer) throws IOException {
        return this.writeDirect(type, writer, new HashMap<String, String>());
    }

    protected Path writeDirect(MessageType type, DirectWriter writer, Map<String, String> metadata) throws IOException {
        File temp = this.tempDir.newFile(UUID.randomUUID().toString());
        temp.deleteOnExit();
        temp.delete();
        Path path = new Path(temp.getPath());
        ParquetWriter parquetWriter = new ParquetWriter(path, (WriteSupport)new DirectWriteSupport(type, writer, metadata));
        parquetWriter.write(null);
        parquetWriter.close();
        return path;
    }

    protected static class DirectWriteSupport
    extends WriteSupport<Void> {
        private RecordConsumer recordConsumer;
        private final MessageType type;
        private final DirectWriter writer;
        private final Map<String, String> metadata;

        protected DirectWriteSupport(MessageType type, DirectWriter writer, Map<String, String> metadata) {
            this.type = type;
            this.writer = writer;
            this.metadata = metadata;
        }

        public WriteSupport.WriteContext init(Configuration configuration) {
            return new WriteSupport.WriteContext(this.type, this.metadata);
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        public void write(Void record) {
            this.writer.write(this.recordConsumer);
        }
    }

    protected static interface DirectWriter {
        public void write(RecordConsumer var1);
    }
}

