/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.crypto.ColumnEncryptionProperties;
import org.apache.parquet.crypto.EncryptionPropertiesFactory;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public class SampleEncryptionPropertiesFactory
implements EncryptionPropertiesFactory {
    public static final byte[] FOOTER_KEY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    public static final ColumnPath COL1 = ColumnPath.fromDotString((String)"col_1");
    public static final byte[] COL1_KEY = new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    public static final ColumnEncryptionProperties COL1_ENCR_PROPERTIES = ColumnEncryptionProperties.builder((String)COL1.toDotString()).withKey(COL1_KEY).build();
    public static final ColumnPath COL2 = ColumnPath.fromDotString((String)"col_2");
    public static final byte[] COL2_KEY = new byte[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    public static final ColumnEncryptionProperties COL2_ENCR_PROPERTIES = ColumnEncryptionProperties.builder((String)COL2.toDotString()).withKey(COL2_KEY).build();

    public FileEncryptionProperties getFileEncryptionProperties(Configuration fileHadoopConfig, Path tempFilePath, WriteSupport.WriteContext fileWriteContext) throws ParquetCryptoRuntimeException {
        HashMap<ColumnPath, ColumnEncryptionProperties> columnEncPropertiesMap = new HashMap<ColumnPath, ColumnEncryptionProperties>();
        columnEncPropertiesMap.put(COL1, COL1_ENCR_PROPERTIES);
        columnEncPropertiesMap.put(COL2, COL2_ENCR_PROPERTIES);
        FileEncryptionProperties.Builder fileEncBuilder = FileEncryptionProperties.builder((byte[])FOOTER_KEY);
        return fileEncBuilder.withAlgorithm(ParquetCipher.AES_GCM_V1).withEncryptedColumns(columnEncPropertiesMap).build();
    }
}

