/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestFiltersWithMissingColumns {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    public Path path;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void createDataFile() throws Exception {
        File file = this.temp.newFile("test.parquet");
        this.path = new Path(file.toString());
        MessageType type = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).named("id")).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("data")).named("test");
        SimpleGroupFactory factory = new SimpleGroupFactory(type);
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)this.path).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withType(type).build();){
            for (long i = 0L; i < 1000L; ++i) {
                Group g = factory.newGroup();
                g.add(0, i);
                g.add(1, "data-" + i);
                writer.write((Object)g);
            }
        }
    }

    @Test
    public void testNormalFilter() throws Exception {
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L))));
    }

    @Test
    public void testSimpleMissingColumnFilter() throws Exception {
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"missing"), (Comparable)Long.valueOf(500L))));
    }

    @Test
    public void testAndMissingColumnFilter() throws Exception {
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing"), null))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing"), (Comparable)Binary.fromString((String)"any")))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing"), null), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing"), (Comparable)Binary.fromString((String)"any")), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing"), (Comparable)Binary.fromString((String)"any")))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing"), null))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing"), (Comparable)Binary.fromString((String)"any")), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing"), null), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)0L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
    }

    @Test
    public void testOrMissingColumnFilter() throws Exception {
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing"), (Comparable)Binary.fromString((String)"any")))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing"), null))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing"), (Comparable)Binary.fromString((String)"any")), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing"), null), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)500L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.doubleColumn((String)"missing"), (Comparable)Double.valueOf(33.33)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)1000L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing"), null))));
        Assert.assertEquals((long)1000L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing"), (Comparable)Binary.fromString((String)"any")))));
        Assert.assertEquals((long)1000L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing"), null), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
        Assert.assertEquals((long)1000L, (long)TestFiltersWithMissingColumns.countFilteredRecords(this.path, FilterApi.or((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing"), (Comparable)Binary.fromString((String)"any")), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(500L)))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countFilteredRecords(Path path, FilterPredicate pred) throws IOException {
        long count = 0L;
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)path).withFilter(FilterCompat.get((FilterPredicate)pred)).build();){
            while (reader.read() != null) {
                ++count;
            }
        }
        return count;
    }
}

