/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.parquet.hadoop.codec.SnappyCodec;
import org.apache.parquet.hadoop.codec.SnappyCompressor;
import org.apache.parquet.hadoop.codec.SnappyDecompressor;
import org.junit.Assert;
import org.junit.Test;
import org.xerial.snappy.Snappy;

public class TestSnappyCodec {
    @Test
    public void TestSnappy() throws IOException {
        SnappyCompressor compressor = new SnappyCompressor();
        SnappyDecompressor decompressor = new SnappyDecompressor();
        this.TestSnappy(compressor, decompressor, "");
        this.TestSnappy(compressor, decompressor, "FooBar");
        this.TestSnappy(compressor, decompressor, "FooBar1", "FooBar2");
        this.TestSnappy(compressor, decompressor, "FooBar");
        this.TestSnappy(compressor, decompressor, "a", "blahblahblah", "abcdef");
        this.TestSnappy(compressor, decompressor, "");
        this.TestSnappy(compressor, decompressor, "FooBar");
    }

    @Test
    public void TestSnappyStream() throws IOException {
        int numBytes;
        int len;
        SnappyCodec codec = new SnappyCodec();
        codec.setConf(new Configuration());
        int blockSize = 1024;
        int inputSize = blockSize * 1024;
        byte[] input = new byte[inputSize];
        for (int i = 0; i < inputSize; ++i) {
            input[i] = (byte)i;
        }
        ByteArrayOutputStream compressedStream = new ByteArrayOutputStream();
        CompressionOutputStream compressor = codec.createOutputStream((OutputStream)compressedStream);
        for (int bytesCompressed = 0; bytesCompressed < inputSize; bytesCompressed += len) {
            len = Math.min(inputSize - bytesCompressed, blockSize);
            compressor.write(input, bytesCompressed, len);
        }
        compressor.finish();
        byte[] rawCompressed = Snappy.compress((byte[])input);
        byte[] codecCompressed = compressedStream.toByteArray();
        Assert.assertArrayEquals((byte[])rawCompressed, (byte[])codecCompressed);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(codecCompressed);
        CompressionInputStream decompressor = codec.createInputStream((InputStream)inputStream);
        byte[] codecDecompressed = new byte[inputSize];
        int bytesDecompressed = 0;
        while ((numBytes = decompressor.read(codecDecompressed, bytesDecompressed, blockSize)) != 0 && (bytesDecompressed += numBytes) != inputSize) {
        }
        byte[] rawDecompressed = Snappy.uncompress((byte[])rawCompressed);
        Assert.assertArrayEquals((byte[])input, (byte[])rawDecompressed);
        Assert.assertArrayEquals((byte[])input, (byte[])codecDecompressed);
    }

    private void TestSnappy(SnappyCompressor compressor, SnappyDecompressor decompressor, String ... strings) throws IOException {
        compressor.reset();
        decompressor.reset();
        int uncompressedSize = 0;
        for (String s : strings) {
            uncompressedSize += s.length();
        }
        byte[] uncompressedData = new byte[uncompressedSize];
        int len = 0;
        for (String s : strings) {
            byte[] tmp = s.getBytes();
            System.arraycopy(tmp, 0, uncompressedData, len, s.length());
            len += s.length();
        }
        assert (compressor.needsInput());
        compressor.setInput(uncompressedData, 0, len);
        assert (compressor.needsInput());
        compressor.finish();
        assert (!compressor.needsInput());
        assert (!compressor.finished() || uncompressedSize == 0);
        byte[] compressedData = new byte[1000];
        int compressedSize = compressor.compress(compressedData, 0, 1000);
        assert (compressor.finished());
        assert (!decompressor.finished());
        assert (decompressor.needsInput());
        decompressor.setInput(compressedData, 0, compressedSize);
        assert (!decompressor.finished());
        byte[] decompressedData = new byte[uncompressedSize];
        int decompressedSize = decompressor.decompress(decompressedData, 0, uncompressedSize);
        assert (decompressor.finished());
        Assert.assertEquals((long)uncompressedSize, (long)decompressedSize);
        Assert.assertArrayEquals((byte[])uncompressedData, (byte[])decompressedData);
    }
}

