/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;

public class CompressionConveterTest {
    private Configuration conf = new Configuration();
    private Map<String, String> extraMeta = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
    private CompressionConverter compressionConverter = new CompressionConverter();
    private Random rnd = new Random(5L);

    @Test
    public void testTransCompression() throws Exception {
        String[] codecs = new String[]{"UNCOMPRESSED", "SNAPPY", "GZIP", "ZSTD"};
        for (int i = 0; i < codecs.length; ++i) {
            for (int j = 0; j < codecs.length; ++j) {
                this.testInternal(codecs[i], codecs[j], ParquetProperties.WriterVersion.PARQUET_1_0, 0x100000);
                this.testInternal(codecs[i], codecs[j], ParquetProperties.WriterVersion.PARQUET_2_0, 0x100000);
                this.testInternal(codecs[i], codecs[j], ParquetProperties.WriterVersion.PARQUET_1_0, 64);
                this.testInternal(codecs[i], codecs[j], ParquetProperties.WriterVersion.PARQUET_1_0, 0x6400000);
            }
        }
    }

    private void testInternal(String srcCodec, String destCodec, ParquetProperties.WriterVersion writerVersion, int pageSize) throws Exception {
        int numRecord = 1000;
        TestDocs testDocs = new TestDocs(numRecord);
        String inputFile = this.createParquetFile(this.conf, this.extraMeta, numRecord, "input", srcCodec, writerVersion, pageSize, testDocs);
        String outputFile = this.createTempFile("output_trans");
        this.convertCompression(this.conf, inputFile, outputFile, destCodec);
        this.validateColumns(outputFile, numRecord, testDocs);
        this.validMeta(inputFile, outputFile);
        this.validColumnIndex(inputFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertCompression(Configuration conf, String inputFile, String outputFile, String codec) throws IOException {
        Path inPath = new Path(inputFile);
        Path outPath = new Path(outputFile);
        CompressionCodecName codecName = CompressionCodecName.valueOf((String)codec);
        ParquetMetadata metaData = ParquetFileReader.readFooter((Configuration)conf, (Path)inPath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        MessageType schema = metaData.getFileMetaData().getSchema();
        ParquetFileWriter writer = new ParquetFileWriter(conf, schema, outPath, ParquetFileWriter.Mode.CREATE);
        writer.start();
        try (CompressionConverter.TransParquetFileReader reader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)inPath, (Configuration)conf), HadoopReadOptions.builder((Configuration)conf).build());){
            this.compressionConverter.processBlocks(reader, writer, metaData, schema, metaData.getFileMetaData().getCreatedBy(), codecName);
        }
        finally {
            writer.end(metaData.getFileMetaData().getKeyValueMetaData());
        }
    }

    private void validateColumns(String file, int numRecord, TestDocs testDocs) throws IOException {
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(file)).withConf(this.conf).build();
        for (int i = 0; i < numRecord; ++i) {
            Group group = (Group)reader.read();
            Assert.assertTrue((group.getLong("DocId", 0) == testDocs.docId[i] ? 1 : 0) != 0);
            Assert.assertArrayEquals((byte[])group.getBinary("Name", 0).getBytes(), (byte[])testDocs.name[i].getBytes());
            Assert.assertArrayEquals((byte[])group.getBinary("Gender", 0).getBytes(), (byte[])testDocs.gender[i].getBytes());
            Group subGroup = group.getGroup("Links", 0);
            Assert.assertArrayEquals((byte[])subGroup.getBinary("Backward", 0).getBytes(), (byte[])testDocs.linkBackward[i].getBytes());
            Assert.assertArrayEquals((byte[])subGroup.getBinary("Forward", 0).getBytes(), (byte[])testDocs.linkForward[i].getBytes());
        }
        reader.close();
    }

    private void validMeta(String inputFile, String outFile) throws Exception {
        ParquetMetadata inMetaData = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(inputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetMetadata outMetaData = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(outFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        Assert.assertEquals((Object)inMetaData.getFileMetaData().getSchema(), (Object)outMetaData.getFileMetaData().getSchema());
        Assert.assertEquals((Object)inMetaData.getFileMetaData().getKeyValueMetaData(), (Object)outMetaData.getFileMetaData().getKeyValueMetaData());
    }

    private void validColumnIndex(String inputFile, String outFile) throws Exception {
        ParquetMetadata inMetaData = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(inputFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetMetadata outMetaData = ParquetFileReader.readFooter((Configuration)this.conf, (Path)new Path(outFile), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        Assert.assertEquals((long)inMetaData.getBlocks().size(), (long)outMetaData.getBlocks().size());
        try (CompressionConverter.TransParquetFileReader inReader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(inputFile), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());
             CompressionConverter.TransParquetFileReader outReader = new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(outFile), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).build());){
            for (int i = 0; i < inMetaData.getBlocks().size(); ++i) {
                BlockMetaData inBlockMetaData = (BlockMetaData)inMetaData.getBlocks().get(i);
                BlockMetaData outBlockMetaData = (BlockMetaData)outMetaData.getBlocks().get(i);
                Assert.assertEquals((long)inBlockMetaData.getColumns().size(), (long)outBlockMetaData.getColumns().size());
                for (int j = 0; j < inBlockMetaData.getColumns().size(); ++j) {
                    ColumnChunkMetaData inChunk = (ColumnChunkMetaData)inBlockMetaData.getColumns().get(j);
                    ColumnIndex inColumnIndex = inReader.readColumnIndex(inChunk);
                    OffsetIndex inOffsetIndex = inReader.readOffsetIndex(inChunk);
                    ColumnChunkMetaData outChunk = (ColumnChunkMetaData)outBlockMetaData.getColumns().get(j);
                    ColumnIndex outColumnIndex = outReader.readColumnIndex(outChunk);
                    OffsetIndex outOffsetIndex = outReader.readOffsetIndex(outChunk);
                    if (inColumnIndex != null) {
                        Assert.assertEquals((Object)inColumnIndex.getBoundaryOrder(), (Object)outColumnIndex.getBoundaryOrder());
                        Assert.assertEquals((Object)inColumnIndex.getMaxValues(), (Object)outColumnIndex.getMaxValues());
                        Assert.assertEquals((Object)inColumnIndex.getMinValues(), (Object)outColumnIndex.getMinValues());
                        Assert.assertEquals((Object)inColumnIndex.getNullCounts(), (Object)outColumnIndex.getNullCounts());
                    }
                    if (inOffsetIndex == null) continue;
                    List<Long> inOffsets = this.getOffsets(inReader, inChunk);
                    List<Long> outOffsets = this.getOffsets(outReader, outChunk);
                    Assert.assertEquals((long)inOffsets.size(), (long)outOffsets.size());
                    Assert.assertEquals((long)inOffsets.size(), (long)inOffsetIndex.getPageCount());
                    Assert.assertEquals((long)inOffsetIndex.getPageCount(), (long)outOffsetIndex.getPageCount());
                    for (int k = 0; k < inOffsetIndex.getPageCount(); ++k) {
                        Assert.assertEquals((long)inOffsetIndex.getFirstRowIndex(k), (long)outOffsetIndex.getFirstRowIndex(k));
                        Assert.assertEquals((long)inOffsetIndex.getLastRowIndex(k, inChunk.getValueCount()), (long)outOffsetIndex.getLastRowIndex(k, outChunk.getValueCount()));
                        Assert.assertEquals((long)inOffsetIndex.getOffset(k), (long)inOffsets.get(k));
                        Assert.assertEquals((long)outOffsetIndex.getOffset(k), (long)outOffsets.get(k));
                    }
                }
            }
        }
    }

    private List<Long> getOffsets(CompressionConverter.TransParquetFileReader reader, ColumnChunkMetaData chunk) throws IOException {
        ArrayList<Long> offsets = new ArrayList<Long>();
        reader.setStreamPosition(chunk.getStartingPos());
        long readValues = 0L;
        long totalChunkValues = chunk.getValueCount();
        block5: while (readValues < totalChunkValues) {
            long curOffset = reader.getPos();
            PageHeader pageHeader = reader.readPageHeader();
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    this.compressionConverter.readBlock(pageHeader.getCompressed_page_size(), reader);
                    continue block5;
                }
                case DATA_PAGE: {
                    DataPageHeader headerV1 = pageHeader.data_page_header;
                    offsets.add(curOffset);
                    this.compressionConverter.readBlock(pageHeader.getCompressed_page_size(), reader);
                    readValues += (long)headerV1.getNum_values();
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    DataPageHeaderV2 headerV2 = pageHeader.data_page_header_v2;
                    offsets.add(curOffset);
                    int rlLength = headerV2.getRepetition_levels_byte_length();
                    this.compressionConverter.readBlock(rlLength, reader);
                    int dlLength = headerV2.getDefinition_levels_byte_length();
                    this.compressionConverter.readBlock(dlLength, reader);
                    int payLoadLength = pageHeader.getCompressed_page_size() - rlLength - dlLength;
                    this.compressionConverter.readBlock(payLoadLength, reader);
                    readValues += (long)headerV2.getNum_values();
                    continue block5;
                }
            }
            throw new IOException("Not recognized page type");
        }
        return offsets;
    }

    private String createParquetFile(Configuration conf, Map<String, String> extraMeta, int numRecord, String prefix, String codec, ParquetProperties.WriterVersion writerVersion, int pageSize, TestDocs testDocs) throws IOException {
        MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
        conf.set("parquet.example.schema", schema.toString());
        String file = this.createTempFile(prefix);
        ExampleParquetWriter.Builder builder = (ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(file)).withConf(conf)).withWriterVersion(writerVersion)).withExtraMetaData(extraMeta).withDictionaryEncoding("DocId", true)).withValidation(true)).enablePageWriteChecksum()).withPageSize(pageSize)).withCompressionCodec(CompressionCodecName.valueOf((String)codec));
        try (ParquetWriter writer = builder.build();){
            for (int i = 0; i < numRecord; ++i) {
                SimpleGroup g = new SimpleGroup((GroupType)schema);
                g.add("DocId", testDocs.docId[i]);
                g.add("Name", testDocs.name[i]);
                g.add("Gender", testDocs.gender[i]);
                Group links = g.addGroup("Links");
                links.add(0, testDocs.linkBackward[i]);
                links.add(1, testDocs.linkForward[i]);
                writer.write((Object)g);
            }
        }
        return file;
    }

    private static long getLong() {
        return ThreadLocalRandom.current().nextLong(1000L);
    }

    private String getString() {
        char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'x', 'z', 'y'};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            sb.append(chars[this.rnd.nextInt(10)]);
        }
        return sb.toString();
    }

    private String createTempFile(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toAbsolutePath().toString() + "/test.parquet";
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }

    private class TestDocs {
        public long[] docId;
        public String[] name;
        public String[] gender;
        public String[] linkBackward;
        public String[] linkForward;

        public TestDocs(int numRecord) {
            int i;
            this.docId = new long[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.docId[i] = CompressionConveterTest.getLong();
            }
            this.name = new String[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.name[i] = CompressionConveterTest.this.getString();
            }
            this.gender = new String[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.gender[i] = CompressionConveterTest.this.getString();
            }
            this.linkBackward = new String[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.linkBackward[i] = CompressionConveterTest.this.getString();
            }
            this.linkForward = new String[numRecord];
            for (i = 0; i < numRecord; ++i) {
                this.linkForward[i] = CompressionConveterTest.this.getString();
            }
        }
    }
}

