/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

class MockHadoopInputStream
extends ByteArrayInputStream
implements Seekable,
PositionedReadable {
    static final byte[] TEST_ARRAY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private int[] lengths;
    private int current = 0;

    MockHadoopInputStream(int ... actualReadLengths) {
        super(TEST_ARRAY);
        this.lengths = actualReadLengths;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (this.current < this.lengths.length) {
            if (len <= this.lengths[this.current]) {
                int bytesRead = super.read(b, off, len);
                int n = this.current;
                this.lengths[n] = this.lengths[n] - bytesRead;
                return bytesRead;
            }
            int bytesRead = super.read(b, off, this.lengths[this.current]);
            ++this.current;
            return bytesRead;
        }
        return super.read(b, off, len);
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this.seek(position);
        return this.read(buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not actually supported.");
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        throw new UnsupportedOperationException("Not actually supported.");
    }

    public void seek(long pos) throws IOException {
        this.pos = (int)pos;
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        this.seek(targetPos);
        return true;
    }
}

