/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.util.List;

public class CodespaceRange {
    private byte[] start;
    private byte[] end;

    public byte[] getEnd() {
        return this.end;
    }

    void setEnd(byte[] endBytes) {
        this.end = endBytes;
    }

    public byte[] getStart() {
        return this.start;
    }

    void setStart(byte[] startBytes) {
        this.start = startBytes;
    }

    public boolean matches(byte[] code) {
        if (code.length >= this.start.length && code.length <= this.end.length) {
            for (int i = 0; i < code.length; ++i) {
                int startNum = this.start[i] & 0xFF;
                int codeNum = code[i] & 0xFF;
                int endNum = this.end[i] & 0xFF;
                if (codeNum <= endNum && codeNum >= startNum) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isFullMatch(List<Byte> code) {
        if (code.size() >= this.start.length && code.size() <= this.end.length) {
            for (int i = 0; i < code.size(); ++i) {
                int startNum = this.start[i] & 0xFF;
                int endNum = this.end[i] & 0xFF;
                int codeNum = code.get(i) & 0xFF;
                if (codeNum <= endNum && codeNum >= startNum) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isPartialMatch(byte b, int index) {
        if (index >= this.start.length || index >= this.end.length) {
            return false;
        }
        int startNum = this.start[index] & 0xFF;
        int codeNum = b & 0xFF;
        int endNum = this.end[index] & 0xFF;
        return codeNum <= endNum && codeNum >= startNum;
    }
}

