/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.UnknownEscherRecord;
import org.apache.poi.hslf.record.ExEmbed;
import org.apache.poi.hslf.record.ExObjList;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.usermodel.HSLFObjectData;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.util.LittleEndian;

public final class OLEShape
extends HSLFPictureShape {
    protected ExEmbed _exEmbed;

    public OLEShape(HSLFPictureData data) {
        super(data);
    }

    public OLEShape(HSLFPictureData data, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(data, parent);
    }

    public OLEShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    public int getObjectID() {
        return this.getEscherProperty((short)267);
    }

    public void setObjectID(int objectId) {
        this.setEscherProperty((short)267, objectId);
        EscherContainerRecord ecr = this.getSpContainer();
        EscherSpRecord spRecord = (EscherSpRecord)ecr.getChildById((short)-4086);
        spRecord.setFlags(spRecord.getFlags() | 0x10);
        EscherContainerRecord uerCont = (EscherContainerRecord)ecr.getChildById((short)-4079);
        if (uerCont == null) {
            uerCont = new EscherContainerRecord();
            ecr.addChildRecord((EscherRecord)uerCont);
        }
        uerCont.setRecordId((short)-4079);
        uerCont.setVersion((short)15);
        UnknownEscherRecord uer = (UnknownEscherRecord)uerCont.getChildById((short)RecordTypes.ExObjRefAtom.typeID);
        if (uer == null) {
            uer = new UnknownEscherRecord();
            uerCont.addChildRecord((EscherRecord)uer);
        }
        byte[] uerData = new byte[12];
        LittleEndian.putShort((byte[])uerData, (int)0, (short)0);
        LittleEndian.putShort((byte[])uerData, (int)2, (short)((short)RecordTypes.ExObjRefAtom.typeID));
        LittleEndian.putInt((byte[])uerData, (int)4, (int)4);
        LittleEndian.putInt((byte[])uerData, (int)8, (int)objectId);
        uer.fillFields(uerData, 0, null);
    }

    public HSLFObjectData getObjectData() {
        HSLFSlideShow ppt = this.getSheet().getSlideShow();
        HSLFObjectData[] ole = ppt.getEmbeddedObjects();
        ExEmbed exEmbed = this.getExEmbed();
        HSLFObjectData data = null;
        if (exEmbed != null) {
            int ref = exEmbed.getExOleObjAtom().getObjStgDataRef();
            for (int i = 0; i < ole.length; ++i) {
                if (ole[i].getExOleObjStg().getPersistId() != ref) continue;
                data = ole[i];
            }
        }
        if (data == null) {
            this.logger.log(5, new Object[]{"OLE data not found"});
        }
        return data;
    }

    public ExEmbed getExEmbed() {
        if (this._exEmbed == null) {
            HSLFSlideShow ppt = this.getSheet().getSlideShow();
            ExObjList lst = ppt.getDocumentRecord().getExObjList();
            if (lst == null) {
                this.logger.log(5, new Object[]{"ExObjList not found"});
                return null;
            }
            int id = this.getObjectID();
            Record[] ch = lst.getChildRecords();
            for (int i = 0; i < ch.length; ++i) {
                ExEmbed embd;
                if (!(ch[i] instanceof ExEmbed) || (embd = (ExEmbed)ch[i]).getExOleObjAtom().getObjID() != id) continue;
                this._exEmbed = embd;
            }
        }
        return this._exEmbed;
    }

    public String getInstanceName() {
        return this.getExEmbed().getMenuName();
    }

    public String getFullName() {
        return this.getExEmbed().getClipboardName();
    }

    public String getProgID() {
        return this.getExEmbed().getProgId();
    }
}

