/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model.textproperties;

import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class BitMaskTextProp
extends TextProp
implements Cloneable {
    protected static final POILogger logger = POILogFactory.getLogger(BitMaskTextProp.class);
    private String[] subPropNames;
    private int[] subPropMasks;
    private boolean[] subPropMatches;

    public String[] getSubPropNames() {
        return this.subPropNames;
    }

    public boolean[] getSubPropMatches() {
        return this.subPropMatches;
    }

    protected BitMaskTextProp(int sizeOfDataBlock, int maskInHeader, String overallName, String ... subPropNames) {
        super(sizeOfDataBlock, maskInHeader, "bitmask");
        this.subPropNames = subPropNames;
        this.propName = overallName;
        this.subPropMasks = new int[subPropNames.length];
        this.subPropMatches = new boolean[subPropNames.length];
        int LSB = Integer.lowestOneBit(maskInHeader);
        for (int i = 0; i < this.subPropMasks.length; ++i) {
            this.subPropMasks[i] = LSB << i;
        }
    }

    @Override
    public int getWriteMask() {
        int mask = 0;
        int i = 0;
        for (int subMask : this.subPropMasks) {
            if (!this.subPropMatches[i++]) continue;
            mask |= subMask;
        }
        return mask;
    }

    public void setWriteMask(int writeMask) {
        int i = 0;
        for (int subMask : this.subPropMasks) {
            this.subPropMatches[i++] = (writeMask & subMask) != 0;
        }
    }

    @Override
    public int getValue() {
        return this.maskValue(this.dataValue);
    }

    private int maskValue(int pVal) {
        int val = pVal;
        int i = 0;
        for (int mask : this.subPropMasks) {
            if (this.subPropMatches[i++]) continue;
            val &= ~mask;
        }
        return val;
    }

    @Override
    public void setValue(int val) {
        this.dataValue = val;
        int i = 0;
        for (int mask : this.subPropMasks) {
            this.subPropMatches[i++] = (val & mask) != 0;
        }
    }

    public void setValueWithMask(int val, int writeMask) {
        this.setWriteMask(writeMask);
        this.dataValue = this.maskValue(val);
        if (val != this.dataValue) {
            logger.log(5, new Object[]{"Style properties of '" + this.getName() + "' don't match mask - output will be sanitized"});
            if (logger.check(1)) {
                StringBuilder sb = new StringBuilder("The following style attributes of the '" + this.getName() + "' property will be ignored:\n");
                int i = 0;
                for (int mask : this.subPropMasks) {
                    if (!this.subPropMatches[i] && (val & mask) != 0) {
                        sb.append(this.subPropNames[i]).append(",");
                    }
                    ++i;
                }
                logger.log(1, new Object[]{sb.toString()});
            }
        }
    }

    public boolean getSubValue(int idx) {
        return this.subPropMatches[idx] && (this.dataValue & this.subPropMasks[idx]) != 0;
    }

    public void setSubValue(boolean value, int idx) {
        this.subPropMatches[idx] = true;
        this.dataValue = value ? (this.dataValue |= this.subPropMasks[idx]) : (this.dataValue &= ~this.subPropMasks[idx]);
    }

    @Override
    public BitMaskTextProp clone() {
        BitMaskTextProp newObj = (BitMaskTextProp)super.clone();
        newObj.subPropMatches = new boolean[this.subPropMatches.length];
        return newObj;
    }

    public BitMaskTextProp cloneAll() {
        return (BitMaskTextProp)super.clone();
    }
}

