/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.persistence.atomictypeconverter.impl;

import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.portals.graffito.jcr.exception.IncorrectAtomicTypeException;
import org.apache.portals.graffito.jcr.persistence.atomictypeconverter.AtomicTypeConverter;

public class CalendarTypeConverterImpl
implements AtomicTypeConverter {
    public Value getValue(ValueFactory valueFactory, Object propValue) {
        if (propValue == null) {
            return null;
        }
        return valueFactory.createValue(((Calendar)propValue).getTimeInMillis());
    }

    public Object getObject(Value value) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(value.getLong());
            return calendar;
        }
        catch (RepositoryException e) {
            throw new IncorrectAtomicTypeException("Impossible to convert the value : " + value.toString(), e);
        }
    }

    public String getStringValue(Object object) {
        Calendar calendar = (Calendar)object;
        return new Long(calendar.getTimeInMillis()).toString();
    }
}

