/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.persistence.collectionconverter.impl;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.portals.graffito.jcr.exception.PersistenceException;
import org.apache.portals.graffito.jcr.mapper.Mapper;
import org.apache.portals.graffito.jcr.mapper.model.CollectionDescriptor;
import org.apache.portals.graffito.jcr.persistence.atomictypeconverter.AtomicTypeConverter;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollection;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollectionUtil;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.portals.graffito.jcr.persistence.objectconverter.ObjectConverter;
import org.apache.portals.graffito.jcr.reflection.ReflectionUtils;

public class MultiValueCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    public MultiValueCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableCollection collection) throws RepositoryException {
        try {
            if (collection == null) {
                return;
            }
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            Value[] values = new Value[collection.getSize()];
            ValueFactory valueFactory = session.getValueFactory();
            Iterator collectionIterator = collection.getIterator();
            for (int i = 0; i < collection.getSize(); ++i) {
                Object fieldValue = collectionIterator.next();
                AtomicTypeConverter atomicTypeConverter = (AtomicTypeConverter)this.atomicTypeConverters.get(fieldValue.getClass());
                values[i] = atomicTypeConverter.getValue(valueFactory, fieldValue);
            }
            parentNode.setProperty(jcrName, values);
        }
        catch (ValueFormatException vfe) {
            throw new PersistenceException("Cannot insert collection field : " + collectionDescriptor.getFieldName() + " of class " + collectionDescriptor.getClassDescriptor().getClassName(), vfe);
        }
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableCollection collection) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        if (parentNode.hasProperty(jcrName)) {
            parentNode.setProperty(jcrName, (Value[])null);
        }
        if (collection == null) {
            return;
        }
        Value[] values = new Value[collection.getSize()];
        ValueFactory valueFactory = session.getValueFactory();
        int i = 0;
        Iterator collectionIterator = collection.getIterator();
        while (collectionIterator.hasNext()) {
            Object fieldValue = collectionIterator.next();
            AtomicTypeConverter atomicTypeConverter = (AtomicTypeConverter)this.atomicTypeConverters.get(fieldValue.getClass());
            values[i] = atomicTypeConverter.getValue(valueFactory, fieldValue);
            ++i;
        }
        parentNode.setProperty(jcrName, values);
    }

    protected ManageableCollection doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        try {
            String jcrName = this.getCollectionJcrName(collectionDescriptor);
            if (!parentNode.hasProperty(jcrName)) {
                return null;
            }
            Property property = parentNode.getProperty(jcrName);
            Value[] values = property.getValues();
            ManageableCollection collection = ManageableCollectionUtil.getManageableCollection(collectionFieldClass);
            String elementClassName = collectionDescriptor.getElementClassName();
            Class elementClass = ReflectionUtils.forName(elementClassName);
            for (int i = 0; i < values.length; ++i) {
                AtomicTypeConverter atomicTypeConverter = (AtomicTypeConverter)this.atomicTypeConverters.get(elementClass);
                collection.addObject(atomicTypeConverter.getObject(values[i]));
            }
            return collection;
        }
        catch (ValueFormatException vfe) {
            throw new PersistenceException("Cannot get the collection field : " + collectionDescriptor.getFieldName() + "for class " + collectionDescriptor.getClassDescriptor().getClassName(), vfe);
        }
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        String jcrName = this.getCollectionJcrName(collectionDescriptor);
        return !parentNode.hasProperty(jcrName);
    }
}

