/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.persistence.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.graffito.jcr.exception.IllegalUnlockException;
import org.apache.portals.graffito.jcr.exception.JcrMappingException;
import org.apache.portals.graffito.jcr.exception.LockedException;
import org.apache.portals.graffito.jcr.exception.PersistenceException;
import org.apache.portals.graffito.jcr.exception.RepositoryException;
import org.apache.portals.graffito.jcr.exception.VersionException;
import org.apache.portals.graffito.jcr.mapper.Mapper;
import org.apache.portals.graffito.jcr.mapper.impl.DigesterMapperImpl;
import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;
import org.apache.portals.graffito.jcr.persistence.PersistenceManager;
import org.apache.portals.graffito.jcr.persistence.atomictypeconverter.impl.DefaultAtomicTypeConverterProvider;
import org.apache.portals.graffito.jcr.persistence.impl.ObjectIterator;
import org.apache.portals.graffito.jcr.persistence.objectconverter.ObjectConverter;
import org.apache.portals.graffito.jcr.persistence.objectconverter.impl.ObjectConverterImpl;
import org.apache.portals.graffito.jcr.query.QueryManager;
import org.apache.portals.graffito.jcr.query.impl.QueryManagerImpl;
import org.apache.portals.graffito.jcr.version.VersionIterator;

public class PersistenceManagerImpl
implements PersistenceManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$graffito$jcr$persistence$impl$PersistenceManagerImpl == null ? (class$org$apache$portals$graffito$jcr$persistence$impl$PersistenceManagerImpl = PersistenceManagerImpl.class$("org.apache.portals.graffito.jcr.persistence.impl.PersistenceManagerImpl")) : class$org$apache$portals$graffito$jcr$persistence$impl$PersistenceManagerImpl));
    protected Session session;
    protected Mapper mapper;
    protected QueryManager queryManager;
    protected ObjectConverter objectConverter;
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$persistence$impl$PersistenceManagerImpl;

    public PersistenceManagerImpl(Mapper mapper, QueryManager queryManager, Session session) {
        this.mapper = mapper;
        this.session = session;
        this.objectConverter = new ObjectConverterImpl(mapper, new DefaultAtomicTypeConverterProvider());
        this.queryManager = queryManager;
    }

    public PersistenceManagerImpl(Session session, String[] xmlMappingFiles) {
        this.session = session;
        this.mapper = new DigesterMapperImpl(xmlMappingFiles);
        DefaultAtomicTypeConverterProvider converterProvider = new DefaultAtomicTypeConverterProvider();
        Map atomicTypeConverters = converterProvider.getAtomicTypeConverters();
        this.queryManager = new QueryManagerImpl(this.mapper, atomicTypeConverters);
        this.objectConverter = new ObjectConverterImpl(this.mapper, converterProvider);
    }

    public PersistenceManagerImpl(Mapper mapper, ObjectConverter converter, QueryManager queryManager, Session session) {
        this.mapper = mapper;
        this.session = session;
        this.objectConverter = converter;
        this.queryManager = queryManager;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setObjectConverter(ObjectConverter objectConverter) {
        this.objectConverter = objectConverter;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.queryManager = queryManager;
    }

    public Object getObject(String path) {
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path, e);
        }
        return this.objectConverter.getObject(this.session, path);
    }

    public Object getObject(String path, String versionName) {
        String pathVersion = null;
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
            org.apache.portals.graffito.jcr.version.Version version = this.getVersion(path, versionName);
            pathVersion = version.getPath() + "/jcr:frozenNode";
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path + " - version :" + versionName, e);
        }
        return this.objectConverter.getObject(this.session, pathVersion);
    }

    public Object getObject(Class objectClass, String path) {
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path, e);
        }
        return this.objectConverter.getObject(this.session, objectClass, path);
    }

    public Object getObject(Class objectClass, String path, String versionName) {
        String pathVersion = null;
        try {
            if (!this.session.itemExists(path)) {
                return null;
            }
            org.apache.portals.graffito.jcr.version.Version version = this.getVersion(path, versionName);
            pathVersion = version.getPath() + "/jcr:frozenNode";
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object at " + path + " - version :" + versionName, e);
        }
        return this.objectConverter.getObject(this.session, objectClass, pathVersion);
    }

    public void retrieveAllMappedAttributes(Object object) {
        this.objectConverter.retrieveAllMappedAttributes(this.session, object);
    }

    public void retrieveMappedAttribute(Object object, String attributeName) {
        this.objectConverter.retrieveMappedAttribute(this.session, object, attributeName);
    }

    public void insert(Object object) {
        block4: {
            String path = this.objectConverter.getPath(this.session, object);
            try {
                if (!this.session.itemExists(path)) break block4;
                Item item = this.session.getItem(path);
                if (item.isNode()) {
                    if (!((Node)item).getDefinition().allowsSameNameSiblings()) {
                        throw new PersistenceException("Path already exists and it is not supporting the same name sibling : " + path);
                    }
                    break block4;
                }
                throw new PersistenceException("Path already exists and it is a property : " + path);
            }
            catch (javax.jcr.RepositoryException e) {
                throw new RepositoryException("Impossible to insert the object at " + path, e);
            }
        }
        this.objectConverter.insert(this.session, object);
    }

    public void update(Object object) {
        String path = this.objectConverter.getPath(this.session, object);
        try {
            if (!this.session.itemExists(path)) {
                throw new PersistenceException("Path is not existing : " + path);
            }
            this.checkIfNodeLocked(path);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to update", e);
        }
        this.objectConverter.update(this.session, object);
    }

    public void remove(String path) {
        try {
            if (!this.session.itemExists(path)) {
                throw new PersistenceException("Path does not exist : " + path);
            }
            this.checkIfNodeLocked(path);
            Item item = this.session.getItem(path);
            item.remove();
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to remove the object at " + path, e);
        }
    }

    public void remove(Object object) {
        this.remove(this.objectConverter.getPath(this.session, object));
    }

    public void remove(org.apache.portals.graffito.jcr.query.Query query) {
        try {
            String jcrExpression = this.queryManager.buildJCRExpression(query);
            log.debug((Object)("Remove Objects with expression : " + jcrExpression));
            Query jcrQuery = this.session.getWorkspace().getQueryManager().createQuery(jcrExpression, "xpath");
            QueryResult queryResult = jcrQuery.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                log.debug((Object)("Remove node : " + node.getPath()));
                nodes.add(node);
            }
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                this.checkIfNodeLocked(node.getPath());
                try {
                    node.remove();
                    continue;
                }
                catch (javax.jcr.RepositoryException re) {
                    throw new PersistenceException("Cannot remove node at path " + node.getPath() + " returned from query " + jcrExpression, re);
                }
            }
        }
        catch (InvalidQueryException iqe) {
            throw new RepositoryException("Invalid query expression", iqe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object collection", e);
        }
    }

    public boolean objectExists(String path) {
        try {
            return this.session.itemExists(path);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to check if the object exist", e);
        }
    }

    public boolean isPersistent(Class clazz) {
        boolean isPersistent = false;
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(clazz);
        if (classDescriptor != null) {
            isPersistent = true;
        }
        return isPersistent;
    }

    public Object getObject(org.apache.portals.graffito.jcr.query.Query query) {
        try {
            String jcrExpression = this.queryManager.buildJCRExpression(query);
            log.debug((Object)("Get Object with expression : " + jcrExpression));
            Query jcrQuery = this.session.getWorkspace().getQueryManager().createQuery(jcrExpression, "xpath");
            QueryResult queryResult = jcrQuery.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            if (nodeIterator.getSize() > 1L) {
                throw new PersistenceException("Impossible to get the object - the query returns more than one object");
            }
            Object object = null;
            if (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                object = this.objectConverter.getObject(this.session, node.getPath());
            }
            return object;
        }
        catch (InvalidQueryException iqe) {
            throw new RepositoryException("Invalid query expression", iqe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object collection", e);
        }
    }

    public Collection getObjects(org.apache.portals.graffito.jcr.query.Query query) {
        try {
            String jcrExpression = this.queryManager.buildJCRExpression(query);
            log.debug((Object)("Get Objects with expression : " + jcrExpression));
            Query jcrQuery = this.session.getWorkspace().getQueryManager().createQuery(jcrExpression, "xpath");
            QueryResult queryResult = jcrQuery.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            ArrayList<Object> result = new ArrayList<Object>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                log.debug((Object)("Node found : " + node.getPath()));
                result.add(this.objectConverter.getObject(this.session, node.getPath()));
            }
            return result;
        }
        catch (InvalidQueryException iqe) {
            throw new RepositoryException("Invalid query expression", iqe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object collection", e);
        }
    }

    public Iterator getObjectIterator(org.apache.portals.graffito.jcr.query.Query query) {
        try {
            String jcrExpression = this.queryManager.buildJCRExpression(query);
            log.debug((Object)("Get Object with expression : " + jcrExpression));
            Query jcrQuery = this.session.getWorkspace().getQueryManager().createQuery(jcrExpression, "xpath");
            QueryResult queryResult = jcrQuery.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            return new ObjectIterator(nodeIterator, query.getFilter().getFilterClass(), this.objectConverter, this.session);
        }
        catch (InvalidQueryException iqe) {
            throw new RepositoryException("Invalid query expression", iqe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to get the object collection", e);
        }
    }

    public void checkin(String path) {
        this.checkin(path, null);
    }

    public void checkin(String path, String[] versionLabels) {
        try {
            Node node = (Node)this.session.getItem(path);
            this.checkIfNodeLocked(node.getPath());
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            Version newVersion = node.checkin();
            if (versionLabels != null) {
                VersionHistory versionHistory = node.getVersionHistory();
                for (int i = 0; i < versionLabels.length; ++i) {
                    versionHistory.addVersionLabel(newVersion.getName(), versionLabels[i], false);
                }
            }
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (InvalidItemStateException iise) {
            throw new PersistenceException("Cannot checking modified object at path " + path, iise);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to checkin the object " + path, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Cannot checkin unversionable node at path " + path, uroe);
        }
        catch (LockException le) {
            throw new VersionException("Cannot checkin locked node at path " + path, le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to checkin the object " + path, e);
        }
    }

    public void checkout(String path) {
        Node node = null;
        try {
            node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            node.checkout();
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Cannot checkout unversionable node at path " + path, uroe);
        }
        catch (LockException le) {
            throw new VersionException("Cannot checkout locked node at path " + path, le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to checkout the object " + path, e);
        }
    }

    public void addVersionLabel(String path, String versionName, String versionLabel) {
        try {
            Node node = (Node)this.session.getItem(path);
            this.checkIfNodeLocked(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            history.addVersionLabel(versionName, versionLabel, false);
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to add a new version label to  " + path + " - version name : " + versionName, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to add a new version label to  " + path + " - version name : " + versionName, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public org.apache.portals.graffito.jcr.version.Version getVersion(String path, String versionName) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            return new org.apache.portals.graffito.jcr.version.Version(history.getVersion(versionName));
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("The version name " + versionName + "does not exist", ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve versions for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public String[] getVersionLabels(String path, String versionName) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            Version version = history.getVersion(versionName);
            return history.getVersionLabels(version);
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Impossible to get the version labels : " + path + " - version name : " + versionName, ve);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve versions for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public String[] getAllVersionLabels(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            return history.getVersionLabels();
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve version history for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public VersionIterator getAllVersions(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            return new VersionIterator(history.getAllVersions());
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to retrieve version history for path " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public org.apache.portals.graffito.jcr.version.Version getRootVersion(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            VersionHistory history = node.getVersionHistory();
            return new org.apache.portals.graffito.jcr.version.Version(history.getRootVersion());
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to get the root version  for the object " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public org.apache.portals.graffito.jcr.version.Version getBaseVersion(String path) {
        try {
            Node node = (Node)this.session.getItem(path);
            if (!node.isNodeType("mix:versionable")) {
                throw new VersionException("The object " + path + "is not versionable");
            }
            return new org.apache.portals.graffito.jcr.version.Version(node.getBaseVersion());
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("Cannot retrieve an object from a property path " + path);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Cannot retrieve an object at path " + path, pnfe);
        }
        catch (UnsupportedRepositoryOperationException uroe) {
            throw new VersionException("Impossible to get the base version for the object " + path, uroe);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e);
        }
    }

    public String lock(String absPath, boolean isDeep, boolean isSessionScoped) throws LockedException {
        try {
            this.checkIfNodeLocked(absPath);
            Node node = this.getNode(absPath);
            Lock lock = node.lock(isDeep, isSessionScoped);
            return lock.getLockToken();
        }
        catch (LockException e) {
            throw new RepositoryException("Node of type is not type mix:lockable", e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public void unlock(String absPath, String lockToken) throws IllegalUnlockException {
        String lockOwner = null;
        try {
            this.maybeAddLockToken(lockToken);
            Node node = this.getNode(absPath);
            if (!node.isLocked()) {
                return;
            }
            Lock lock = node.getLock();
            lockOwner = lock.getLockOwner();
            node.unlock();
        }
        catch (LockException e) {
            log.error((Object)("Cannot unlock path: " + absPath + " Jcr user: " + this.session.getUserID() + " has no lock token to do this. Lock was placed with user: " + lockOwner));
            throw new IllegalUnlockException(lockOwner, absPath);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    public boolean isLocked(String absPath) {
        try {
            Node node = this.getNode(absPath);
            return node.isLocked();
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("An exception was thrown while checking the lock at path : " + absPath, e);
        }
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    protected void checkIfNodeLocked(String absPath) throws javax.jcr.RepositoryException, LockedException {
        Node node = this.getNode(absPath);
        if (node.isLocked()) {
            Lock lock = node.getLock();
            String lockOwner = lock.getLockOwner();
            String path = lock.getNode().getPath();
            throw new LockedException(lockOwner, path);
        }
    }

    protected void maybeAddLockToken(String lockToken) {
        if (lockToken != null) {
            String[] lockTokens = this.getSession().getLockTokens();
            if (lockTokens != null) {
                for (int i = 0; i < lockTokens.length && !lockTokens[i].equals(lockToken); ++i) {
                }
            } else {
                this.getSession().addLockToken(lockToken);
            }
        }
    }

    protected Node getNode(String absPath) throws PathNotFoundException, javax.jcr.RepositoryException {
        if (!this.getSession().itemExists(absPath)) {
            throw new PersistenceException("No object stored on path: " + absPath);
        }
        Item item = this.getSession().getItem(absPath);
        if (!item.isNode()) {
            throw new PersistenceException("No object stored on path: " + absPath + " on absPath is item (leaf)");
        }
        return (Node)item;
    }

    public void logout() {
        try {
            log.debug((Object)"Logout. Persisting current session changes.");
            this.session.save();
            this.session.logout();
            log.debug((Object)"Session closed");
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Cannot persist current session changes. An unknown node type was used.", nsnte);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot persist current session changes. Attempt to overwrite checked-in node", ve);
        }
        catch (LockException le) {
            throw new PersistenceException("Cannot persist current session changes. Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new PersistenceException("Cannot persist current session changes.", e);
        }
    }

    public void save() {
        try {
            this.session.save();
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Cannot persist current session changes. An unknown node type was used.", nsnte);
        }
        catch (javax.jcr.version.VersionException ve) {
            throw new VersionException("Cannot persist current session changes. Attempt to overwrite checked-in node", ve);
        }
        catch (LockException le) {
            throw new PersistenceException("Cannot persist current session changes. Violation of a lock detected", le);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new PersistenceException("Cannot persist current session changes.", e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

