/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.persistence.objectconverter.impl;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.graffito.jcr.exception.JcrMappingException;
import org.apache.portals.graffito.jcr.exception.PersistenceException;
import org.apache.portals.graffito.jcr.exception.RepositoryException;
import org.apache.portals.graffito.jcr.mapper.Mapper;
import org.apache.portals.graffito.jcr.mapper.model.BeanDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.CollectionDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.FieldDescriptor;
import org.apache.portals.graffito.jcr.persistence.atomictypeconverter.AtomicTypeConverter;
import org.apache.portals.graffito.jcr.persistence.atomictypeconverter.AtomicTypeConverterProvider;
import org.apache.portals.graffito.jcr.persistence.atomictypeconverter.impl.NullTypeConverterImpl;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.CollectionConverter;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollection;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollectionUtil;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.impl.DefaultCollectionConverterImpl;
import org.apache.portals.graffito.jcr.persistence.objectconverter.BeanConverter;
import org.apache.portals.graffito.jcr.persistence.objectconverter.ObjectConverter;
import org.apache.portals.graffito.jcr.persistence.objectconverter.impl.ProxyManager;
import org.apache.portals.graffito.jcr.reflection.ReflectionUtils;
import org.apache.portals.graffito.jcr.repository.RepositoryUtil;

public class ObjectConverterImpl
implements ObjectConverter {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$graffito$jcr$persistence$objectconverter$impl$ObjectConverterImpl == null ? (class$org$apache$portals$graffito$jcr$persistence$objectconverter$impl$ObjectConverterImpl = ObjectConverterImpl.class$("org.apache.portals.graffito.jcr.persistence.objectconverter.impl.ObjectConverterImpl")) : class$org$apache$portals$graffito$jcr$persistence$objectconverter$impl$ObjectConverterImpl));
    private static final AtomicTypeConverter NULL_CONVERTER = new NullTypeConverterImpl();
    private Mapper mapper;
    private AtomicTypeConverterProvider atomicTypeConverterProvider;
    private ProxyManager proxyManager;
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$persistence$objectconverter$impl$ObjectConverterImpl;

    public ObjectConverterImpl() {
    }

    public ObjectConverterImpl(Mapper mapper, AtomicTypeConverterProvider converterProvider) {
        this.mapper = mapper;
        this.atomicTypeConverterProvider = converterProvider;
        this.proxyManager = new ProxyManager();
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    public void setAtomicTypeConverterProvider(AtomicTypeConverterProvider converterProvider) {
        this.atomicTypeConverterProvider = converterProvider;
    }

    public void insert(Session session, Object object) {
        String path = this.getPath(session, object);
        try {
            String parentPath = RepositoryUtil.getParentPath(path);
            String nodeName = RepositoryUtil.getNodeName(path);
            Node parentNode = (Node)session.getItem(parentPath);
            this.insert(session, parentNode, nodeName, object);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Impossible to insert the object at '" + path + "'", pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to insert the object at '" + path + "'", re);
        }
    }

    public Node insert(Session session, Node parentNode, String nodeName, Object object, Class objclass) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(objclass);
        String jcrNodeType = classDescriptor.getJcrNodeType();
        if (jcrNodeType == null || jcrNodeType.equals("")) {
            jcrNodeType = "nt:unstructured";
        }
        Node objectNode = null;
        try {
            objectNode = parentNode.addNode(nodeName, jcrNodeType);
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Unknown node type " + jcrNodeType + " for mapped class " + object.getClass(), nsnte);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new PersistenceException("Cannot create new node of type " + jcrNodeType + " from mapped class " + object.getClass(), re);
        }
        String[] mixinTypes = classDescriptor.getJcrMixinTypes();
        String mixinTypeName = null;
        try {
            if (null != classDescriptor.getJcrMixinTypes()) {
                for (int i = 0; i < mixinTypes.length; ++i) {
                    mixinTypeName = mixinTypes[i].trim();
                    objectNode.addMixin(mixinTypeName);
                }
            }
            if (!classDescriptor.hasDiscriminator() && classDescriptor.hasInterfaces()) {
                Iterator interfacesIterator = classDescriptor.getImplements().iterator();
                while (interfacesIterator.hasNext()) {
                    String interfaceName = (String)interfacesIterator.next();
                    ClassDescriptor interfaceDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(interfaceName));
                    objectNode.addMixin(interfaceDescriptor.getJcrNodeType().trim());
                }
            }
            if (classDescriptor.hasDiscriminator()) {
                mixinTypeName = "graffito:discriminator";
                objectNode.addMixin(mixinTypeName);
                objectNode.setProperty("graffito:classname", ReflectionUtils.getBeanClass(object).getName());
            }
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Unknown mixin type " + mixinTypeName + " for mapped class " + object.getClass(), nsnte);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new PersistenceException("Cannot create new node of type " + jcrNodeType + " from mapped class " + object.getClass(), re);
        }
        this.storeSimpleFields(session, object, classDescriptor, objectNode);
        this.insertBeanFields(session, object, classDescriptor, objectNode);
        this.insertCollectionFields(session, object, classDescriptor, objectNode);
        return objectNode;
    }

    public Node insert(Session session, Node parentNode, String nodeName, Object object) {
        return this.insert(session, parentNode, nodeName, object, ReflectionUtils.getBeanClass(object));
    }

    public void update(Session session, Object object) {
        String path = this.getPath(session, object);
        try {
            String parentPath = RepositoryUtil.getParentPath(path);
            String nodeName = RepositoryUtil.getNodeName(path);
            Node parentNode = (Node)session.getItem(parentPath);
            this.update(session, parentNode, nodeName, object);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Impossible to update the object at '" + path + "'", pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to update the object at '" + path + "'", re);
        }
    }

    public void update(Session session, Node parentNode, String nodeName, Object object) {
        try {
            Node objectNode = parentNode.getNode(nodeName);
            this.update(session, objectNode, object, ReflectionUtils.getBeanClass(object));
        }
        catch (PathNotFoundException e) {
            throw new PersistenceException("Impossible to update the object: " + nodeName + " at node : " + parentNode, e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new RepositoryException("Impossible to update the object: " + nodeName + " at node : " + parentNode, e);
        }
    }

    public void update(Session session, Node node, Object object) {
        this.update(session, node, object, ReflectionUtils.getBeanClass(object));
    }

    public void update(Session session, Node objectNode, Object object, Class objclass) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(objclass);
        this.checkNodeType(session, classDescriptor);
        this.checkCompatiblePrimaryNodeTypes(session, objectNode, classDescriptor, false);
        this.storeSimpleFields(session, object, classDescriptor, objectNode);
        this.updateBeanFields(session, object, classDescriptor, objectNode);
        this.updateCollectionFields(session, object, classDescriptor, objectNode);
    }

    public Object getObject(Session session, String path) {
        try {
            if (!session.itemExists(path)) {
                return null;
            }
            ClassDescriptor classDescriptor = null;
            Node node = (Node)session.getItem(path);
            if (node.hasProperty("graffito:classname")) {
                String className = node.getProperty("graffito:classname").getValue().getString();
                classDescriptor = this.mapper.getClassDescriptorByClass(Class.forName(className));
            } else {
                String nodeType = node.getPrimaryNodeType().getName();
                if (nodeType.equals("nt:frozenNode")) {
                    nodeType = node.getProperty("jcr:frozenPrimaryType").getString();
                }
                classDescriptor = this.mapper.getClassDescriptorByNodeType(nodeType);
            }
            if (null == classDescriptor) {
                throw new JcrMappingException("Impossible to find the classdescriptor for " + path + ". There is no discriminator and associated  JCR node type");
            }
            Object object = ReflectionUtils.newInstance(classDescriptor.getClassName());
            this.retrieveSimpleFields(session, classDescriptor, node, object);
            this.retrieveBeanFields(session, classDescriptor, node, path, object, false);
            this.retrieveCollectionFields(session, classDescriptor, node, object, false);
            return object;
        }
        catch (ClassNotFoundException clnf) {
            throw new PersistenceException("Impossible to instantiate the object at " + path, clnf);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Impossible to get the object at " + path, pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to get the object at " + path, re);
        }
    }

    public Object getObject(Session session, Class clazz, String path) {
        try {
            if (!session.itemExists(path)) {
                return null;
            }
            ClassDescriptor classDescriptor = this.getClassDescriptor(clazz);
            this.checkNodeType(session, classDescriptor);
            Node node = (Node)session.getItem(path);
            if (!classDescriptor.isInterface()) {
                this.checkCompatiblePrimaryNodeTypes(session, node, classDescriptor, true);
            }
            Object object = null;
            if (classDescriptor.usesNodeTypePerHierarchyStrategy()) {
                if (!node.hasProperty("graffito:classname")) {
                    throw new PersistenceException("Cannot fetch object of type '" + clazz.getName() + "' using NODETYPE_PER_HIERARCHY. Discriminator property is not present.");
                }
                String className = node.getProperty("graffito:classname").getValue().getString();
                classDescriptor = this.getClassDescriptor(Class.forName(className));
                object = ReflectionUtils.newInstance(className);
            } else {
                String nodeType;
                if (classDescriptor.usesNodeTypePerConcreteClassStrategy() && !(nodeType = node.getPrimaryNodeType().getName()).equals(classDescriptor.getJcrNodeType())) {
                    classDescriptor = classDescriptor.getDescendantClassDescriptor(nodeType);
                }
                object = ReflectionUtils.newInstance(classDescriptor.getClassName());
            }
            this.retrieveSimpleFields(session, classDescriptor, node, object);
            this.retrieveBeanFields(session, classDescriptor, node, path, object, false);
            this.retrieveCollectionFields(session, classDescriptor, node, object, false);
            return object;
        }
        catch (ClassNotFoundException clnf) {
            throw new PersistenceException("Impossible to instantiate the object at " + path, clnf);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Impossible to get the object at " + path, pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to get the object at " + path, re);
        }
    }

    public void retrieveAllMappedAttributes(Session session, Object object) {
        String path = null;
        try {
            ClassDescriptor classDescriptor = this.getClassDescriptor(object.getClass());
            String pathFieldName = classDescriptor.getPathFieldDescriptor().getFieldName();
            path = (String)ReflectionUtils.getNestedProperty(object, pathFieldName);
            Node node = (Node)session.getItem(path);
            this.retrieveBeanFields(session, classDescriptor, node, path, object, true);
            this.retrieveCollectionFields(session, classDescriptor, node, object, true);
        }
        catch (PathNotFoundException pnfe) {
            throw new PersistenceException("Impossible to get the object at " + path, pnfe);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Impossible to get the object at " + path, re);
        }
    }

    public void retrieveMappedAttribute(Session session, Object object, String attributeName) {
        block5: {
            String path = null;
            ClassDescriptor classDescriptor = null;
            try {
                classDescriptor = this.getClassDescriptor(object.getClass());
                String pathFieldName = classDescriptor.getPathFieldDescriptor().getFieldName();
                path = (String)ReflectionUtils.getNestedProperty(object, pathFieldName);
                Node node = (Node)session.getItem(path);
                BeanDescriptor beanDescriptor = classDescriptor.getBeanDescriptor(attributeName);
                if (beanDescriptor != null) {
                    this.retrieveBeanField(session, beanDescriptor, node, path, object, true);
                    break block5;
                }
                CollectionDescriptor collectionDescriptor = classDescriptor.getCollectionDescriptor(attributeName);
                if (collectionDescriptor != null) {
                    this.retrieveCollectionField(session, collectionDescriptor, node, object, true);
                    break block5;
                }
                throw new PersistenceException("Impossible to retrieve the mapped attribute. The attribute '" + attributeName + "'  is not a bean or a collection for the class : " + classDescriptor.getClassName());
            }
            catch (PathNotFoundException pnfe) {
                throw new PersistenceException("Impossible to get the object at " + path, pnfe);
            }
            catch (javax.jcr.RepositoryException re) {
                throw new RepositoryException("Impossible to get the object at " + path, re);
            }
        }
    }

    private void checkNodeType(Session session, ClassDescriptor classDescriptor) {
        String jcrTypeName = null;
        try {
            if (classDescriptor.isInterface()) {
                String[] mixinTypes = classDescriptor.getJcrMixinTypes();
                for (int i = 0; i < mixinTypes.length; ++i) {
                    jcrTypeName = mixinTypes[i];
                    session.getWorkspace().getNodeTypeManager().getNodeType(jcrTypeName);
                }
            } else {
                jcrTypeName = classDescriptor.getJcrNodeType();
                if (jcrTypeName != null && !jcrTypeName.equals("")) {
                    session.getWorkspace().getNodeTypeManager().getNodeType(jcrTypeName);
                }
            }
        }
        catch (NoSuchNodeTypeException nsnte) {
            throw new JcrMappingException("Mapping for class '" + classDescriptor.getClassName() + "' use unknown primary or mixin node type '" + jcrTypeName + "'");
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException(re);
        }
    }

    private void checkCompatiblePrimaryNodeTypes(Session session, Node node, ClassDescriptor classDescriptor, boolean checkVersionNode) {
        try {
            NodeType nodeType = node.getPrimaryNodeType();
            boolean compatible = this.checkCompatibleNodeTypes(nodeType, classDescriptor);
            if (!compatible && checkVersionNode && "nt:frozenNode".equals(nodeType.getName())) {
                NodeTypeManager ntMgr = session.getWorkspace().getNodeTypeManager();
                nodeType = ntMgr.getNodeType(node.getProperty("jcr:frozenPrimaryType").getString());
                compatible = this.checkCompatibleNodeTypes(nodeType, classDescriptor);
            }
            if (!compatible) {
                throw new PersistenceException("Cannot map object of type '" + classDescriptor.getClassName() + "'. Node type '" + node.getPrimaryNodeType().getName() + "' does not match descriptor node type '" + classDescriptor.getJcrNodeType() + "'");
            }
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException(re);
        }
    }

    private boolean checkCompatibleNodeTypes(NodeType nodeType, ClassDescriptor descriptor) {
        if (descriptor.getJcrNodeType() == null || descriptor.getJcrNodeType().equals("")) {
            return true;
        }
        if (nodeType.getName().equals(descriptor.getJcrNodeType())) {
            return true;
        }
        NodeType[] superTypes = nodeType.getSupertypes();
        for (int i = 0; i < superTypes.length; ++i) {
            if (!superTypes[i].getName().equals(descriptor.getJcrNodeType())) continue;
            return true;
        }
        return false;
    }

    public String getPath(Session session, Object object) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(object.getClass());
        FieldDescriptor pathFieldDescriptor = classDescriptor.getPathFieldDescriptor();
        if (pathFieldDescriptor == null) {
            throw new JcrMappingException("Class of type: " + object.getClass().getName() + " has no path mapping. Maybe attribute path=\"true\" for a field element of this class in jcrmapping.xml is missing?");
        }
        String pathField = pathFieldDescriptor.getFieldName();
        return (String)ReflectionUtils.getNestedProperty(object, pathField);
    }

    private Object retrieveSimpleFields(Session session, ClassDescriptor classDescriptor, Node node, Object object) {
        Object initializedBean = object;
        try {
            Iterator fieldDescriptorIterator = classDescriptor.getFieldDescriptors().iterator();
            while (fieldDescriptorIterator.hasNext()) {
                Object fieldValue;
                AtomicTypeConverter converter;
                Value propValue;
                FieldDescriptor fieldDescriptor = (FieldDescriptor)fieldDescriptorIterator.next();
                String fieldName = fieldDescriptor.getFieldName();
                String propertyName = fieldDescriptor.getJcrName();
                if (fieldDescriptor.isPath()) {
                    if (null == initializedBean) {
                        initializedBean = ReflectionUtils.newInstance(classDescriptor.getClassName());
                    }
                    ReflectionUtils.setNestedProperty(initializedBean, fieldName, node.getPath());
                    continue;
                }
                if (classDescriptor.usesNodeTypePerHierarchyStrategy() && classDescriptor.hasDiscriminator()) {
                    if (node.hasProperty("graffito:classname")) {
                        if (null == initializedBean) {
                            initializedBean = ReflectionUtils.newInstance(classDescriptor.getClassName());
                        }
                        if (node.hasProperty(propertyName)) {
                            propValue = node.getProperty(propertyName).getValue();
                            converter = this.getAtomicTypeConverter(fieldDescriptor, initializedBean, fieldName);
                            fieldValue = converter.getObject(propValue);
                            ReflectionUtils.setNestedProperty(initializedBean, fieldName, fieldValue);
                            continue;
                        }
                        log.warn((Object)("Class '" + classDescriptor.getClassName() + "' has an unmapped property : " + propertyName));
                        continue;
                    }
                    throw new PersistenceException("Class '" + classDescriptor.getClassName() + "' have not a discriminator property.");
                }
                if (node.hasProperty(propertyName)) {
                    propValue = node.getProperty(propertyName).getValue();
                    if (null != propValue && null == initializedBean) {
                        initializedBean = ReflectionUtils.newInstance(classDescriptor.getClassName());
                    }
                    converter = this.getAtomicTypeConverter(fieldDescriptor, initializedBean, fieldName);
                    fieldValue = converter.getObject(propValue);
                    ReflectionUtils.setNestedProperty(initializedBean, fieldName, fieldValue);
                    continue;
                }
                log.warn((Object)("Class '" + classDescriptor.getClassName() + "' has an unmapped property : " + propertyName));
            }
        }
        catch (ValueFormatException vfe) {
            throw new PersistenceException("Cannot retrieve properties of object " + object + " of class " + object.getClass() + " from node " + node, vfe);
        }
        catch (javax.jcr.RepositoryException re) {
            String nodePath = null;
            try {
                nodePath = node.getPath();
            }
            catch (javax.jcr.RepositoryException e) {
                // empty catch block
            }
            if (nodePath == null) {
                nodePath = node.toString();
            }
            throw new RepositoryException("Cannot retrieve properties of object " + object + " of class " + object.getClass().getName() + " from node " + nodePath, re);
        }
        return initializedBean;
    }

    private void retrieveBeanFields(Session session, ClassDescriptor classDescriptor, Node node, String path, Object object, boolean forceToRetrieve) {
        Iterator beanDescriptorIterator = classDescriptor.getBeanDescriptors().iterator();
        while (beanDescriptorIterator.hasNext()) {
            BeanDescriptor beanDescriptor = (BeanDescriptor)beanDescriptorIterator.next();
            this.retrieveBeanField(session, beanDescriptor, node, path, object, forceToRetrieve);
        }
    }

    private void retrieveBeanField(Session session, BeanDescriptor beanDescriptor, Node node, String path, Object object, boolean forceToRetrieve) {
        if (!beanDescriptor.isAutoRetrieve() && !forceToRetrieve) {
            return;
        }
        String beanName = beanDescriptor.getFieldName();
        Class beanClass = ReflectionUtils.getPropertyType(object, beanName);
        Object bean = null;
        if (beanDescriptor.isProxy()) {
            bean = this.proxyManager.createBeanProxy(session, this, beanClass, path + "/" + beanDescriptor.getJcrName());
        } else if (beanDescriptor.isInline()) {
            bean = this.retrieveSimpleFields(session, this.mapper.getClassDescriptorByClass(beanClass), node, bean);
        } else if (null != beanDescriptor.getConverter() && !"".equals(beanDescriptor.getConverter())) {
            String converterClassName = beanDescriptor.getConverter();
            Object[] param = new Object[]{this};
            BeanConverter beanConverter = (BeanConverter)ReflectionUtils.invokeConstructor(converterClassName, param);
            bean = beanConverter.getObject(session, node, beanDescriptor, beanClass);
        } else {
            bean = this.getObject(session, path + "/" + beanDescriptor.getJcrName());
        }
        ReflectionUtils.setNestedProperty(object, beanName, bean);
    }

    private void retrieveCollectionFields(Session session, ClassDescriptor classDescriptor, Node parentNode, Object object, boolean forceToRetrieve) {
        Iterator collectionDescriptorIterator = classDescriptor.getCollectionDescriptors().iterator();
        while (collectionDescriptorIterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)collectionDescriptorIterator.next();
            this.retrieveCollectionField(session, collectionDescriptor, parentNode, object, forceToRetrieve);
        }
    }

    private void retrieveCollectionField(Session session, CollectionDescriptor collectionDescriptor, Node parentNode, Object object, boolean forceToRetrieve) {
        if (!collectionDescriptor.isAutoRetrieve() && !forceToRetrieve) {
            return;
        }
        CollectionConverter collectionConverter = this.getCollectionConverter(session, collectionDescriptor);
        Class collectionFieldClass = ReflectionUtils.getPropertyType(object, collectionDescriptor.getFieldName());
        ManageableCollection collection = null;
        collection = collectionDescriptor.isProxy() ? (ManageableCollection)this.proxyManager.createCollectionProxy(session, collectionConverter, parentNode, collectionDescriptor, collectionFieldClass) : collectionConverter.getCollection(session, parentNode, collectionDescriptor, collectionFieldClass);
        ReflectionUtils.setNestedProperty(object, collectionDescriptor.getFieldName(), collection);
    }

    private void insertBeanFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        Iterator beanDescriptorIterator = classDescriptor.getBeanDescriptors().iterator();
        while (beanDescriptorIterator.hasNext()) {
            BeanDescriptor beanDescriptor = (BeanDescriptor)beanDescriptorIterator.next();
            if (!beanDescriptor.isAutoInsert()) continue;
            String jcrName = beanDescriptor.getJcrName();
            Object bean = ReflectionUtils.getNestedProperty(object, beanDescriptor.getFieldName());
            if (bean == null) continue;
            if (beanDescriptor.isInline()) {
                this.storeSimpleFields(session, bean, this.mapper.getClassDescriptorByClass(bean.getClass()), objectNode);
                continue;
            }
            if (null != beanDescriptor.getConverter() && !"".equals(beanDescriptor.getConverter())) {
                String converterClassName = beanDescriptor.getConverter();
                Object[] param = new Object[]{this};
                BeanConverter beanConverter = (BeanConverter)ReflectionUtils.invokeConstructor(converterClassName, param);
                beanConverter.insert(session, objectNode, beanDescriptor, object);
                continue;
            }
            this.insert(session, objectNode, jcrName, bean);
        }
    }

    private void updateBeanFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        String jcrName = null;
        try {
            Iterator beanDescriptorIterator = classDescriptor.getBeanDescriptors().iterator();
            while (beanDescriptorIterator.hasNext()) {
                BeanConverter beanConverter;
                Object[] param;
                String converterClassName;
                BeanDescriptor beanDescriptor = (BeanDescriptor)beanDescriptorIterator.next();
                if (!beanDescriptor.isAutoUpdate()) continue;
                jcrName = beanDescriptor.getJcrName();
                Object bean = ReflectionUtils.getNestedProperty(object, beanDescriptor.getFieldName());
                if (bean == null) {
                    if (beanDescriptor.isInline()) {
                        Class beanClass = ReflectionUtils.getPropertyType(object, beanDescriptor.getFieldName());
                        this.storeSimpleFields(session, bean, this.mapper.getClassDescriptorByClass(beanClass), objectNode);
                        continue;
                    }
                    if (null != beanDescriptor.getConverter() && !"".equals(beanDescriptor.getConverter())) {
                        converterClassName = beanDescriptor.getConverter();
                        param = new Object[]{this};
                        beanConverter = (BeanConverter)ReflectionUtils.invokeConstructor(converterClassName, param);
                        beanConverter.remove(session, objectNode, beanDescriptor);
                        continue;
                    }
                    if (!objectNode.hasNode(jcrName)) continue;
                    objectNode.getNode(jcrName).remove();
                    continue;
                }
                if (beanDescriptor.isInline()) {
                    this.storeSimpleFields(session, bean, this.mapper.getClassDescriptorByClass(bean.getClass()), objectNode);
                    continue;
                }
                if (null != beanDescriptor.getConverter() && !"".equals(beanDescriptor.getConverter())) {
                    converterClassName = beanDescriptor.getConverter();
                    param = new Object[]{this};
                    beanConverter = (BeanConverter)ReflectionUtils.invokeConstructor(converterClassName, param);
                    beanConverter.update(session, objectNode, beanDescriptor, bean);
                    continue;
                }
                this.update(session, objectNode, jcrName, bean);
            }
        }
        catch (VersionException ve) {
            throw new PersistenceException("Cannot remove bean at path " + jcrName, ve);
        }
        catch (LockException le) {
            throw new PersistenceException("Cannot remove bean at path " + jcrName + ". Item is locked.", le);
        }
        catch (ConstraintViolationException cve) {
            throw new PersistenceException("Cannot remove bean at path " + jcrName + ". Contraint violation.", cve);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot remove bean at path " + jcrName, re);
        }
    }

    private void insertCollectionFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        Iterator collectionDescriptorIterator = classDescriptor.getCollectionDescriptors().iterator();
        while (collectionDescriptorIterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)collectionDescriptorIterator.next();
            if (!collectionDescriptor.isAutoInsert()) continue;
            CollectionConverter collectionConverter = this.getCollectionConverter(session, collectionDescriptor);
            Object collection = ReflectionUtils.getNestedProperty(object, collectionDescriptor.getFieldName());
            ManageableCollection manageableCollection = ManageableCollectionUtil.getManageableCollection(collection);
            collectionConverter.insertCollection(session, objectNode, collectionDescriptor, manageableCollection);
        }
    }

    private void updateCollectionFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        Iterator collectionDescriptorIterator = classDescriptor.getCollectionDescriptors().iterator();
        while (collectionDescriptorIterator.hasNext()) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)collectionDescriptorIterator.next();
            if (!collectionDescriptor.isAutoUpdate()) continue;
            CollectionConverter collectionConverter = this.getCollectionConverter(session, collectionDescriptor);
            Object collection = ReflectionUtils.getNestedProperty(object, collectionDescriptor.getFieldName());
            ManageableCollection manageableCollection = ManageableCollectionUtil.getManageableCollection(collection);
            collectionConverter.updateCollection(session, objectNode, collectionDescriptor, manageableCollection);
        }
    }

    private void storeSimpleFields(Session session, Object object, ClassDescriptor classDescriptor, Node objectNode) {
        try {
            ValueFactory valueFactory = session.getValueFactory();
            Iterator fieldDescriptorIterator = classDescriptor.getFieldDescriptors().iterator();
            while (fieldDescriptorIterator.hasNext()) {
                FieldDescriptor fieldDescriptor = (FieldDescriptor)fieldDescriptorIterator.next();
                String fieldName = fieldDescriptor.getFieldName();
                String jcrName = fieldDescriptor.getJcrName();
                if (fieldDescriptor.isPath()) continue;
                boolean protectedProperty = fieldDescriptor.isJcrProtected();
                if (objectNode.hasProperty(jcrName)) {
                    protectedProperty = objectNode.getProperty(jcrName).getDefinition().isProtected();
                }
                if (protectedProperty) continue;
                Object fieldValue = ReflectionUtils.getNestedProperty(object, fieldName);
                AtomicTypeConverter converter = this.getAtomicTypeConverter(fieldDescriptor, object, fieldName);
                Value value = converter.getValue(valueFactory, fieldValue);
                boolean autoCreated = fieldDescriptor.isJcrAutoCreated();
                if (objectNode.hasProperty(jcrName)) {
                    autoCreated = objectNode.getProperty(jcrName).getDefinition().isAutoCreated();
                }
                if (!autoCreated) {
                    this.checkMandatoryProperty(objectNode, fieldDescriptor, value);
                }
                objectNode.setProperty(jcrName, value);
            }
        }
        catch (ValueFormatException vfe) {
            throw new PersistenceException("Cannot persist properties of object " + object + ". Value format exception.", vfe);
        }
        catch (VersionException ve) {
            throw new PersistenceException("Cannot persist properties of object " + object + ". Versioning exception.", ve);
        }
        catch (LockException le) {
            throw new PersistenceException("Cannot persist properties of object " + object + " on locked node.", le);
        }
        catch (ConstraintViolationException cve) {
            throw new PersistenceException("Cannot persist properties of object " + object + ". Constraint violation.", cve);
        }
        catch (javax.jcr.RepositoryException re) {
            throw new RepositoryException("Cannot persist properties of object " + object, re);
        }
    }

    private CollectionConverter getCollectionConverter(Session session, CollectionDescriptor collectionDescriptor) {
        String className = collectionDescriptor.getCollectionConverter();
        Map atomicTypeConverters = this.atomicTypeConverterProvider.getAtomicTypeConverters();
        if (className == null) {
            return new DefaultCollectionConverterImpl(atomicTypeConverters, this, this.mapper);
        }
        return (CollectionConverter)ReflectionUtils.invokeConstructor(className, new Object[]{atomicTypeConverters, this, this.mapper});
    }

    private void checkMandatoryProperty(Node objectNode, FieldDescriptor fieldDescriptor, Value value) throws javax.jcr.RepositoryException {
        PropertyDefinition[] propertyDefinitions = objectNode.getPrimaryNodeType().getDeclaredPropertyDefinitions();
        for (int i = 0; i < propertyDefinitions.length; ++i) {
            PropertyDefinition definition = propertyDefinitions[i];
            if (!definition.getName().equals(fieldDescriptor.getJcrName()) || !definition.isMandatory() || definition.isAutoCreated() || value != null) continue;
            throw new PersistenceException("Class of type:" + fieldDescriptor.getClassDescriptor().getClassName() + " has property: " + fieldDescriptor.getFieldName() + " declared as JCR property: " + fieldDescriptor.getJcrName() + " This property is mandatory but property in bean has value null");
        }
    }

    private AtomicTypeConverter getAtomicTypeConverter(FieldDescriptor fd, Object object, String fieldName) {
        Class fieldTypeClass = null;
        if (null != fd.getFieldTypeClass()) {
            fieldTypeClass = fd.getFieldTypeClass();
        } else if (null != object) {
            fieldTypeClass = ReflectionUtils.getPropertyType(object, fieldName);
        }
        if (null != fieldTypeClass) {
            return this.atomicTypeConverterProvider.getAtomicTypeConverter(fieldTypeClass);
        }
        return NULL_CONVERTER;
    }

    private ClassDescriptor getClassDescriptor(Class beanClass) {
        ClassDescriptor classDescriptor = this.mapper.getClassDescriptorByClass(beanClass);
        if (null == classDescriptor) {
            throw new JcrMappingException("Class of type: " + beanClass.getName() + " is not JCR persistable. Maybe element 'class-descriptor' for this type in mapping file is missing");
        }
        return classDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

