/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.query.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.portals.graffito.jcr.mapper.Mapper;
import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;
import org.apache.portals.graffito.jcr.query.Filter;
import org.apache.portals.graffito.jcr.query.Query;

public class QueryImpl
implements Query {
    private Filter filter;
    ClassDescriptor classDescriptor;
    private ArrayList orderByExpressions = new ArrayList();

    public QueryImpl(Filter filter, Mapper mapper) {
        this.filter = filter;
        this.classDescriptor = mapper.getClassDescriptorByClass(filter.getFilterClass());
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void addOrderByDescending(String fieldNameAttribute) {
        this.orderByExpressions.add("@" + this.getJcrFieldName(fieldNameAttribute) + " descending");
    }

    public void addOrderByAscending(String fieldNameAttribute) {
        this.orderByExpressions.add("@" + this.getJcrFieldName(fieldNameAttribute) + " ascending");
    }

    public String getOrderByExpression() {
        if (this.orderByExpressions.size() == 0) {
            return "";
        }
        String orderByExpression = "order by ";
        Iterator iterator = this.orderByExpressions.iterator();
        int count = 1;
        while (iterator.hasNext()) {
            if (count > 1) {
                orderByExpression = orderByExpression + " , ";
            }
            orderByExpression = orderByExpression + (String)iterator.next();
            ++count;
        }
        return orderByExpression;
    }

    private String getJcrFieldName(String fieldAttribute) {
        return this.classDescriptor.getJcrName(fieldAttribute);
    }
}

