/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.reflection;

import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.proxy.Enhancer;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.portals.graffito.jcr.exception.JcrMappingException;

public abstract class ReflectionUtils {
    public static Object getNestedProperty(Object object, String fieldName) {
        if (null == object) {
            return null;
        }
        try {
            return PropertyUtils.getNestedProperty((Object)object, (String)fieldName);
        }
        catch (IllegalAccessException e) {
            throw new JcrMappingException("Cannot access property " + fieldName, e);
        }
        catch (InvocationTargetException e) {
            throw new JcrMappingException("Cannot access property " + fieldName, e);
        }
        catch (NoSuchMethodException e) {
            throw new JcrMappingException("Cannot access property " + fieldName, e);
        }
    }

    public static Class getPropertyType(Object object, String fieldName) {
        try {
            return PropertyUtils.getPropertyType((Object)object, (String)fieldName);
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot access property " + fieldName, ex);
        }
    }

    public static Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot create instance for class " + clazz, ex);
        }
    }

    public static Object invokeConstructor(String className, Object[] params) {
        try {
            Class<?> converterClass = Class.forName(className);
            return ConstructorUtils.invokeConstructor(converterClass, (Object[])params);
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot create instance for class " + className, ex);
        }
    }

    public static void setNestedProperty(Object object, String fieldName, Object value) {
        try {
            PropertyUtils.setNestedProperty((Object)object, (String)fieldName, (Object)value);
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot set the field " + fieldName + " in the class : " + object.getClass().toString(), ex);
        }
    }

    public static Object newInstance(String clazz) {
        try {
            return Class.forName(clazz).newInstance();
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot create instance for class " + clazz, ex);
        }
    }

    public static Class forName(String clazz) {
        try {
            return Class.forName(clazz);
        }
        catch (Exception ex) {
            throw new JcrMappingException("Cannot load class " + clazz, ex);
        }
    }

    public static boolean isProxy(Class beanClass) {
        return Enhancer.isEnhanced((Class)beanClass);
    }

    public static Class getBeanClass(Object bean) {
        Class<?> beanClass = bean.getClass();
        if (ReflectionUtils.isProxy(beanClass)) {
            return beanClass.getSuperclass();
        }
        return beanClass;
    }
}

