/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.repository;

import java.util.Hashtable;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.core.jndi.RegistryHelper;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.portals.graffito.jcr.exception.JcrMappingException;
import org.apache.portals.graffito.jcr.exception.PersistenceException;
import org.apache.portals.graffito.jcr.exception.RepositoryException;

public class RepositoryUtil {
    public static final String GRAFFITO_NAMESPACE_PREFIX = "graffito";
    public static final String GRAFFITO_NAMESPACE = "http://incubator.apache.org/graffito";
    public static final String PATH_SEPARATOR = "/";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$graffito$jcr$repository$RepositoryUtil == null ? (class$org$apache$portals$graffito$jcr$repository$RepositoryUtil = RepositoryUtil.class$("org.apache.portals.graffito.jcr.repository.RepositoryUtil")) : class$org$apache$portals$graffito$jcr$repository$RepositoryUtil));
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$repository$RepositoryUtil;

    public static void registerRepository(String repositoryName, String configFile, String homeDir) throws RepositoryException {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
            env.put("java.naming.provider.url", "localhost");
            InitialContext ctx = new InitialContext(env);
            RegistryHelper.registerRepository((Context)ctx, (String)repositoryName, (String)configFile, (String)homeDir, (boolean)true);
        }
        catch (Exception e) {
            throw new RepositoryException("Impossible to register the respository : " + repositoryName + " - config file : " + configFile, e);
        }
    }

    public static void unRegisterRepository(String repositoryName) throws RepositoryException {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
            env.put("java.naming.provider.url", "localhost");
            InitialContext ctx = new InitialContext(env);
            RegistryHelper.unregisterRepository((Context)ctx, (String)repositoryName);
        }
        catch (Exception e) {
            throw new RepositoryException("Impossible to unregister the respository : " + repositoryName, e);
        }
    }

    public static Repository getRepository(String repositoryName) throws RepositoryException {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "org.apache.jackrabbit.core.jndi.provider.DummyInitialContextFactory");
            env.put("java.naming.provider.url", "localhost");
            InitialContext ctx = new InitialContext(env);
            Repository repository = (Repository)ctx.lookup(repositoryName);
            return repository;
        }
        catch (Exception e) {
            throw new RepositoryException("Impossible to get the repository : " + repositoryName, e);
        }
    }

    public static Session login(Repository repository, String user, String password) throws RepositoryException {
        try {
            Session session = repository.login((Credentials)new SimpleCredentials(user, password.toCharArray()), null);
            RepositoryUtil.setupSession(session);
            return session;
        }
        catch (Exception e) {
            throw new RepositoryException("Impossible to login ", e);
        }
    }

    public static boolean isValidPath(String path) {
        return path != null && !path.equals(PATH_SEPARATOR) && !path.endsWith(PATH_SEPARATOR) && path.startsWith(PATH_SEPARATOR) && !path.equals("");
    }

    public static String getParentPath(String path) throws PersistenceException {
        String parentPath = "";
        if (!RepositoryUtil.isValidPath(path)) {
            throw new JcrMappingException("Invalid path : " + path);
        }
        String[] pathElements = path.split(PATH_SEPARATOR);
        if (pathElements.length == 2) {
            return PATH_SEPARATOR;
        }
        for (int i = 0; i < pathElements.length - 1; ++i) {
            if (pathElements[i].equals("")) continue;
            parentPath = parentPath + PATH_SEPARATOR + pathElements[i];
        }
        return parentPath;
    }

    public static String getNodeName(String path) throws PersistenceException {
        String[] pathElements = path.split(PATH_SEPARATOR);
        if (!RepositoryUtil.isValidPath(path)) {
            throw new JcrMappingException("Invalid path : " + path);
        }
        return pathElements[pathElements.length - 1];
    }

    private static void setupSession(Session session) throws RepositoryException {
        try {
            String[] jcrNamespaces = session.getWorkspace().getNamespaceRegistry().getPrefixes();
            boolean createGraffitoNamespace = true;
            for (int i = 0; i < jcrNamespaces.length; ++i) {
                if (!jcrNamespaces[i].equals(GRAFFITO_NAMESPACE_PREFIX)) continue;
                createGraffitoNamespace = false;
                log.debug((Object)"Graffito namespace exists.");
            }
            if (createGraffitoNamespace) {
                session.getWorkspace().getNamespaceRegistry().registerNamespace(GRAFFITO_NAMESPACE_PREFIX, GRAFFITO_NAMESPACE);
                log.info((Object)"Successfully created graffito namespace.");
            }
            if (session.getRootNode() != null) {
                log.info((Object)"Jcr repository setup successfull.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while setting up the jcr repository.", (Throwable)e);
            throw new RepositoryException(e.getMessage());
        }
    }

    public static String encodePath(String path) {
        String[] pathElements = Text.explode((String)path, (int)47);
        for (int i = 0; i < pathElements.length; ++i) {
            pathElements[i] = ISO9075.encode((String)pathElements[i]);
        }
        return PATH_SEPARATOR + Text.implode((String[])pathElements, (String)PATH_SEPARATOR);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

