/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.security;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.CredentialsCallback;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.log4j.Logger;

public class SimpleLoginModule
implements LoginModule {
    private static Logger log = Logger.getLogger((Class)(class$org$apache$portals$graffito$jcr$security$SimpleLoginModule == null ? (class$org$apache$portals$graffito$jcr$security$SimpleLoginModule = SimpleLoginModule.class$("org.apache.portals.graffito.jcr.security.SimpleLoginModule")) : class$org$apache$portals$graffito$jcr$security$SimpleLoginModule));
    private static final String OPT_ANONYMOUS = "anonymousId";
    private static final String DEFAULT_ANONYMOUS_ID = "anonymous";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private final Set principals = new HashSet();
    private String anonymousUserId = "anonymous";
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$security$SimpleLoginModule;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        String userId = (String)options.get(OPT_ANONYMOUS);
        if (userId != null) {
            this.anonymousUserId = userId;
        }
    }

    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("no CallbackHandler available");
        }
        Callback[] callbacks = new Callback[]{new CredentialsCallback()};
        boolean authenticated = false;
        this.principals.clear();
        try {
            this.callbackHandler.handle(callbacks);
            CredentialsCallback ccb = (CredentialsCallback)callbacks[0];
            Credentials creds = ccb.getCredentials();
            if (creds != null && creds instanceof SimpleCredentials) {
                SimpleCredentials sc = (SimpleCredentials)creds;
                Object attr = sc.getAttribute("org.apache.jackrabbit.core.security.impersonator");
                if (attr != null && attr instanceof Subject) {
                    Subject impersonator = (Subject)attr;
                }
                if (this.anonymousUserId.equals(sc.getUserID())) {
                    this.principals.add(new AnonymousPrincipal());
                } else {
                    this.principals.add(new UserPrincipal(sc.getUserID()));
                }
                authenticated = true;
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getCallback().toString() + " not available");
        }
        if (authenticated) {
            return !this.principals.isEmpty();
        }
        this.principals.clear();
        throw new FailedLoginException();
    }

    public boolean commit() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.subject.getPrincipals().addAll(this.principals);
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.principals.isEmpty()) {
            return false;
        }
        this.logout();
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

