/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.pluto.container.bean.processor.MethodDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedMethod {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedMethod.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private final Class<?> beanClass;
    private final Method meth;
    private final Annotation annotation;
    private final MethodDescription description;
    private int ordinal = 0;
    private boolean ordinalSet = false;
    private BeanManager beanMgr;
    private Bean<?> bean;
    private Object beanInstance;
    private boolean isPortletClass = false;

    public AnnotatedMethod(Annotation anno, Class<?> beanClass, Method meth, MethodDescription desc) {
        this.beanClass = beanClass;
        this.meth = meth;
        this.annotation = anno;
        this.description = desc;
        try {
            Method ord = anno.getClass().getMethod("ordinal", new Class[0]);
            this.ordinal = (Integer)ord.invoke((Object)anno, new Object[0]);
            this.ordinalSet = true;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public AnnotatedMethod(Class<?> beanClass, Object beanInstance, Method meth, MethodDescription desc) {
        this.beanClass = beanClass;
        this.beanInstance = beanInstance;
        this.meth = meth;
        this.annotation = null;
        this.description = desc;
        this.isPortletClass = true;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public MethodDescription getDescription() {
        return this.description;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void activate(BeanManager bm) {
        this.beanMgr = bm;
        if (bm != null) {
            Set beans = bm.getBeans(this.beanClass, new Annotation[0]);
            this.bean = bm.resolve(beans);
            assert (this.bean != null);
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("ID: ").append(this.toString());
            txt.append(", beanMgr == null?: ").append(this.beanMgr == null);
            txt.append(", bean == null?: ").append(this.bean == null);
            LOG.trace(txt.toString());
        }
    }

    public void setPortletClassInstance(Object beanInstance) {
        if (isTrace) {
            StringBuilder str = new StringBuilder();
            str.append("Updating class instance.");
            str.append(", bean class: ").append(this.beanClass.getCanonicalName());
            str.append(", instance: ").append(beanInstance == null ? "null" : "not null");
            LOG.debug(str.toString());
        }
        this.beanInstance = beanInstance;
        this.isPortletClass = true;
    }

    public Object invoke(Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.isPortletClass) {
            if (isTrace) {
                StringBuilder txt = new StringBuilder();
                txt.append("ID: ").append(this.toString());
                txt.append(", beanMgr == null?").append(this.beanMgr == null);
                txt.append(", bean == null?").append(this.bean == null);
                LOG.trace(txt.toString());
            }
            this.beanInstance = this.beanMgr.getReference(this.bean, (Type)this.bean.getBeanClass(), this.beanMgr.createCreationalContext(this.bean));
        }
        return this.meth.invoke(this.beanInstance, args);
    }

    public String toString() {
        StringBuilder txt = new StringBuilder(256);
        txt.append("Bean class=").append(this.beanClass.getCanonicalName());
        txt.append(", Method name=").append(this.meth.getName());
        if (this.ordinalSet) {
            txt.append(", Ordinal=").append(this.ordinal);
        }
        return txt.toString();
    }

    public Method getJavaMethod() {
        return this.meth;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof AnnotatedMethod) {
            AnnotatedMethod pm = (AnnotatedMethod)o;
            return this.meth.equals(pm.meth);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.meth == null ? 0 : this.meth.hashCode());
        return result;
    }
}

