/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.inject.spi.BeanManager;
import javax.portlet.annotations.ActionMethod;
import javax.portlet.annotations.EventMethod;
import javax.portlet.annotations.PortletQName;
import javax.xml.namespace.QName;
import org.apache.pluto.container.bean.processor.AnnotatedMethod;
import org.apache.pluto.container.bean.processor.AnnotatedMethodComparator;
import org.apache.pluto.container.bean.processor.ConfigSummary;
import org.apache.pluto.container.bean.processor.MethodIdentifier;
import org.apache.pluto.container.bean.processor.MethodIdentifierComparator;
import org.apache.pluto.container.bean.processor.MethodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedMethodStore {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedMethodStore.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private final Map<MethodIdentifier, List<AnnotatedMethod>> methods = new HashMap<MethodIdentifier, List<AnnotatedMethod>>();
    private final Set<String> portletNames = new TreeSet<String>();
    private final ConfigSummary summary;
    private final Map<String, List<QName>> procEvtRefs = new HashMap<String, List<QName>>();
    private final Set<MethodIdentifier> procEvtRefFixups = new HashSet<MethodIdentifier>();
    private final Map<String, List<QName>> pubEvtRefs = new HashMap<String, List<QName>>();
    private BeanManager beanMgr = null;

    public AnnotatedMethodStore(ConfigSummary consum) {
        this.summary = consum;
    }

    private List<AnnotatedMethod> getMethodList(MethodIdentifier mi, AnnotatedMethod am) {
        List<AnnotatedMethod> list = this.methods.get(mi);
        if (list != null) {
            if (!am.getDescription().isAllowMultiple()) {
                StringBuilder txt = new StringBuilder(128);
                txt.append("Duplicate method specification. Method identifier: ");
                txt.append(mi.toString());
                txt.append(" / Method 1: ").append(list.get(0).toString());
                txt.append(" / Method 2: ").append(am.toString());
                this.summary.addErrorString(mi.getName(), txt.toString());
                LOG.warn("Disallowed duplicate entry: " + mi.toString());
                list = null;
            }
        } else {
            list = new ArrayList<AnnotatedMethod>();
            this.methods.put(mi, list);
        }
        return list;
    }

    public boolean addMethod(MethodIdentifier mi, AnnotatedMethod am) {
        StringBuilder txt;
        QName qn;
        String uri;
        ActionMethod anno;
        ArrayList<QName> procqns = new ArrayList<QName>();
        ArrayList<QName> pubqns = new ArrayList<QName>();
        if (mi.getType() == MethodType.ACTION && am.getAnnotation() != null) {
            anno = (ActionMethod)am.getAnnotation();
            for (PortletQName pqn : anno.publishingEvents()) {
                uri = pqn.namespaceURI().trim();
                uri = uri.length() == 0 ? "" : uri;
                qn = new QName(uri, pqn.localPart());
                pubqns.add(qn);
            }
        } else if (mi.getType() == MethodType.EVENT && am.getAnnotation() != null) {
            anno = (EventMethod)am.getAnnotation();
            for (PortletQName pqn : anno.publishingEvents()) {
                uri = pqn.namespaceURI().trim();
                uri = uri.length() == 0 ? "" : uri;
                qn = new QName(uri, pqn.localPart());
                pubqns.add(qn);
            }
            for (PortletQName pqn : anno.processingEvents()) {
                uri = pqn.namespaceURI().trim();
                uri = uri.length() == 0 ? "" : uri;
                qn = new QName(uri, pqn.localPart());
                procqns.add(qn);
            }
        }
        if (mi.getType() == MethodType.EVENT && procqns.size() > 0) {
            List<QName> qns = this.procEvtRefs.get(mi.getName());
            if (qns != null) {
                EventMethod anno2 = (EventMethod)am.getAnnotation();
                for (PortletQName pqn : anno2.processingEvents()) {
                    qn = new QName(pqn.namespaceURI(), pqn.localPart());
                    if (!qns.contains(qn)) continue;
                    StringBuilder txt2 = new StringBuilder(128);
                    txt2.append("Duplicate processing event QName. Portlet name: ");
                    txt2.append(mi.getName());
                    txt2.append(", QName: ").append(qn);
                    txt2.append(", Annotation: @EventMethod");
                    txt2.append(", Class: ").append(am.getJavaMethod().getDeclaringClass().getCanonicalName());
                    this.summary.addErrorString(mi.getName(), txt2.toString());
                    LOG.warn(txt2.toString());
                    return false;
                }
            } else if (procqns.size() == 0) {
                txt = new StringBuilder(128);
                txt.append("Missing processing event QName. Portlet name: ");
                txt.append(mi.getName());
                txt.append(", Annotation: @EventMethod");
                txt.append(", Class: ").append(am.getJavaMethod().getDeclaringClass().getCanonicalName());
                this.summary.addErrorString(mi.getName(), txt.toString());
                LOG.warn(txt.toString());
                return false;
            }
            ArrayList<QName> badQns = new ArrayList<QName>();
            for (QName qn2 : procqns) {
                MethodIdentifier newmi = new MethodIdentifier(mi);
                newmi.setId(qn2);
                List<AnnotatedMethod> list = this.getMethodList(newmi, am);
                if (list == null) {
                    badQns.add(qn2);
                    continue;
                }
                if (qn2.getNamespaceURI().equals("")) {
                    this.procEvtRefFixups.add(newmi);
                }
                list.add(am);
            }
            if (badQns.size() > 0) {
                procqns.removeAll(badQns);
                if (procqns.size() == 0) {
                    return false;
                }
            }
        } else {
            List<AnnotatedMethod> list = this.getMethodList(mi, am);
            if (list == null) {
                return false;
            }
            list.add(am);
        }
        this.portletNames.add(mi.getName());
        String portletName = mi.getName();
        if (procqns.size() > 0) {
            if (!this.procEvtRefs.containsKey(portletName)) {
                this.procEvtRefs.put(portletName, new ArrayList());
            }
            this.procEvtRefs.get(portletName).addAll(procqns);
        }
        if (pubqns.size() > 0) {
            if (!this.pubEvtRefs.containsKey(portletName)) {
                this.pubEvtRefs.put(portletName, new ArrayList());
            }
            this.pubEvtRefs.get(portletName).addAll(pubqns);
        }
        if (isDebug) {
            txt = new StringBuilder();
            txt.append("Stored annotated method for: ").append(mi.toString());
            txt.append(", Processing event refs: ").append(procqns);
            txt.append(", Publishing event refs: ").append(procqns);
            LOG.debug(txt.toString());
        }
        return true;
    }

    public List<AnnotatedMethod> removeMethod(MethodIdentifier mi) {
        return this.methods.remove(mi);
    }

    public AnnotatedMethod getMethod(MethodIdentifier mi) {
        AnnotatedMethod pm = null;
        List<AnnotatedMethod> list = this.methods.get(mi);
        if (list != null) {
            assert (list.size() == 1);
            assert (!list.get(0).getDescription().isAllowMultiple());
            pm = list.get(0);
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Retrieved annotated method for: ").append(mi.toString());
            txt.append(", Method: ").append(pm == null ? "null" : pm.toString());
            LOG.trace(txt.toString());
        }
        return pm;
    }

    public List<AnnotatedMethod> getMethods(MethodIdentifier mi) {
        ArrayList<AnnotatedMethod> aList = new ArrayList<AnnotatedMethod>();
        if (this.methods.containsKey(mi)) {
            aList.addAll((Collection<AnnotatedMethod>)this.methods.get(mi));
        }
        return aList;
    }

    public String getMethodsAsString() {
        ArrayList<MethodIdentifier> meths = new ArrayList<MethodIdentifier>();
        meths.addAll(this.methods.keySet());
        Collections.sort(meths, new MethodIdentifierComparator());
        StringBuilder txt = new StringBuilder(256);
        txt.append("Stored methods: ");
        for (MethodIdentifier mi : meths) {
            txt.append("\n\t").append(mi.toString());
            for (AnnotatedMethod pm : this.methods.get(mi)) {
                txt.append("\n\t\t").append(pm.toString());
            }
        }
        return txt.toString();
    }

    public String toString() {
        StringBuilder txt = new StringBuilder(256);
        txt.append("\n");
        txt.append(this.getMethodsAsString());
        return txt.toString();
    }

    public Set<String> getPortletNames() {
        return new HashSet<String>(this.portletNames);
    }

    public Set<MethodIdentifier> getMethodIDsForPortlet(String portletName) {
        HashSet<MethodIdentifier> meths = new HashSet<MethodIdentifier>();
        for (MethodIdentifier mi : this.methods.keySet()) {
            if (!mi.getName().equals(portletName)) continue;
            meths.add(mi);
        }
        return meths;
    }

    public void removeMethodsForPortlet(String portletName) {
        HashSet<MethodIdentifier> meths = new HashSet<MethodIdentifier>();
        for (MethodIdentifier mi : this.methods.keySet()) {
            if (!mi.getName().equals(portletName)) continue;
            meths.add(mi);
        }
        for (MethodIdentifier mi : meths) {
            this.methods.remove(mi);
        }
        this.portletNames.remove(portletName);
    }

    public void activateMethods(BeanManager bm) {
        this.beanMgr = bm;
        Collection<List<AnnotatedMethod>> methlists = this.methods.values();
        for (List<AnnotatedMethod> list : methlists) {
            Collections.sort(list, new AnnotatedMethodComparator());
            for (AnnotatedMethod meth : list) {
                meth.activate(bm);
            }
        }
    }

    public List<QName> getProcessingEventRefs(String portletName) {
        ArrayList<QName> list = new ArrayList<QName>();
        if (this.procEvtRefs.containsKey(portletName)) {
            list.addAll((Collection<QName>)this.procEvtRefs.get(portletName));
        }
        return list;
    }

    public List<QName> getPublishingEventRefs(String portletName) {
        ArrayList<QName> list = new ArrayList<QName>();
        if (this.pubEvtRefs.containsKey(portletName)) {
            list.addAll((Collection<QName>)this.pubEvtRefs.get(portletName));
        }
        return list;
    }

    public void setDefaultNamespace(String ns) {
        if (ns != null && !ns.equals("")) {
            QName newqn;
            ArrayList oldqns;
            StringBuilder txt;
            for (MethodIdentifier mi : this.procEvtRefFixups) {
                List<AnnotatedMethod> meths = this.methods.get(mi);
                assert (meths != null && meths.size() > 0);
                assert (mi.getType() == MethodType.EVENT && mi.getId() instanceof QName);
                QName oldqn = (QName)mi.getId();
                assert (oldqn.getNamespaceURI().equals(""));
                QName newqn2 = new QName(ns, oldqn.getLocalPart());
                MethodIdentifier newmi = new MethodIdentifier(mi);
                newmi.setId(newqn2);
                this.methods.remove(mi);
                this.methods.put(newmi, meths);
                if (!isDebug) continue;
                txt = new StringBuilder();
                txt.append("Fixing up Method identifier with default namespace: ").append(ns);
                txt.append(", old MI: ").append(mi);
                txt.append(", new MI: ").append(newmi);
                LOG.debug(txt.toString());
            }
            for (String pn : this.procEvtRefs.keySet()) {
                oldqns = new ArrayList(this.procEvtRefs.get(pn));
                for (QName oldqn : oldqns) {
                    if (!oldqn.getNamespaceURI().equals("")) continue;
                    newqn = new QName(ns, oldqn.getLocalPart());
                    this.procEvtRefs.get(pn).remove(oldqn);
                    this.procEvtRefs.get(pn).add(newqn);
                    if (!isDebug) continue;
                    txt = new StringBuilder();
                    txt.append("Fixed up processing event reference for portlet: ").append(pn);
                    txt.append(", old QN: ").append(oldqn);
                    txt.append(", new QN: ").append(newqn);
                    LOG.debug(txt.toString());
                }
            }
            for (String pn : this.pubEvtRefs.keySet()) {
                oldqns = new ArrayList(this.pubEvtRefs.get(pn));
                for (QName oldqn : oldqns) {
                    if (!oldqn.getNamespaceURI().equals("")) continue;
                    newqn = new QName(ns, oldqn.getLocalPart());
                    this.pubEvtRefs.get(pn).remove(oldqn);
                    this.pubEvtRefs.get(pn).add(newqn);
                    if (!isDebug) continue;
                    txt = new StringBuilder();
                    txt.append("Fixed up publishing event reference for portlet: ").append(pn);
                    txt.append(", old QN: ").append(oldqn);
                    txt.append(", new QN: ").append(newqn);
                    LOG.debug(txt.toString());
                }
            }
        }
    }

    public BeanManager getBeanMgr() {
        return this.beanMgr;
    }

    public void setPortletClassInstance(String portletName, Class<?> cls, Object beanInstance) {
        for (MethodIdentifier mi : this.getMethodIDsForPortlet(portletName)) {
            List<AnnotatedMethod> list = this.methods.get(mi);
            for (AnnotatedMethod am : list) {
                if (!am.getBeanClass().equals(cls)) continue;
                am.setPortletClassInstance(beanInstance);
            }
        }
    }
}

