/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.bean.processor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.portlet.PortletRequest;
import javax.portlet.StateAwareResponse;
import javax.portlet.annotations.PortletSerializable;
import org.apache.pluto.container.bean.processor.PortletStateScopedConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletStateScopedBeanHolder
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PortletStateScopedBeanHolder.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final long serialVersionUID = 6014843414216617217L;
    private static final ThreadLocal<PortletStateScopedBeanHolder> holders = new ThreadLocal();
    private Map<Contextual<?>, BeanInstance<?>> beans = new ConcurrentHashMap();
    private final PortletRequest request;
    private final PortletStateScopedConfig config;

    private PortletStateScopedBeanHolder(PortletRequest req, PortletStateScopedConfig config) {
        this.request = req;
        this.config = config;
    }

    public static void setBeanHolder(PortletRequest req, PortletStateScopedConfig config) {
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Setting render state bean holder.");
            txt.append(" ThreadId=").append(Thread.currentThread().getId());
            txt.append(", config: ").append(config == null ? "null" : config.getConfigAsString());
            LOG.trace(txt.toString());
        }
        PortletStateScopedBeanHolder holder = new PortletStateScopedBeanHolder(req, config);
        holders.set(holder);
    }

    public static void removeBeanHolder(StateAwareResponse resp) {
        PortletStateScopedBeanHolder bh = PortletStateScopedBeanHolder.getBeanHolder();
        if (bh != null) {
            bh.removeAll(resp);
        }
        holders.remove();
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Removed render state bean holder.");
            txt.append(" ThreadId=").append(Thread.currentThread().getId());
            LOG.trace(txt.toString());
        }
    }

    public static PortletStateScopedBeanHolder getBeanHolder() {
        return holders.get();
    }

    public static PortletStateScopedBeanHolder deregister() {
        PortletStateScopedBeanHolder holder = holders.get();
        holders.remove();
        return holder;
    }

    public static void register(PortletStateScopedBeanHolder holder) {
        holders.set(holder);
    }

    public <T> T getBean(Contextual<T> bean) {
        BeanInstance<?> bi = this.beans.get(bean);
        return bi == null ? null : (T)bi.instance;
    }

    public <T> T getBean(Contextual<T> bean, CreationalContext<T> crco) {
        BeanInstance<Object> bi = this.beans.get(bean);
        if (bi == null) {
            BeanInstance newbi = new BeanInstance();
            newbi.crco = crco;
            newbi.instance = bean.create(crco);
            assert (newbi.instance instanceof PortletSerializable);
            bi = newbi;
            assert (bean instanceof Bean);
            String parmName = this.config.getParamName((Bean)bean);
            Object[] vals = this.request.getRenderParameters().getValues(parmName);
            if (vals == null) {
                vals = new String[]{};
            }
            PortletSerializable thisBean = (PortletSerializable)newbi.instance;
            thisBean.deserialize((String[])vals);
            this.beans.put(bean, newbi);
            if (isTrace) {
                StringBuilder txt = new StringBuilder(80);
                txt.append("Created bean: ");
                txt.append(((Bean)bean).getBeanClass().getSimpleName());
                txt.append(", Render parameter name: ").append(parmName);
                txt.append(", Values: ").append(Arrays.toString(vals));
                LOG.trace(txt.toString());
            }
        }
        return bi.instance;
    }

    protected <T> void remove(Contextual<T> bean) {
        BeanInstance<?> bi = this.beans.get(bean);
        if (isTrace) {
            StringBuilder txt = new StringBuilder(80);
            txt.append("Removing render state scoped bean: ");
            if (bean instanceof Bean) {
                Bean b = (Bean)bean;
                txt.append(b.getBeanClass().getSimpleName());
            }
            if (bi == null) {
                txt.append(", instance is null.");
            }
            LOG.trace(txt.toString());
        }
        if (bi != null) {
            this.beans.remove(bean);
            bi.crco.release();
            bean.destroy(bi.instance, bi.crco);
        }
    }

    protected void removeAll(StateAwareResponse resp) {
        for (Contextual<?> bean : this.beans.keySet()) {
            if (resp != null) {
                PortletSerializable thisBean = (PortletSerializable)this.beans.get(bean).instance;
                Object[] vals = thisBean.serialize();
                String pn = this.config.getParamName((Bean)bean);
                resp.getRenderParameters().setValues(pn, (String[])vals);
                if (isTrace) {
                    StringBuilder txt = new StringBuilder(128);
                    txt.append("Stored parameter for portlet with namespace: ");
                    txt.append(resp.getNamespace());
                    txt.append(", paramName: ").append(pn);
                    txt.append(", Values: ").append(Arrays.toString(vals));
                    LOG.trace(txt.toString());
                }
            }
            this.remove(bean);
        }
    }

    private class BeanInstance<T>
    implements Serializable {
        private static final long serialVersionUID = -4173708394115905180L;
        CreationalContext<T> crco;
        T instance;

        private BeanInstance() {
        }
    }
}

