/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.MutableRenderParameters;
import javax.portlet.RenderParameters;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.impl.MutableRenderParametersImpl;
import org.apache.pluto.container.impl.PortletParametersImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderParametersImpl
extends PortletParametersImpl
implements RenderParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderParametersImpl.class);
    private static final boolean isTrace = LOGGER.isTraceEnabled();
    private final Set<String> prpNames;

    public static final void load() {
        if (isTrace) {
            LOGGER.debug("Loaded.");
        }
    }

    public RenderParametersImpl(PortletURLProvider urlProvider, String windowId) {
        super(urlProvider, windowId, PortletURLProvider.ParamType.RENDER);
        this.prpNames = urlProvider.getPublicParameterNames(windowId);
    }

    protected RenderParametersImpl(Map<String, String[]> params, String windowId, Set<String> prpNames) {
        super(params, windowId, PortletURLProvider.ParamType.RENDER);
        this.prpNames = new HashSet<String>(prpNames);
    }

    public MutableRenderParameters clone() {
        if (isTrace) {
            LOGGER.debug("Window ID: " + this.windowId + ", ParameterType: " + this.type);
        }
        MutableRenderParametersImpl map = new MutableRenderParametersImpl((Map<String, String[]>)this.params, this.windowId, this.prpNames);
        return map;
    }

    public boolean isPublic(String name) {
        this.checkNull("name", name);
        boolean isPublic = this.prpNames.contains(name);
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Window ID: ").append(this.windowId).append(", Name: ").append(name).append(", isPublic: ").append(isPublic);
            LOGGER.debug(txt.toString());
        }
        return isPublic;
    }
}

