/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.om.portlet.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.CustomPortletMode;
import org.apache.pluto.container.om.portlet.CustomWindowState;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.Filter;
import org.apache.pluto.container.om.portlet.FilterMapping;
import org.apache.pluto.container.om.portlet.Listener;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PublicRenderParameter;
import org.apache.pluto.container.om.portlet.SecurityConstraint;
import org.apache.pluto.container.om.portlet.UserAttribute;
import org.apache.pluto.container.om.portlet.impl.ContainerRuntimeOptionImpl;
import org.apache.pluto.container.om.portlet.impl.CustomPortletModeImpl;
import org.apache.pluto.container.om.portlet.impl.CustomWindowStateImpl;
import org.apache.pluto.container.om.portlet.impl.EventDefinitionImpl;
import org.apache.pluto.container.om.portlet.impl.FilterComparator;
import org.apache.pluto.container.om.portlet.impl.FilterImpl;
import org.apache.pluto.container.om.portlet.impl.FilterMappingImpl;
import org.apache.pluto.container.om.portlet.impl.ListenerComparator;
import org.apache.pluto.container.om.portlet.impl.ListenerImpl;
import org.apache.pluto.container.om.portlet.impl.PortletDefinitionImpl;
import org.apache.pluto.container.om.portlet.impl.PublicRenderParameterImpl;
import org.apache.pluto.container.om.portlet.impl.SecurityConstraintImpl;
import org.apache.pluto.container.om.portlet.impl.UserAttributeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletApplicationDefinitionImpl
implements PortletApplicationDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(PortletApplicationDefinitionImpl.class);
    private String id;
    private String name;
    private String contextPath;
    private String version = "3.0";
    private String resourceBundle;
    private String defaultNamespace;
    private final List<PublicRenderParameter> prps = new ArrayList<PublicRenderParameter>();
    private final List<PortletDefinition> portlets = new ArrayList<PortletDefinition>();
    private final List<EventDefinition> events = new ArrayList<EventDefinition>();
    private final List<CustomPortletMode> cpms = new ArrayList<CustomPortletMode>();
    private final List<CustomWindowState> cwss = new ArrayList<CustomWindowState>();
    private final List<UserAttribute> uattrs = new ArrayList<UserAttribute>();
    private final List<Filter> filters = new ArrayList<Filter>();
    private final List<FilterMapping> fmaps = new ArrayList<FilterMapping>();
    private final List<ContainerRuntimeOption> cros = new ArrayList<ContainerRuntimeOption>();
    private final Map<Locale, String> localemap = new HashMap<Locale, String>();
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<SecurityConstraint> constraints = new ArrayList<SecurityConstraint>();

    public PortletApplicationDefinitionImpl() {
    }

    public PortletApplicationDefinitionImpl(PortletApplicationDefinition pad) {
        this.contextPath = pad.getContextPath();
        this.id = pad.getId();
        this.name = pad.getName();
        this.version = pad.getVersion();
        this.resourceBundle = pad.getResourceBundle();
        this.defaultNamespace = pad.getDefaultNamespace();
        for (PortletDefinition pd : pad.getPortlets()) {
            this.portlets.add(pd);
        }
        for (EventDefinition item : pad.getEventDefinitions()) {
            this.events.add(item);
        }
        for (PublicRenderParameter prp : pad.getPublicRenderParameters()) {
            this.prps.add(prp);
        }
        for (CustomPortletMode cpm : pad.getCustomPortletModes()) {
            this.cpms.add(cpm);
        }
        for (EventDefinition item : pad.getCustomWindowStates()) {
            this.cwss.add((CustomWindowState)item);
        }
        for (UserAttribute ua : pad.getUserAttributes()) {
            this.uattrs.add(ua);
        }
        for (Filter f : pad.getFilters()) {
            this.filters.add(f);
        }
        for (FilterMapping fm : pad.getFilterMappings()) {
            this.fmaps.add(fm);
        }
        for (ContainerRuntimeOption cro : pad.getContainerRuntimeOptions()) {
            this.cros.add(cro);
        }
        this.localemap.putAll(pad.getLocaleEncodingMappings());
        if (pad.getListeners() != null) {
            for (Listener l : pad.getListeners()) {
                this.listeners.add(new ListenerImpl(l));
            }
        }
        this.constraints.addAll(pad.getSecurityConstraints());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(String resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace == null ? "" : this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public PortletDefinition getPortlet(String portletName) {
        PortletDefinitionImpl pd = null;
        for (PortletDefinition item : this.portlets) {
            if (!item.getPortletName().equals(portletName)) continue;
            pd = new PortletDefinitionImpl(item);
        }
        return pd;
    }

    public List<PortletDefinition> getPortlets() {
        ArrayList<PortletDefinition> ret = new ArrayList<PortletDefinition>();
        for (PortletDefinition pd : this.portlets) {
            ret.add(new PortletDefinitionImpl(pd));
        }
        return ret;
    }

    public List<PortletDefinition> getMatchingPortlets(String portletName) {
        ArrayList<PortletDefinition> ret = new ArrayList<PortletDefinition>();
        String match = portletName.replaceAll("^(.*)\\*$", "$1");
        for (PortletDefinition pd : this.portlets) {
            if (!pd.getPortletName().startsWith(match)) continue;
            ret.add(new PortletDefinitionImpl(pd));
        }
        return ret;
    }

    public void addPortlet(PortletDefinition pd) {
        if (this.portlets.remove(pd)) {
            LOG.debug("Removed duplicate portlet: " + pd.getPortletName());
        }
        this.portlets.add(pd);
    }

    public boolean removePortlet(PortletDefinition pd) {
        return this.portlets.remove(pd);
    }

    public List<EventDefinition> getEventDefinitions() {
        ArrayList<EventDefinition> items = new ArrayList<EventDefinition>();
        for (EventDefinition item : this.events) {
            items.add(new EventDefinitionImpl(item));
        }
        return items;
    }

    public EventDefinition getEventDefinition(QName qn) {
        EventDefinitionImpl ret = null;
        for (EventDefinition item : this.events) {
            if (!item.getQName().equals(qn)) continue;
            ret = new EventDefinitionImpl(item);
        }
        return ret;
    }

    public void addEventDefinition(EventDefinition ed) {
        if (this.events.remove(ed)) {
            LOG.debug("Removed duplicate event definition: " + ed.getQName());
        }
        this.events.add(ed);
    }

    public boolean removeEventDefinition(EventDefinition ed) {
        return this.events.remove(ed);
    }

    public PublicRenderParameter getPublicRenderParameter(String identifier) {
        PublicRenderParameterImpl ret = null;
        for (PublicRenderParameter prp : this.prps) {
            if (!prp.getIdentifier().equals(identifier)) continue;
            ret = new PublicRenderParameterImpl(prp);
        }
        return ret;
    }

    public List<PublicRenderParameter> getPublicRenderParameters() {
        ArrayList<PublicRenderParameter> items = new ArrayList<PublicRenderParameter>();
        for (PublicRenderParameter item : this.prps) {
            items.add(new PublicRenderParameterImpl(item));
        }
        return items;
    }

    public void addPublicRenderParameter(PublicRenderParameter prp) {
        int ii = this.prps.indexOf(prp);
        if (ii >= 0) {
            PublicRenderParameter tprp = this.prps.get(ii);
            this.prps.remove(prp);
            StringBuilder txt = new StringBuilder(128);
            txt.append("Removed duplicate public render parameter definition for QName: ");
            txt.append(tprp.getQName());
            txt.append(", id: ").append(tprp.getIdentifier());
            LOG.debug(txt.toString());
        }
        this.prps.add(prp);
    }

    public boolean removePublicRenderParameter(PublicRenderParameter prp) {
        return this.prps.remove(prp);
    }

    public CustomPortletMode getCustomPortletMode(String arg) {
        CustomPortletModeImpl ret = null;
        for (CustomPortletMode item : this.cpms) {
            if (!item.getPortletMode().equals(arg)) continue;
            ret = new CustomPortletModeImpl(item);
        }
        return ret;
    }

    public List<CustomPortletMode> getCustomPortletModes() {
        ArrayList<CustomPortletMode> items = new ArrayList<CustomPortletMode>();
        for (CustomPortletMode item : this.cpms) {
            items.add(new CustomPortletModeImpl(item));
        }
        return items;
    }

    public void addCustomPortletMode(CustomPortletMode cpm) {
        if (this.cpms.remove(cpm)) {
            LOG.debug("Removed duplicate custom portlet mode: " + cpm.getPortletMode());
        }
        this.cpms.add(cpm);
    }

    public boolean removeCustomPortletMode(CustomPortletMode pm) {
        return this.cpms.remove(pm);
    }

    public CustomWindowState getCustomWindowState(String arg) {
        CustomWindowStateImpl ret = null;
        for (CustomWindowState item : this.cwss) {
            if (!item.getWindowState().equals(arg)) continue;
            ret = new CustomWindowStateImpl(item);
        }
        return ret;
    }

    public List<CustomWindowState> getCustomWindowStates() {
        ArrayList<CustomWindowState> items = new ArrayList<CustomWindowState>();
        for (CustomWindowState item : this.cwss) {
            items.add(new CustomWindowStateImpl(item));
        }
        return items;
    }

    public void addCustomWindowState(CustomWindowState cws) {
        if (this.cwss.remove(cws)) {
            LOG.debug("Removed duplicate custom window state: " + cws.getWindowState());
        }
        this.cwss.add(cws);
    }

    public boolean removeCustomWindowState(CustomWindowState ws) {
        return this.cwss.remove(ws);
    }

    public UserAttribute getUserAttribute(String arg) {
        UserAttributeImpl ret = null;
        for (UserAttribute item : this.uattrs) {
            if (!item.getName().equals(arg)) continue;
            ret = new UserAttributeImpl(item);
        }
        return ret;
    }

    public List<UserAttribute> getUserAttributes() {
        ArrayList<UserAttribute> items = new ArrayList<UserAttribute>();
        for (UserAttribute item : this.uattrs) {
            items.add(new UserAttributeImpl(item));
        }
        return items;
    }

    public void addUserAttribute(UserAttribute ua) {
        if (this.uattrs.remove(ua)) {
            LOG.debug("Removed duplicate user attribute: " + ua.getName());
        }
        this.uattrs.add(ua);
    }

    public boolean removeUserAttribute(UserAttribute ua) {
        return this.uattrs.remove(ua);
    }

    public Filter getFilter(String arg) {
        FilterImpl ret = null;
        for (Filter item : this.filters) {
            if (!item.getFilterName().equals(arg)) continue;
            ret = new FilterImpl(item);
        }
        return ret;
    }

    public List<Filter> getFilters() {
        ArrayList<Filter> items = new ArrayList<Filter>();
        for (Filter item : this.filters) {
            items.add(new FilterImpl(item));
        }
        return items;
    }

    public void addFilter(Filter filter) {
        boolean removed = this.filters.remove(filter);
        if (removed) {
            LOG.debug("Removed duplicate filter definition: " + filter.getFilterName());
        }
        if (filter.getFilterClass() != null && filter.getFilterClass().length() > 0) {
            this.filters.add(filter);
            Collections.sort(this.filters, new FilterComparator());
        } else {
            LOG.debug("No filter class for filter. Deleting filter mapping. filter name: " + filter.getFilterName());
            this.removeFilterMapping(this.getFilterMapping(filter.getFilterName()));
        }
    }

    public boolean removeFilter(Filter filter) {
        return this.filters.remove(filter);
    }

    public FilterMapping getFilterMapping(String arg) {
        FilterMappingImpl ret = null;
        for (FilterMapping item : this.fmaps) {
            if (!item.getFilterName().equals(arg)) continue;
            ret = new FilterMappingImpl(item);
        }
        return ret;
    }

    public List<FilterMapping> getFilterMappings() {
        ArrayList<FilterMapping> items = new ArrayList<FilterMapping>();
        for (FilterMapping item : this.fmaps) {
            items.add(new FilterMappingImpl(item));
        }
        return items;
    }

    public void addFilterMapping(FilterMapping fm) {
        if (this.fmaps.remove(fm)) {
            LOG.debug("Removed duplicate filter mapping: " + fm.getFilterName());
        }
        if (fm.getPortletNames().size() > 0) {
            this.fmaps.add(fm);
        } else {
            LOG.debug("No portlet names for filter mapping. Filter name: " + fm.getFilterName());
        }
    }

    public boolean removeFilterMapping(FilterMapping fm) {
        return this.fmaps.remove(fm);
    }

    public ContainerRuntimeOption getContainerRuntimeOption(String arg) {
        ContainerRuntimeOptionImpl ret = null;
        for (ContainerRuntimeOption item : this.cros) {
            if (!item.getName().equals(arg)) continue;
            ret = new ContainerRuntimeOptionImpl(item);
        }
        return ret;
    }

    public List<ContainerRuntimeOption> getContainerRuntimeOptions() {
        ArrayList<ContainerRuntimeOption> items = new ArrayList<ContainerRuntimeOption>();
        for (ContainerRuntimeOption item : this.cros) {
            items.add(new ContainerRuntimeOptionImpl(item));
        }
        return items;
    }

    public void addContainerRuntimeOption(ContainerRuntimeOption cro) {
        if (this.cros.remove(cro)) {
            LOG.debug("Removed duplicate container runtime option: " + cro.getName());
        }
        this.cros.add(cro);
    }

    public boolean removeRuntimeOption(ContainerRuntimeOption cro) {
        return this.cros.remove(cro);
    }

    public Listener getListener(String name) {
        for (Listener l : this.listeners) {
            if (!l.getListenerName().equals(name)) continue;
            return new ListenerImpl(l);
        }
        return null;
    }

    public List<Listener> getListeners() {
        ArrayList<Listener> list = new ArrayList<Listener>();
        for (Listener l : this.listeners) {
            list.add(new ListenerImpl(l));
        }
        return list;
    }

    public void addListener(Listener listener) {
        if (this.version.equals("3.0")) {
            for (int ii = 0; ii < this.listeners.size(); ++ii) {
                if (!this.listeners.get(ii).getListenerName().equals(listener.getListenerName())) continue;
                this.listeners.remove(ii);
                LOG.debug("Removed duplicate listener with name: " + listener.getListenerName());
                break;
            }
        } else if (this.listeners.remove(listener)) {
            LOG.debug("Removed duplicate listener for class: " + listener.getListenerClass());
        }
        if (listener.getListenerClass() != null && listener.getListenerClass().length() > 0) {
            this.listeners.add(listener);
            Collections.sort(this.listeners, new ListenerComparator());
        } else {
            LOG.debug("No listener class for listener: " + listener.getListenerName());
        }
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    public List<SecurityConstraint> getSecurityConstraints() {
        ArrayList<SecurityConstraint> scs = new ArrayList<SecurityConstraint>();
        for (SecurityConstraint sc : this.constraints) {
            scs.add(new SecurityConstraintImpl(sc));
        }
        return scs;
    }

    public void addSecurityConstraint(SecurityConstraint sc) {
        if (this.constraints.remove(sc)) {
            LOG.debug("Removed duplicate security constraint: " + sc.getUserDataConstraint().getTransportGuarantee());
        }
        this.constraints.add(sc);
    }

    public boolean removeSecurityCOnstraint(SecurityConstraint sc) {
        return this.constraints.remove(sc);
    }

    public Map<Locale, String> getLocaleEncodingMappings() {
        HashMap<Locale, String> lem = new HashMap<Locale, String>();
        for (Locale l : this.localemap.keySet()) {
            lem.put((Locale)l.clone(), this.localemap.get(l));
        }
        return lem;
    }

    public void addLocaleEncodingMapping(Locale locale, String encoding) {
        this.localemap.put(locale, encoding);
    }

    public String removeLocaleEncodingMapping(Locale locale) {
        return this.localemap.remove(locale);
    }
}

