/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.ClassUtils;
import org.apache.pulsar.tests.BetweenTestClassesListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonCleanerListener
extends BetweenTestClassesListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SingletonCleanerListener.class);
    private static final Method OBJECTMAPPERFACTORY_CLEARCACHES_METHOD;
    private static final Method JSONSCHEMA_CLEARCACHES_METHOD;

    @Override
    protected void onBetweenTestClasses(Class<?> endedTestClass, Class<?> startedTestClass) {
        SingletonCleanerListener.objectMapperFactoryClearCaches();
        SingletonCleanerListener.jsonSchemaClearCaches();
    }

    private static void objectMapperFactoryClearCaches() {
        if (OBJECTMAPPERFACTORY_CLEARCACHES_METHOD != null) {
            try {
                OBJECTMAPPERFACTORY_CLEARCACHES_METHOD.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn("Cannot clean singleton ObjectMapper caches", (Throwable)e);
            }
        }
    }

    private static void jsonSchemaClearCaches() {
        if (JSONSCHEMA_CLEARCACHES_METHOD != null) {
            try {
                JSONSCHEMA_CLEARCACHES_METHOD.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn("Cannot clean singleton JSONSchema caches", (Throwable)e);
            }
        }
    }

    static {
        Class<?> objectMapperFactoryClazz = null;
        try {
            objectMapperFactoryClazz = ClassUtils.getClass("org.apache.pulsar.common.util.ObjectMapperFactory");
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Cannot find ObjectMapperFactory class", (Throwable)e);
        }
        Method clearCachesMethod = null;
        try {
            if (objectMapperFactoryClazz != null) {
                clearCachesMethod = objectMapperFactoryClazz.getMethod("clearCaches", new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Cannot find method for clearing singleton ObjectMapper caches", (Throwable)e);
        }
        OBJECTMAPPERFACTORY_CLEARCACHES_METHOD = clearCachesMethod;
        Class<?> jsonSchemaClazz = null;
        try {
            jsonSchemaClazz = ClassUtils.getClass("org.apache.pulsar.client.impl.schema.JSONSchema");
        }
        catch (ClassNotFoundException e) {
            LOG.warn("Cannot find JSONSchema class", (Throwable)e);
        }
        Method jsonSchemaCleanCachesMethod = null;
        try {
            if (jsonSchemaClazz != null) {
                jsonSchemaCleanCachesMethod = jsonSchemaClazz.getMethod("clearCaches", new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            LOG.warn("Cannot find method for clearing singleton JSONSchema caches", (Throwable)e);
        }
        JSONSCHEMA_CLEARCACHES_METHOD = jsonSchemaCleanCachesMethod;
    }
}

